/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.service.requestcontext.session.encoder;

import com.alibaba.citrus.service.requestcontext.session.SessionStore;
import com.alibaba.citrus.service.requestcontext.session.encoder.SessionEncoder;
import com.alibaba.citrus.service.requestcontext.session.encoder.SessionEncoderException;
import com.alibaba.citrus.service.requestcontext.session.encrypter.Encrypter;
import com.alibaba.citrus.service.requestcontext.session.serializer.Serializer;
import com.alibaba.citrus.service.requestcontext.session.serializer.impl.HessianSerializer;
import com.alibaba.citrus.springext.support.BeanSupport;
import com.alibaba.citrus.util.ArrayUtil;
import com.alibaba.citrus.util.Assert;
import com.alibaba.citrus.util.io.ByteArrayOutputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Map;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import org.apache.commons.codec.binary.Base64;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSerializationEncoder
extends BeanSupport
implements SessionEncoder {
    protected Serializer serializer;
    protected Encrypter encrypter;

    @Override
    protected void init() throws Exception {
        if (this.serializer == null) {
            this.serializer = new HessianSerializer();
        }
    }

    @Override
    public String encode(Map<String, Object> attrs, SessionStore.StoreContext storeContext) throws SessionEncoderException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Deflater def = new Deflater(9, false);
        DeflaterOutputStream dos = new DeflaterOutputStream((OutputStream)baos, def);
        try {
            this.serializer.serialize(Assert.assertNotNull(attrs, "objectToEncode is null", new Object[0]), dos);
        }
        catch (Exception e) {
            throw new SessionEncoderException("Failed to encode session state", e);
        }
        finally {
            try {
                dos.close();
            }
            catch (IOException e) {}
            def.end();
        }
        byte[] plaintext = baos.toByteArray().toByteArray();
        byte[] cryptotext = this.encrypt(plaintext);
        try {
            String encodedValue = new String(Base64.encodeBase64((byte[])cryptotext, (boolean)false), "ISO-8859-1");
            return URLEncoder.encode(encodedValue, "ISO-8859-1");
        }
        catch (UnsupportedEncodingException e) {
            throw new SessionEncoderException("Failed to encode session state", e);
        }
    }

    private byte[] encrypt(byte[] plaintext) throws SessionEncoderException {
        if (this.encrypter != null) {
            return this.encrypter.encrypt(plaintext);
        }
        return plaintext;
    }

    @Override
    public Map<String, Object> decode(String encodedValue, SessionStore.StoreContext storeContext) throws SessionEncoderException {
        byte[] cryptotext = null;
        try {
            encodedValue = URLDecoder.decode(Assert.assertNotNull(encodedValue, "encodedValue is null", new Object[0]), "ISO-8859-1");
            cryptotext = Base64.decodeBase64((byte[])encodedValue.getBytes("ISO-8859-1"));
            if (ArrayUtil.isEmptyArray(cryptotext)) {
                throw new SessionEncoderException("Session state is empty: " + encodedValue);
            }
        }
        catch (Exception e) {
            throw new SessionEncoderException("Failed to decode session state: ", e);
        }
        byte[] plaintext = this.decrypt(cryptotext);
        if (ArrayUtil.isEmptyArray(plaintext)) {
            throw new SessionEncoderException("Decrypted session state is empty: " + encodedValue);
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(plaintext);
        Inflater inf = new Inflater(false);
        InflaterInputStream iis = new InflaterInputStream(bais, inf);
        try {
            Map attrs;
            Map map = attrs = (Map)this.serializer.deserialize(iis);
            return map;
        }
        catch (Exception e) {
            throw new SessionEncoderException("Failed to parse session state", e);
        }
        finally {
            try {
                iis.close();
            }
            catch (IOException e) {}
            inf.end();
        }
    }

    private byte[] decrypt(byte[] cryptotext) throws SessionEncoderException {
        if (this.encrypter != null) {
            return this.encrypter.decrypt(cryptotext);
        }
        return cryptotext;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.serializer + ", " + (this.encrypter == null ? "no encrypter" : this.encrypter) + "]";
    }
}

