/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.service.resource.impl;

import com.alibaba.citrus.service.resource.Resource;
import com.alibaba.citrus.service.resource.ResourceLister;
import com.alibaba.citrus.service.resource.ResourceListerContext;
import com.alibaba.citrus.service.resource.ResourceLoader;
import com.alibaba.citrus.service.resource.ResourceLoaderContext;
import com.alibaba.citrus.service.resource.ResourceLoadingOption;
import com.alibaba.citrus.service.resource.impl.ResourceMapping;
import com.alibaba.citrus.util.ToStringBuilder;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceLoaderMapping
extends ResourceMapping {
    private ResourceLoader[] loaders;

    public ResourceLoader[] getLoaders() {
        return this.loaders;
    }

    public void setLoaders(ResourceLoader[] loaders) {
        this.loaders = loaders;
    }

    @Override
    public String getPatternType() {
        return "resource";
    }

    @Override
    protected void init() {
        if (this.loaders == null) {
            this.loaders = new ResourceLoader[0];
        }
        for (ResourceLoader loader : this.loaders) {
            loader.init(this.getResourceLoadingService());
        }
    }

    public Resource getResource(ResourceLoaderContext context, Set<ResourceLoadingOption> options) {
        Resource firstResult = null;
        for (ResourceLoader loader : this.loaders) {
            Resource resource = loader.getResource(context, options);
            if (resource == null) continue;
            if (resource.exists()) {
                return resource;
            }
            if (firstResult != null) continue;
            firstResult = resource;
        }
        return firstResult;
    }

    public String[] list(ResourceListerContext context, Set<ResourceLoadingOption> options) {
        for (ResourceLoader loader : this.loaders) {
            String[] names;
            if (!(loader instanceof ResourceLister) || (names = ((ResourceLister)loader).list(context, options)) == null) continue;
            return names;
        }
        return null;
    }

    public String toString() {
        ToStringBuilder.MapBuilder mb = new ToStringBuilder.MapBuilder();
        mb.append("pattern", this.getPatternName());
        if (this.isInternal()) {
            mb.append("internal", this.isInternal());
        }
        mb.append("loaders", this.getLoaders());
        return new ToStringBuilder().append(this.getClass().getSimpleName()).append(mb).toString();
    }
}

