/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.service.template.impl;

import com.alibaba.citrus.service.template.impl.TemplateSearchingStrategy;
import com.alibaba.citrus.util.ArrayUtil;
import com.alibaba.citrus.util.Assert;
import com.alibaba.citrus.util.BasicConstant;
import com.alibaba.citrus.util.FileUtil;
import com.alibaba.citrus.util.ObjectUtil;
import com.alibaba.citrus.util.StringUtil;
import java.util.Arrays;

public final class TemplateKey {
    private final String templateNameWithoutExtension;
    private final String extension;
    private final Object[] strategyKeys;

    public TemplateKey(String templateName, TemplateSearchingStrategy[] strategies) {
        templateName = Assert.assertNotNull(StringUtil.trimToNull(FileUtil.normalizeAbsolutePath(templateName)), "illegal templateName: %s", templateName);
        FileUtil.FileNameAndExtension names = FileUtil.getFileNameAndExtension(templateName, true);
        this.templateNameWithoutExtension = names.getFileName();
        this.extension = names.getExtension();
        if (ArrayUtil.isEmptyArray(strategies)) {
            this.strategyKeys = BasicConstant.EMPTY_OBJECT_ARRAY;
        } else {
            this.strategyKeys = new Object[strategies.length];
            for (int i = 0; i < strategies.length; ++i) {
                this.strategyKeys[i] = strategies[i].getKey(this.getTemplateName());
            }
        }
    }

    public String getTemplateName() {
        return TemplateKey.getTemplateName(this.templateNameWithoutExtension, this.extension);
    }

    public String getTemplateNameWithoutExtension() {
        return this.templateNameWithoutExtension;
    }

    public String getExtension() {
        return this.extension;
    }

    public Object[] getStrategyKeys() {
        return (Object[])this.strategyKeys.clone();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!(other instanceof TemplateKey)) {
            return false;
        }
        TemplateKey otherKey = (TemplateKey)other;
        if (!ObjectUtil.isEquals(this.templateNameWithoutExtension, otherKey.templateNameWithoutExtension)) {
            return false;
        }
        if (!ObjectUtil.isEquals(this.extension, otherKey.extension)) {
            return false;
        }
        return Arrays.equals(this.strategyKeys, otherKey.strategyKeys);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.extension == null ? 0 : this.extension.hashCode());
        result = 31 * result + Arrays.hashCode(this.strategyKeys);
        result = 31 * result + (this.templateNameWithoutExtension == null ? 0 : this.templateNameWithoutExtension.hashCode());
        return result;
    }

    public String toString() {
        return this.getTemplateName() + Arrays.toString(this.strategyKeys);
    }

    public static String getTemplateName(String templateNameWithoutExtension, String extension) {
        String templateName = templateNameWithoutExtension;
        if (!StringUtil.isEmpty(extension)) {
            templateName = templateNameWithoutExtension + "." + extension;
        }
        return templateName;
    }
}

