/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.service.template.impl;

import com.alibaba.citrus.service.AbstractService;
import com.alibaba.citrus.service.configuration.ProductionModeAware;
import com.alibaba.citrus.service.template.TemplateContext;
import com.alibaba.citrus.service.template.TemplateEngine;
import com.alibaba.citrus.service.template.TemplateException;
import com.alibaba.citrus.service.template.TemplateNotFoundException;
import com.alibaba.citrus.service.template.TemplateService;
import com.alibaba.citrus.service.template.impl.DefaultExtensionStrategy;
import com.alibaba.citrus.service.template.impl.SearchExtensionsStrategy;
import com.alibaba.citrus.service.template.impl.SearchLocalizedTemplatesStrategy;
import com.alibaba.citrus.service.template.impl.TemplateKey;
import com.alibaba.citrus.service.template.impl.TemplateMatchResult;
import com.alibaba.citrus.service.template.impl.TemplateMatchResultImpl;
import com.alibaba.citrus.service.template.impl.TemplateMatcher;
import com.alibaba.citrus.service.template.impl.TemplateSearchingStrategy;
import com.alibaba.citrus.util.Assert;
import com.alibaba.citrus.util.CollectionUtil;
import com.alibaba.citrus.util.FileUtil;
import com.alibaba.citrus.util.StringUtil;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TemplateServiceImpl
extends AbstractService<TemplateService>
implements TemplateService,
ProductionModeAware {
    private Map<String, TemplateEngine> engines;
    private Map<String, TemplateEngine> engineMappings;
    private Map<String, String> engineNameMappings;
    private String defaultExtension;
    private boolean searchExtensions;
    private boolean searchLocalizedTemplates;
    private TemplateSearchingStrategy[] strategies;
    private Boolean cacheEnabled;
    private boolean productionMode = true;
    private Map<TemplateKey, TemplateMatchResult> matchedTemplates;

    public void setEngines(Map<String, TemplateEngine> engines) {
        this.engines = engines;
    }

    public void setEngineNameMappings(Map<String, String> engineNameMappings) {
        this.engineNameMappings = engineNameMappings;
    }

    public void setDefaultExtension(String defaultExtension) {
        this.defaultExtension = defaultExtension;
    }

    public void setSearchExtensions(boolean searchExtensions) {
        this.searchExtensions = searchExtensions;
    }

    public void setSearchLocalizedTemplates(boolean searchLocalizedTemplates) {
        this.searchLocalizedTemplates = searchLocalizedTemplates;
    }

    public Boolean isCacheEnabled() {
        return this.cacheEnabled;
    }

    public void setCacheEnabled(Boolean cacheEnabled) {
        this.cacheEnabled = cacheEnabled;
    }

    public boolean isProductionMode() {
        return this.productionMode;
    }

    @Override
    public void setProductionMode(boolean productionMode) {
        this.productionMode = productionMode;
    }

    @Override
    protected void init() {
        if (this.engines == null) {
            this.engines = CollectionUtil.createHashMap();
        }
        if (this.engines.isEmpty()) {
            this.getLogger().warn("No Template Engine registered for TemplateService: id={}", (Object)this.getBeanName());
        }
        if (this.cacheEnabled == null) {
            this.cacheEnabled = this.productionMode;
        }
        if (this.cacheEnabled.booleanValue()) {
            this.matchedTemplates = CollectionUtil.createConcurrentHashMap();
        }
        HashSet remappedNames = CollectionUtil.createHashSet();
        this.engineMappings = CollectionUtil.createTreeMap();
        if (this.engineNameMappings != null) {
            for (Map.Entry<String, Object> entry : this.engineNameMappings.entrySet()) {
                String ext = entry.getKey();
                String engineName = (String)entry.getValue();
                Assert.assertTrue(!StringUtil.isEmpty(ext) && !ext.startsWith("."), "Invalid extension: %s", ext);
                Assert.assertTrue(this.engines.containsKey(engineName), "TemplateEngine \"%s\" not defined.  Defined names: %s", engineName, this.engines.keySet());
                remappedNames.add(engineName);
                this.engineMappings.put(ext, this.engines.get(engineName));
                this.getLogger().debug("Template Name \"*.{}\" mapped to Template Engine: {}", (Object)ext, (Object)engineName);
            }
            this.engineNameMappings = null;
        }
        for (Map.Entry<String, Object> entry : this.engines.entrySet()) {
            String[] exts;
            String engineName = entry.getKey();
            TemplateEngine engine = (TemplateEngine)entry.getValue();
            if (remappedNames.contains(engineName)) continue;
            for (String ext : exts = engine.getDefaultExtensions()) {
                ext = FileUtil.normalizeExtension(ext);
                Assert.assertNotNull(ext, "default extensions for engine: %s", engine);
                this.engineMappings.put(ext, engine);
                this.getLogger().debug("Template Name \"*.{}\" mapped to Template Engine: {}", (Object)ext, (Object)engineName);
            }
        }
        this.defaultExtension = FileUtil.normalizeExtension(this.defaultExtension);
        LinkedList<TemplateSearchingStrategy> strategyList = CollectionUtil.createLinkedList();
        if (this.defaultExtension != null) {
            strategyList.add(new DefaultExtensionStrategy(this.defaultExtension));
        }
        if (this.searchExtensions) {
            strategyList.add(new SearchExtensionsStrategy(this.getSupportedExtensions()));
        }
        if (this.searchLocalizedTemplates) {
            strategyList.add(new SearchLocalizedTemplatesStrategy());
        }
        this.strategies = strategyList.toArray(new TemplateSearchingStrategy[strategyList.size()]);
    }

    public TemplateEngine getEngineOfName(String engineName) {
        return this.engines.get(engineName);
    }

    @Override
    public TemplateEngine getTemplateEngine(String extension) {
        if (extension == null) {
            return null;
        }
        return this.engineMappings.get(extension);
    }

    @Override
    public String[] getSupportedExtensions() {
        return this.engineMappings.keySet().toArray(new String[this.engineMappings.size()]);
    }

    @Override
    public boolean exists(String templateName) {
        try {
            this.findTemplate(templateName);
            return true;
        }
        catch (TemplateNotFoundException e) {
            return false;
        }
    }

    @Override
    public String getText(String templateName, TemplateContext context) throws TemplateException, IOException {
        TemplateMatchResult result = this.findTemplate(templateName);
        TemplateEngine engine = Assert.assertNotNull(result.getEngine(), "templateEngine", new Object[0]);
        return engine.getText(result.getTemplateName(), context);
    }

    @Override
    public void writeTo(String templateName, TemplateContext context, OutputStream ostream) throws TemplateException, IOException {
        TemplateMatchResult result = this.findTemplate(templateName);
        TemplateEngine engine = Assert.assertNotNull(result.getEngine(), "templateEngine", new Object[0]);
        engine.writeTo(result.getTemplateName(), context, ostream);
    }

    @Override
    public void writeTo(String templateName, TemplateContext context, Writer writer) throws TemplateException, IOException {
        TemplateMatchResult result = this.findTemplate(templateName);
        TemplateEngine engine = Assert.assertNotNull(result.getEngine(), "templateEngine", new Object[0]);
        engine.writeTo(result.getTemplateName(), context, writer);
    }

    TemplateMatchResult findTemplate(String templateName) {
        TemplateMatchResult result;
        this.assertInitialized();
        TemplateKey key = new TemplateKey(templateName, this.strategies);
        if (this.cacheEnabled.booleanValue() && (result = this.matchedTemplates.get(key)) != null) {
            return result;
        }
        TemplateMatcher matcher = new TemplateMatcher(key){
            private int i;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean findTemplate() {
                boolean found = false;
                String savedTemplateNameWithoutExtension = this.getTemplateNameWithoutExtension();
                String savedExtension = this.getExtension();
                TemplateEngine savedEngine = this.getEngine();
                int savedStrategyIndex = this.i;
                try {
                    found = this.i < TemplateServiceImpl.this.strategies.length ? TemplateServiceImpl.this.strategies[this.i++].findTemplate(this) : TemplateServiceImpl.this.findTemplateInTemplateEngine(this);
                }
                finally {
                    if (!found) {
                        this.setTemplateNameWithoutExtension(savedTemplateNameWithoutExtension);
                        this.setExtension(savedExtension);
                        this.setEngine(savedEngine);
                        this.i = savedStrategyIndex;
                    }
                }
                return found;
            }
        };
        if (!matcher.findTemplate()) {
            throw new TemplateNotFoundException("Could not find template \"" + matcher.getOriginalTemplateName() + "\"");
        }
        if (this.cacheEnabled.booleanValue()) {
            result = new TemplateMatchResultImpl(matcher.getTemplateName(), matcher.getEngine());
            this.matchedTemplates.put(key, result);
        } else {
            result = matcher;
        }
        return result;
    }

    private boolean findTemplateInTemplateEngine(TemplateMatcher matcher) {
        TemplateEngine engine = this.getTemplateEngine(matcher.getExtension());
        matcher.setEngine(engine);
        if (engine == null) {
            return false;
        }
        String templateName = matcher.getTemplateName();
        this.getLogger().trace("Searching for template \"{}\" using {}", (Object)templateName, (Object)engine);
        return engine.exists(templateName);
    }
}

