/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.service.uribroker.uri;

import com.alibaba.citrus.service.template.Renderable;
import com.alibaba.citrus.service.uribroker.interceptor.URIBrokerInterceptor;
import com.alibaba.citrus.service.uribroker.uri.URIBroker;
import com.alibaba.citrus.springext.util.SpringExtUtil;
import com.alibaba.citrus.util.Assert;
import com.alibaba.citrus.util.CollectionUtil;
import com.alibaba.citrus.util.StringEscapeUtil;
import com.alibaba.citrus.util.StringUtil;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class URIBrokerFeatures
implements Renderable {
    protected final Renderer renderer = new Renderer();
    private Boolean requestAware;
    private HttpServletRequest request;
    private URIBroker parent;
    private boolean initialized;
    private String charset;
    private boolean autoReset;
    private Map<URIBrokerInterceptor, Integer> interceptors;

    public void setRequest(HttpServletRequest request) {
        this.request = request;
    }

    public boolean isRequestAware() {
        return this.requestAware == null ? false : this.requestAware;
    }

    public void setRequestAware(boolean requestAware) {
        this.requestAware = requestAware;
    }

    public void setRequestAwareDefault(boolean requestAware) {
        if (this.requestAware == null) {
            this.requestAware = requestAware;
        }
    }

    public URIBroker getParent() {
        return this.parent;
    }

    public void setParent(URIBroker parent) {
        Assert.assertTrue(!this.initialized, Assert.ExceptionType.ILLEGAL_STATE, "already initialized", new Object[0]);
        if (parent != null) {
            this.parent = parent;
        }
    }

    public String getCharset() {
        return this.charset;
    }

    public void setCharset(String charset) {
        this.charset = StringUtil.trimToNull(charset);
    }

    public boolean isAutoReset() {
        return this.autoReset;
    }

    public boolean hasInterceptors() {
        return this.interceptors != null && !this.interceptors.isEmpty();
    }

    protected Map<URIBrokerInterceptor, Integer> getInterceptorStates() {
        if (this.interceptors == null) {
            this.interceptors = CollectionUtil.createLinkedHashMap();
        }
        return this.interceptors;
    }

    public Collection<URIBrokerInterceptor> getInterceptors() {
        return this.getInterceptorStates().keySet();
    }

    public void setInterceptors(Collection<URIBrokerInterceptor> interceptors) {
        this.clearInterceptors();
        for (URIBrokerInterceptor interceptor : interceptors) {
            this.addInterceptor(interceptor);
        }
    }

    public void addInterceptor(URIBrokerInterceptor interceptor) {
        this.getInterceptorStates().put(Assert.assertNotNull(interceptor, "interceptor", new Object[0]), null);
    }

    public void clearInterceptors() {
        if (this.interceptors != null) {
            this.interceptors.clear();
        }
    }

    public final void init() {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        if (this.parent != null) {
            this.parent.init();
            if (this.charset == null) {
                this.charset = this.parent.getCharset();
            }
            if (this.requestAware == null) {
                this.requestAware = this.parent.isRequestAware();
            }
            if (this.parent.hasInterceptors()) {
                this.mergeLinkedHashMap(this.parent.getInterceptorStates(), this.getInterceptorStates());
            }
            this.initDefaults(this.parent);
        }
        this.renderer.prerender();
    }

    protected abstract void initDefaults(URIBroker var1);

    public final void reset() {
        HttpServletRequest realRequest;
        URIBroker parent = this.parent;
        if (parent == null) {
            parent = this.newInstanceInternal();
        }
        this.charset = parent.getCharset();
        this.clearInterceptors();
        if (parent.hasInterceptors()) {
            for (Map.Entry<URIBrokerInterceptor, Integer> entry : parent.getInterceptorStates().entrySet()) {
                this.getInterceptorStates().put(entry.getKey(), entry.getValue());
            }
        }
        this.copyFrom(parent);
        if (parent.getClass().equals(this.getClass())) {
            this.renderer.copyFrom(parent.renderer);
        }
        if ((realRequest = this.getRealRequest()) != null) {
            this.populateWithRequest(realRequest);
        }
    }

    protected abstract void copyFrom(URIBroker var1);

    protected abstract void populateWithRequest(HttpServletRequest var1);

    protected final HttpServletRequest getRealRequest() {
        if (this.isRequestAware()) {
            return SpringExtUtil.getProxyTarget(this.request);
        }
        return null;
    }

    public final URIBroker fork() {
        return this.fork(true);
    }

    public final URIBroker fork(boolean autoReset) {
        URIBroker parentBroker;
        URIBroker broker = null;
        if (autoReset && this.isAutoReset()) {
            parentBroker = this.fork(false);
            parentBroker.renderer.prerender();
            this.reset();
        } else {
            parentBroker = (URIBroker)this;
        }
        broker = this.newInstanceInternal();
        broker.autoReset = autoReset;
        broker.setRequestAware(parentBroker.isRequestAware());
        broker.setRequest(parentBroker.request);
        broker.setParent(parentBroker);
        broker.reset();
        return broker;
    }

    protected final URIBroker newInstanceInternal() {
        URIBroker instance = Assert.assertNotNull(this.newInstance(), "%s.newInstance() returns null", this.getClass().getName());
        Assert.assertTrue(instance != this, "%s.newInstance() returns itself", this.getClass().getName());
        Assert.assertTrue(instance.getClass().equals(this.getClass()), "%s.newInstance() returns wrong type: %s", this.getClass().getName(), instance.getClass().getName());
        return instance;
    }

    protected abstract URIBroker newInstance();

    protected void processInterceptors() {
        if (this.hasInterceptors()) {
            for (Map.Entry<URIBrokerInterceptor, Integer> entry : this.getInterceptorStates().entrySet()) {
                if (entry.getValue() != null) continue;
                entry.setValue(1);
                entry.getKey().perform((URIBroker)this);
            }
        }
    }

    @Override
    public final String render() {
        return this.render(this.autoReset);
    }

    private String render(boolean reset) {
        if (reset) {
            this.processInterceptors();
        }
        StringBuilder buf = new StringBuilder();
        this.render(buf);
        if (reset) {
            this.reset();
        }
        return buf.toString();
    }

    protected abstract void render(StringBuilder var1);

    protected abstract void renderServer(StringBuilder var1);

    protected abstract void renderPath(StringBuilder var1);

    protected abstract void renderQuery(StringBuilder var1);

    protected final String escapeURL(String str) {
        String charset = StringUtil.trimToNull(this.getCharset());
        try {
            return StringEscapeUtil.escapeURL(str, charset);
        }
        catch (UnsupportedEncodingException e) {
            return StringEscapeUtil.escapeURL(str);
        }
    }

    protected final <K, V> void mergeLinkedHashMap(Map<K, V> parentMap, Map<K, V> thisMap) {
        Assert.assertNotNull(thisMap, "thisMap", new Object[0]);
        LinkedHashMap<K, V> thisMapCopy = CollectionUtil.createLinkedHashMap();
        thisMapCopy.putAll(thisMap);
        thisMap.clear();
        if (parentMap != null) {
            thisMap.putAll(parentMap);
        }
        thisMap.putAll(thisMapCopy);
    }

    public String toString() {
        return this.render(false);
    }

    public final class Renderer {
        protected final StringBuilder serverBuffer = new StringBuilder();
        protected final StringBuilder pathBuffer = new StringBuilder();
        protected final StringBuilder queryBuffer = new StringBuilder();

        public boolean isServerRendered() {
            return this.serverBuffer.length() > 0;
        }

        public boolean isPathRendered() {
            return this.pathBuffer.length() > 0;
        }

        public boolean isQueryRendered() {
            return this.queryBuffer.length() > 0;
        }

        public void clearServerBuffer() {
            this.serverBuffer.setLength(0);
        }

        public void clearPathBuffer() {
            this.pathBuffer.setLength(0);
        }

        public void updatePathBuffer(String path) {
            if (this.isPathRendered()) {
                this.pathBuffer.append("/").append(URIBrokerFeatures.this.escapeURL(path));
            }
        }

        public void truncatePathBuffer(int removedCount) {
            if (this.isPathRendered()) {
                int index = this.pathBuffer.length();
                for (int i = 0; i < removedCount && index >= 0; ++i) {
                    index = this.pathBuffer.lastIndexOf("/", index - 1);
                }
                if (index >= 0) {
                    this.pathBuffer.setLength(index);
                } else {
                    this.pathBuffer.setLength(0);
                }
            }
        }

        public void clearQueryBuffer() {
            this.queryBuffer.setLength(0);
        }

        public void updateQueryBuffer(String id, String value) {
            if (this.isQueryRendered()) {
                this.queryBuffer.append("&").append(URIBrokerFeatures.this.escapeURL(id)).append("=").append(URIBrokerFeatures.this.escapeURL(value));
            }
        }

        private void prerender() {
            if (!this.isServerRendered()) {
                URIBrokerFeatures.this.renderServer(this.serverBuffer);
            }
            if (!this.isPathRendered()) {
                URIBrokerFeatures.this.renderPath(this.pathBuffer);
            }
            if (!this.isQueryRendered()) {
                URIBrokerFeatures.this.renderQuery(this.queryBuffer);
            }
        }

        private void copyFrom(Renderer parent) {
            this.clearServerBuffer();
            if (parent.isServerRendered()) {
                this.serverBuffer.append((CharSequence)parent.serverBuffer);
            }
            this.clearPathBuffer();
            if (parent.isPathRendered()) {
                this.pathBuffer.append((CharSequence)parent.pathBuffer);
            }
            this.clearQueryBuffer();
            if (parent.isQueryRendered()) {
                this.queryBuffer.append((CharSequence)parent.queryBuffer);
            }
        }
    }
}

