/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.springext.impl;

import com.alibaba.citrus.springext.ConfigurationPoint;
import com.alibaba.citrus.springext.ConfigurationPointException;
import com.alibaba.citrus.springext.Contribution;
import com.alibaba.citrus.springext.ContributionType;
import com.alibaba.citrus.springext.ResourceResolver;
import com.alibaba.citrus.springext.Schema;
import com.alibaba.citrus.springext.SourceInfo;
import com.alibaba.citrus.springext.VersionableSchemas;
import com.alibaba.citrus.springext.impl.ConfigurationPointImpl;
import com.alibaba.citrus.springext.impl.ConfigurationPointSettings;
import com.alibaba.citrus.springext.impl.ContributionKey;
import com.alibaba.citrus.springext.impl.SchemaImpl;
import com.alibaba.citrus.springext.impl.VersionableSchemasImpl;
import com.alibaba.citrus.springext.support.ConfigurationPointSourceInfo;
import com.alibaba.citrus.springext.support.ContributionSourceInfo;
import com.alibaba.citrus.springext.support.SchemaUtil;
import com.alibaba.citrus.springext.support.SourceInfoSupport;
import com.alibaba.citrus.util.Assert;
import com.alibaba.citrus.util.CollectionUtil;
import com.alibaba.citrus.util.ToStringBuilder;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContributionImpl
implements Contribution,
ContributionSourceInfo {
    private static final Logger log = LoggerFactory.getLogger(Contribution.class);
    private final ConfigurationPoint configurationPoint;
    private final ConfigurationPointSettings settings;
    private final ContributionKey key;
    private final String implementationClassName;
    private final SourceInfo<ConfigurationPointSourceInfo> sourceInfo;
    private VersionableSchemas schemas;

    ContributionImpl(ConfigurationPointImpl cp, ConfigurationPointSettings settings, ContributionType type, String name, String contributionClassName, SourceInfo<ConfigurationPointSourceInfo> sourceInfo) {
        this.configurationPoint = Assert.assertNotNull(cp, "configurationPoint", new Object[0]);
        this.settings = settings;
        this.key = new ContributionKey(name, type);
        this.implementationClassName = contributionClassName;
        this.sourceInfo = Assert.assertNotNull(sourceInfo, "sourceInfo", new Object[0]);
    }

    @Override
    public ConfigurationPoint getConfigurationPoint() {
        return this.configurationPoint;
    }

    @Override
    public ContributionType getType() {
        return this.key.getType();
    }

    @Override
    public String getName() {
        return this.key.getName();
    }

    @Override
    public String getAnnotation() {
        Schema.Element element;
        Schema schema = this.getSchemas().getMainSchema();
        if (schema != null && (element = schema.getElement(this.getName())) != null) {
            return element.getAnnotation();
        }
        return null;
    }

    ContributionKey getKey() {
        return this.key;
    }

    @Override
    public String getImplementationClassName() {
        return this.implementationClassName;
    }

    @Override
    public VersionableSchemas getSchemas() {
        if (this.schemas == null) {
            String mainName = this.configurationPoint.getName() + "/" + this.getName();
            Schema mainSchema = this.loadMainSchema(mainName);
            Schema[] versionedSchemas = this.loadVersionedSchemas(mainName);
            this.schemas = new VersionableSchemasImpl(mainSchema, versionedSchemas);
        }
        return this.schemas;
    }

    private Schema loadMainSchema(String mainName) {
        String schemaName = mainName + "." + "xsd";
        ResourceResolver.Resource resource = this.settings.getResourceFromRelativeLocation(schemaName, log);
        if (resource == null) {
            return null;
        }
        log.debug("Found schema file for contribution {}: {}", (Object)mainName, (Object)resource);
        return SchemaImpl.createForContribution(schemaName, null, this.getDescription(), resource, new SourceInfoSupport<ContributionImpl>(this).setSource(resource), SchemaUtil.getContributionSchemaTransformer(this.getConfigurationPoint().getConfigurationPoints(), this));
    }

    private Schema[] loadVersionedSchemas(String mainName) {
        String schemaNamePattern = mainName + "-*." + "xsd";
        Pattern pattern = Pattern.compile("^.*(" + mainName + "-(.+)\\." + "xsd" + ")$");
        List<ResourceResolver.Resource> resources = this.settings.getResourcesFromRelativeLocationPattern(schemaNamePattern, log);
        Assert.assertNotNull(resources, schemaNamePattern, new Object[0]);
        LinkedList<Schema> schemas = CollectionUtil.createLinkedList();
        Iterator<ResourceResolver.Resource> i = resources.iterator();
        while (i.hasNext()) {
            ResourceResolver.Resource resource = i.next();
            String path = resource.getName();
            Matcher matcher = pattern.matcher(path);
            if (matcher.matches()) {
                String schemaName = matcher.group(1);
                String schemaVersion = matcher.group(2);
                if (this.checkVersion(schemaVersion)) {
                    schemas.add(SchemaImpl.createForContribution(schemaName, schemaVersion, this.getDescription(), resource, new SourceInfoSupport<ContributionImpl>(this).setSource(resource), SchemaUtil.getContributionSchemaTransformer(this.getConfigurationPoint().getConfigurationPoints(), this)));
                    continue;
                }
                i.remove();
                continue;
            }
            throw new ConfigurationPointException("Invalid schema name: " + resource);
        }
        if (!resources.isEmpty() && log.isDebugEnabled()) {
            ToStringBuilder buf = new ToStringBuilder();
            buf.format("Found %d versioned schema files for contribution %s:", resources.size(), mainName);
            buf.append(resources);
            log.debug(buf.toString());
        }
        return schemas.toArray(new Schema[schemas.size()]);
    }

    private boolean checkVersion(String schemaVersion) {
        String name = this.getName();
        for (String v : schemaVersion.split("-")) {
            name = name + "-" + v;
            for (ContributionType type : ContributionType.values()) {
                if (this.getConfigurationPoint().getContribution(name, type) == null) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public String getDescription() {
        return String.format("Contribution[%s:%s]", this.getConfigurationPoint().getName(), this.getName());
    }

    @Override
    public ConfigurationPointSourceInfo getParent() {
        return this.sourceInfo.getParent();
    }

    @Override
    public ResourceResolver.Resource getSource() {
        return this.sourceInfo.getSource();
    }

    @Override
    public int getLineNumber() {
        return this.sourceInfo.getLineNumber();
    }

    public String toString() {
        ToStringBuilder buf = new ToStringBuilder();
        buf.format("Contribution[toConfigurationPoint=%s, name=%s, type=%s, class=%s]", new Object[]{this.getConfigurationPoint().getName(), this.getName(), this.getType(), this.implementationClassName}).start();
        buf.append(this.getSchemas());
        return buf.end().toString();
    }
}

