/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.springext.support.parser;

import com.alibaba.citrus.springext.support.parser.NamedBeanDefinitionParserMixin;
import com.alibaba.citrus.springext.util.ProxyTargetFactory;
import com.alibaba.citrus.springext.util.SpringExtUtil;
import com.alibaba.citrus.util.StringUtil;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.xml.AbstractBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.io.ResourceLoader;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractNamedProxyBeanDefinitionParser
extends AbstractBeanDefinitionParser
implements NamedBeanDefinitionParserMixin.DefaultNameBDParser {
    private final NamedBeanDefinitionParserMixin mixin = new NamedBeanDefinitionParserMixin(this);

    protected abstract String getDefaultName();

    protected String resolveId(Element element, AbstractBeanDefinition definition, ParserContext parserContext) {
        return this.mixin.resolveId(element, definition, parserContext);
    }

    protected void registerBeanDefinition(BeanDefinitionHolder definition, BeanDefinitionRegistry registry) {
        this.mixin.registerBeanDefinition(definition, registry);
    }

    @Override
    public final String internal_getDefaultName() {
        return this.getDefaultName();
    }

    @Override
    public void super_registerBeanDefinition(BeanDefinitionHolder definition, BeanDefinitionRegistry registry) {
        super.registerBeanDefinition(definition, registry);
    }

    protected final AbstractBeanDefinition parseInternal(Element element, ParserContext parserContext) {
        ParserContext realBeanParserContext;
        BeanDefinitionBuilder proxyBuilder = BeanDefinitionBuilder.genericBeanDefinition(ProxyFactoryBean.class);
        AbstractBeanDefinitionParser realParser = this.getRealObjectParser();
        AbstractBeanDefinition realBd = (AbstractBeanDefinition)realParser.parse(element, realBeanParserContext = new ParserContext(parserContext.getReaderContext(), parserContext.getDelegate(), (BeanDefinition)proxyBuilder.getRawBeanDefinition()));
        String scope = StringUtil.trimToNull(this.getScope(element, realBd));
        if (scope == null || scope.equalsIgnoreCase("singleton") || scope.equalsIgnoreCase("prototype")) {
            return realBd;
        }
        realBd.setScope(scope);
        realBd.setAutowireCandidate(false);
        String targetBeanName = "proxyTarget." + this.resolveId(element, realBd, parserContext);
        this.registerBeanDefinition(new BeanDefinitionHolder((BeanDefinition)realBd, targetBeanName), parserContext.getRegistry());
        proxyBuilder.addConstructorArgValue(this.getProxyInterface(element));
        proxyBuilder.addConstructorArgValue((Object)targetBeanName);
        return proxyBuilder.getBeanDefinition();
    }

    protected abstract Class<?> getProxyInterface(Element var1);

    protected String getScope(Element element, AbstractBeanDefinition realBd) {
        return element.getAttribute("scope");
    }

    protected abstract AbstractBeanDefinitionParser getRealObjectParser();

    private static class ProxyTargetFactoryImpl
    implements ProxyTargetFactory {
        private final String targetBeanName;
        private final BeanFactory factory;

        public ProxyTargetFactoryImpl(String targetBeanName, BeanFactory factory) {
            this.targetBeanName = targetBeanName;
            this.factory = factory;
        }

        public Object getObject() {
            return this.factory.getBean(this.targetBeanName);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ProxyFactoryBean
    implements FactoryBean,
    BeanFactoryAware,
    ResourceLoaderAware {
        private final Class<?> targetBeanType;
        private final String targetBeanName;
        private BeanFactory factory;
        private ClassLoader loader;

        public ProxyFactoryBean(Class<?> targetBeanType, String targetBeanName) {
            this.targetBeanType = targetBeanType;
            this.targetBeanName = targetBeanName;
        }

        public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
            this.factory = beanFactory;
        }

        public void setResourceLoader(ResourceLoader resourceLoader) {
            this.loader = resourceLoader.getClassLoader();
        }

        public Class<?> getObjectType() {
            return this.targetBeanType;
        }

        public boolean isSingleton() {
            return true;
        }

        public Object getObject() throws Exception {
            return SpringExtUtil.createProxy(this.targetBeanType, this.loader, new ProxyTargetFactoryImpl(this.targetBeanName, this.factory));
        }
    }
}

