/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.turbine.dataresolver.impl;

import com.alibaba.citrus.generictype.TypeInfoUtil;
import com.alibaba.citrus.service.dataresolver.DataResolver;
import com.alibaba.citrus.service.dataresolver.DataResolverContext;
import com.alibaba.citrus.service.dataresolver.DataResolverFactory;
import com.alibaba.citrus.service.form.Field;
import com.alibaba.citrus.service.form.Form;
import com.alibaba.citrus.service.form.FormService;
import com.alibaba.citrus.service.form.Group;
import com.alibaba.citrus.service.form.configuration.FieldConfig;
import com.alibaba.citrus.service.form.configuration.GroupConfig;
import com.alibaba.citrus.service.moduleloader.SkipModuleExecutionException;
import com.alibaba.citrus.springext.support.parser.AbstractSingleBeanDefinitionParser;
import com.alibaba.citrus.springext.util.SpringExtUtil;
import com.alibaba.citrus.turbine.dataresolver.FormData;
import com.alibaba.citrus.turbine.dataresolver.FormField;
import com.alibaba.citrus.turbine.dataresolver.FormFields;
import com.alibaba.citrus.turbine.dataresolver.FormGroup;
import com.alibaba.citrus.turbine.dataresolver.FormGroups;
import com.alibaba.citrus.turbine.dataresolver.impl.AbstractDataResolver;
import com.alibaba.citrus.turbine.dataresolver.impl.DataResolverUtil;
import com.alibaba.citrus.util.Assert;
import com.alibaba.citrus.util.StringUtil;
import java.util.ArrayList;
import java.util.Collection;
import net.sf.cglib.reflect.FastConstructor;
import org.springframework.beans.TypeMismatchException;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.core.MethodParameter;
import org.w3c.dom.Element;

public class FormResolverFactory
implements DataResolverFactory {
    private final FormService formService;

    public FormResolverFactory(FormService formService) {
        this.formService = formService;
    }

    public DataResolver getDataResolver(DataResolverContext context) {
        Assert.assertNotNull(this.formService, "no FormService defined", new Object[0]);
        Class<Form> paramType = context.getTypeInfo().getRawType();
        FormData formAnnotation = context.getAnnotation(FormData.class);
        if (formAnnotation != null || paramType.isAssignableFrom(Form.class)) {
            return new FormResolver(context, paramType, formAnnotation);
        }
        FormGroup groupAnnotation = context.getAnnotation(FormGroup.class);
        if (groupAnnotation != null) {
            return new GroupResolver(context, paramType, groupAnnotation);
        }
        FormField fieldAnnotation = context.getAnnotation(FormField.class);
        if (fieldAnnotation != null) {
            return new FieldResolver(context, paramType, fieldAnnotation);
        }
        FormGroups groupsAnnotation = context.getAnnotation(FormGroups.class);
        if (groupsAnnotation != null) {
            return new GroupsResolver(context, paramType, groupsAnnotation);
        }
        FormFields fieldsAnnotation = context.getAnnotation(FormFields.class);
        if (fieldsAnnotation != null) {
            return new FieldsResolver(context, paramType, fieldsAnnotation);
        }
        return null;
    }

    private boolean isConverterQuiet(Form form) {
        return form.getFormConfig().isConverterQuiet();
    }

    private boolean isValidatedAndValid(Form form) {
        if (!form.isValid() || form.getGroups().isEmpty()) {
            return false;
        }
        for (Group group : form.getGroups()) {
            if (group.isValidated()) continue;
            return false;
        }
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DefinitionParser
    extends AbstractSingleBeanDefinitionParser<FormResolverFactory> {
        protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
            SpringExtUtil.addConstructorArg(builder, false, FormService.class);
        }
    }

    private abstract class AbstractFormResolver
    extends AbstractDataResolver {
        protected boolean skipIfInvalid;

        private AbstractFormResolver(String desc, DataResolverContext context) {
            super(desc, context);
        }

        protected final void skipModuleExecutionIfNecessary(boolean valid, Object valueForNonSkippable) throws SkipModuleExecutionException {
            if (this.skipIfInvalid && !valid) {
                throw new SkipModuleExecutionException("Form data is not valid", valueForNonSkippable);
            }
        }

        protected final GroupConfig getGroupConfig(String groupName) {
            groupName = Assert.assertNotNull(StringUtil.trimToNull(groupName), "group name is empty", new Object[0]);
            return Assert.assertNotNull(FormResolverFactory.this.formService.getFormConfig().getGroupConfig(groupName), "group \"%s\" does not defined", groupName);
        }

        protected final FieldConfig getFieldConfig(String groupName, String fieldName) {
            GroupConfig groupConfig = this.getGroupConfig(groupName);
            fieldName = Assert.assertNotNull(StringUtil.trimToNull(fieldName), "field name is empty", new Object[0]);
            return Assert.assertNotNull(groupConfig.getFieldConfig(fieldName), "field \"%s.%s\" does not defined", groupConfig.getName(), fieldName);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FieldsResolver
    extends AbstractFormResolver {
        private final String groupName;
        private final String fieldName;
        private final Class<?> componentType;

        public FieldsResolver(DataResolverContext context, Class<?> paramType, FormFields fieldsAnnotation) {
            super("FieldsResolver", context);
            this.skipIfInvalid = fieldsAnnotation.skipIfInvalid();
            this.groupName = this.getGroupConfig(fieldsAnnotation.group()).getName();
            this.fieldName = this.getFieldConfig(this.groupName, fieldsAnnotation.name()).getName();
            this.componentType = paramType.isArray() ? paramType.getComponentType() : (Collection.class.isAssignableFrom(paramType) ? TypeInfoUtil.resolveIterableElement(context.getTypeInfo()).getRawType() : null);
            Assert.assertTrue(this.componentType != null && !Object.class.equals(this.componentType), "Invalid paramType: %s", context.getTypeInfo());
        }

        @Override
        public Object resolve() {
            Form form = FormResolverFactory.this.formService.getForm();
            Collection<Group> groups = form.getGroups(this.groupName);
            ArrayList<Field> fields = new ArrayList<Field>(groups.size());
            for (Group group : groups) {
                fields.add(group.getField(this.fieldName));
            }
            boolean valid = FormResolverFactory.this.isValidatedAndValid(form);
            if (this.componentType.isAssignableFrom(Field.class)) {
                Object result = null;
                try {
                    result = form.getTypeConverter().convertIfNecessary(fields, this.context.getTypeInfo().getRawType(), this.context.getExtraObject(MethodParameter.class));
                }
                catch (TypeMismatchException e) {
                    if (!FormResolverFactory.this.isConverterQuiet(form)) {
                        throw e;
                    }
                    return null;
                }
                this.skipModuleExecutionIfNecessary(valid, result);
                return result;
            }
            this.skipModuleExecutionIfNecessary(valid, null);
            if (!valid) {
                return null;
            }
            Object[] results = new Object[fields.size()];
            for (int i = 0; i < results.length; ++i) {
                try {
                    results[i] = ((Field)fields.get(i)).getValueOfType(this.componentType, this.context.getExtraObject(MethodParameter.class), null);
                    continue;
                }
                catch (TypeMismatchException e) {
                    if (!FormResolverFactory.this.isConverterQuiet(form)) {
                        throw e;
                    }
                    results[i] = null;
                }
            }
            try {
                return form.getTypeConverter().convertIfNecessary((Object)results, this.context.getTypeInfo().getRawType(), this.context.getExtraObject(MethodParameter.class));
            }
            catch (TypeMismatchException e) {
                if (!FormResolverFactory.this.isConverterQuiet(form)) {
                    throw e;
                }
                return null;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class GroupsResolver
    extends AbstractFormResolver {
        private final String groupName;
        private final Class<?> componentType;
        private final FastConstructor fc;

        public GroupsResolver(DataResolverContext context, Class<?> paramType, FormGroups groupsAnnotation) {
            super("GroupResolver", context);
            this.skipIfInvalid = groupsAnnotation.skipIfInvalid();
            this.groupName = this.getGroupConfig(DataResolverUtil.getAnnotationNameOrValue(FormGroups.class, groupsAnnotation, context, !this.skipIfInvalid)).getName();
            this.componentType = paramType.isArray() ? paramType.getComponentType() : (Collection.class.isAssignableFrom(paramType) ? TypeInfoUtil.resolveIterableElement(context.getTypeInfo()).getRawType() : null);
            Assert.assertTrue(this.componentType != null && !Object.class.equals(this.componentType), "Invalid paramType: %s", context.getTypeInfo());
            this.fc = !this.componentType.isAssignableFrom(Group.class) ? DataResolverUtil.getFastConstructor(this.componentType) : null;
        }

        @Override
        public Object resolve() {
            Form form = FormResolverFactory.this.formService.getForm();
            Collection<Group> groups = form.getGroups(this.groupName);
            boolean valid = FormResolverFactory.this.isValidatedAndValid(form);
            if (this.fc == null) {
                Object result = null;
                try {
                    result = form.getTypeConverter().convertIfNecessary(groups, this.context.getTypeInfo().getRawType(), this.context.getExtraObject(MethodParameter.class));
                }
                catch (TypeMismatchException e) {
                    if (!FormResolverFactory.this.isConverterQuiet(form)) {
                        throw e;
                    }
                    return null;
                }
                this.skipModuleExecutionIfNecessary(valid, result);
                return result;
            }
            this.skipModuleExecutionIfNecessary(valid, null);
            if (!valid) {
                return null;
            }
            Object[] results = new Object[groups.size()];
            int i = 0;
            for (Group group : groups) {
                Object object = DataResolverUtil.newInstance(this.fc);
                group.setProperties(object);
                results[i++] = object;
            }
            try {
                return form.getTypeConverter().convertIfNecessary((Object)results, this.context.getTypeInfo().getRawType(), this.context.getExtraObject(MethodParameter.class));
            }
            catch (TypeMismatchException e) {
                if (!FormResolverFactory.this.isConverterQuiet(form)) {
                    throw e;
                }
                return null;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FieldResolver
    extends AbstractFormResolver {
        private final String groupName;
        private final String groupInstanceKey;
        private final String fieldName;

        public FieldResolver(DataResolverContext context, Class<?> paramType, FormField fieldAnnotation) {
            super("FieldResolver", context);
            this.groupName = this.getGroupConfig(fieldAnnotation.group()).getName();
            this.fieldName = this.getFieldConfig(this.groupName, fieldAnnotation.name()).getName();
            this.groupInstanceKey = StringUtil.trimToNull(fieldAnnotation.groupInstanceKey());
            this.skipIfInvalid = fieldAnnotation.skipIfInvalid();
        }

        @Override
        public Object resolve() {
            block4: {
                Form form = FormResolverFactory.this.formService.getForm();
                Group group = form.getGroup(this.groupName, this.groupInstanceKey);
                Field field = group.getField(this.fieldName);
                boolean valid = FormResolverFactory.this.isValidatedAndValid(form);
                if (this.context.getTypeInfo().getRawType().isAssignableFrom(Field.class)) {
                    this.skipModuleExecutionIfNecessary(valid, field);
                    return field;
                }
                this.skipModuleExecutionIfNecessary(valid, null);
                if (valid) {
                    try {
                        return field.getValueOfType(this.context.getTypeInfo().getRawType(), this.context.getExtraObject(MethodParameter.class), null);
                    }
                    catch (TypeMismatchException e) {
                        if (FormResolverFactory.this.isConverterQuiet(form)) break block4;
                        throw e;
                    }
                }
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class GroupResolver
    extends AbstractFormResolver {
        private final String groupName;
        private final String groupInstanceKey;
        private final FastConstructor fc;

        public GroupResolver(DataResolverContext context, Class<?> paramType, FormGroup groupAnnotation) {
            super("GroupResolver", context);
            this.groupInstanceKey = StringUtil.trimToNull(groupAnnotation.instanceKey());
            this.skipIfInvalid = groupAnnotation.skipIfInvalid();
            this.groupName = this.getGroupConfig(DataResolverUtil.getAnnotationNameOrValue(FormGroup.class, groupAnnotation, context, this.groupInstanceKey != null || !this.skipIfInvalid)).getName();
            this.fc = !paramType.isAssignableFrom(Group.class) ? DataResolverUtil.getFastConstructor(paramType) : null;
        }

        @Override
        public Object resolve() {
            Form form = FormResolverFactory.this.formService.getForm();
            Group group = form.getGroup(this.groupName, this.groupInstanceKey);
            boolean valid = FormResolverFactory.this.isValidatedAndValid(form);
            if (this.fc == null) {
                this.skipModuleExecutionIfNecessary(valid, group);
                return group;
            }
            this.skipModuleExecutionIfNecessary(valid, null);
            if (valid) {
                Object object = DataResolverUtil.newInstance(this.fc);
                group.setProperties(object);
                return object;
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FormResolver
    extends AbstractFormResolver {
        public FormResolver(DataResolverContext context, Class<?> paramType, FormData formAnnotation) {
            super("FormResolver", context);
            Assert.assertTrue(paramType.isAssignableFrom(Form.class), "Parameter type annotated with @FormData should be Form", new Object[0]);
            this.skipIfInvalid = true;
            if (formAnnotation != null) {
                this.skipIfInvalid = formAnnotation.skipIfInvalid();
            }
        }

        @Override
        public Object resolve() {
            Form form = FormResolverFactory.this.formService.getForm();
            this.skipModuleExecutionIfNecessary(FormResolverFactory.this.isValidatedAndValid(form), form);
            return form;
        }
    }
}

