/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.turbine.dataresolver.impl;

import com.alibaba.citrus.service.dataresolver.DataResolver;
import com.alibaba.citrus.service.dataresolver.DataResolverContext;
import com.alibaba.citrus.service.dataresolver.DataResolverFactory;
import com.alibaba.citrus.service.moduleloader.ModuleInfo;
import com.alibaba.citrus.service.requestcontext.RequestContext;
import com.alibaba.citrus.service.requestcontext.parser.CookieParser;
import com.alibaba.citrus.service.requestcontext.parser.ParameterParser;
import com.alibaba.citrus.service.requestcontext.util.RequestContextUtil;
import com.alibaba.citrus.springext.support.parser.AbstractSingleBeanDefinitionParser;
import com.alibaba.citrus.springext.util.SpringExtUtil;
import com.alibaba.citrus.turbine.Context;
import com.alibaba.citrus.turbine.TurbineRunDataInternal;
import com.alibaba.citrus.turbine.dataresolver.ContextValue;
import com.alibaba.citrus.turbine.dataresolver.impl.AbstractDataResolver;
import com.alibaba.citrus.turbine.util.TurbineUtil;
import com.alibaba.citrus.util.Assert;
import com.alibaba.citrus.util.ClassUtil;
import com.alibaba.citrus.util.StringUtil;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

public class TurbineRunDataResolverFactory
implements DataResolverFactory {
    private static final Logger log = LoggerFactory.getLogger(TurbineRunDataResolverFactory.class);
    private static final int index_TurbineRunData = 0;
    private static final int index_HttpServletRequest = 1;
    private static final int index_HttpServletResponse = 2;
    private static final int index_HttpSession = 3;
    private static final int index_ServletContext = 4;
    private static final int index_Parameters = 5;
    private static final int index_Cookies = 6;
    private static final int index_Context = 7;
    private static final int index_RequestContext = 8;
    private final HttpServletRequest request;

    public TurbineRunDataResolverFactory(HttpServletRequest request) {
        this.request = SpringExtUtil.assertProxy(request);
    }

    private int getResolvableTypeIndex(DataResolverContext context) {
        Class<Object> type = context.getTypeInfo().getRawType();
        if (type.equals(Object.class)) {
            return -1;
        }
        if (type.isAssignableFrom(TurbineRunDataInternal.class)) {
            return 0;
        }
        if (type.isAssignableFrom(HttpServletRequest.class)) {
            return 1;
        }
        if (type.isAssignableFrom(HttpServletResponse.class)) {
            return 2;
        }
        if (type.isAssignableFrom(HttpSession.class)) {
            return 3;
        }
        if (type.isAssignableFrom(ServletContext.class)) {
            return 4;
        }
        if (type.isAssignableFrom(ParameterParser.class)) {
            return 5;
        }
        if (type.isAssignableFrom(CookieParser.class)) {
            return 6;
        }
        if (type.isAssignableFrom(Context.class)) {
            return 7;
        }
        if (RequestContext.class.isAssignableFrom(type)) {
            return 8;
        }
        return -1;
    }

    public DataResolver getDataResolver(DataResolverContext context) {
        Assert.assertNotNull(this.request, "no HttpServletRequest proxy defined", new Object[0]);
        int resolvableTypeIndex = this.getResolvableTypeIndex(context);
        if (resolvableTypeIndex < 0) {
            ContextValue contextValueAnnotation = context.getAnnotation(ContextValue.class);
            if (contextValueAnnotation != null) {
                String name = Assert.assertNotNull(StringUtil.trimToNull(contextValueAnnotation.value()), "missing @%s's name: %s", ContextValue.class.getSimpleName(), context);
                return new ContextValueResolver(context, name);
            }
            return null;
        }
        return new TurbineRunDataResolver(context, resolvableTypeIndex);
    }

    protected final TurbineRunDataInternal getTurbineRunData() {
        return (TurbineRunDataInternal)TurbineUtil.getTurbineRunData(this.request);
    }

    protected final String getModuleType(DataResolverContext context) {
        ModuleInfo moduleInfo = context.getExtraObject(ModuleInfo.class);
        if (moduleInfo != null) {
            return moduleInfo.getType();
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DefinitionParser
    extends AbstractSingleBeanDefinitionParser<TurbineRunDataResolverFactory> {
        protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
            SpringExtUtil.addConstructorArg(builder, false, HttpServletRequest.class);
        }
    }

    private class ContextValueResolver
    extends AbstractDataResolver {
        private final String name;

        private ContextValueResolver(DataResolverContext context, String name) {
            super("ContextValueResolver", context);
            this.name = name;
        }

        public Object resolve() {
            TurbineRunDataInternal rundata = (TurbineRunDataInternal)TurbineUtil.getTurbineRunData(TurbineRunDataResolverFactory.this.request);
            Context turbineContext = rundata.getCurrentContext();
            if (turbineContext == null) {
                turbineContext = rundata.getContext();
            }
            Class<?> paramType = this.context.getTypeInfo().getRawType();
            Object value = turbineContext.get(this.name);
            if (paramType.isPrimitive()) {
                if (value == null && paramType.isPrimitive()) {
                    value = ClassUtil.getPrimitiveDefaultValue(paramType);
                }
                paramType = ClassUtil.getWrapperTypeIfPrimitive(paramType);
            }
            if (value != null && !paramType.isInstance(value)) {
                log.warn("Failed to convert context value of type [" + value.getClass().getSimpleName() + "] to parameter type [" + paramType.getName() + "]");
                value = null;
            }
            return value;
        }
    }

    private class TurbineRunDataResolver
    extends AbstractDataResolver {
        private final int resolvableTypeIndex;

        private TurbineRunDataResolver(DataResolverContext context, int resolvableTypeIndex) {
            super("TurbineRunDataResolver", context);
            this.resolvableTypeIndex = resolvableTypeIndex;
        }

        public Object resolve() {
            switch (this.resolvableTypeIndex) {
                case 0: {
                    return TurbineRunDataResolverFactory.this.getTurbineRunData();
                }
                case 1: {
                    return TurbineRunDataResolverFactory.this.getTurbineRunData().getRequest();
                }
                case 2: {
                    return TurbineRunDataResolverFactory.this.getTurbineRunData().getResponse();
                }
                case 3: {
                    return TurbineRunDataResolverFactory.this.getTurbineRunData().getRequest().getSession();
                }
                case 4: {
                    return TurbineRunDataResolverFactory.this.getTurbineRunData().getRequestContext().getServletContext();
                }
                case 5: {
                    return TurbineRunDataResolverFactory.this.getTurbineRunData().getParameters();
                }
                case 6: {
                    return TurbineRunDataResolverFactory.this.getTurbineRunData().getCookies();
                }
                case 7: {
                    String moduleType = TurbineRunDataResolverFactory.this.getModuleType(this.context);
                    if ("control".equalsIgnoreCase(moduleType)) {
                        return TurbineRunDataResolverFactory.this.getTurbineRunData().getCurrentContext();
                    }
                    return TurbineRunDataResolverFactory.this.getTurbineRunData().getContext();
                }
                case 8: {
                    Class<?> requestContextType = this.context.getTypeInfo().getRawType();
                    return RequestContextUtil.findRequestContext(TurbineRunDataResolverFactory.this.getTurbineRunData().getRequestContext(), requestContextType);
                }
            }
            Assert.unreachableCode();
            return null;
        }
    }
}

