/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.util;

import com.alibaba.citrus.util.ArrayUtil;
import com.alibaba.citrus.util.Assert;
import com.alibaba.citrus.util.BasicConstant;
import com.alibaba.citrus.util.CollectionUtil;
import com.alibaba.citrus.util.StringUtil;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassUtil {
    private static final Map<String, PrimitiveInfo<?>> PRIMITIVES = CollectionUtil.createHashMap();
    private static final Map<Class<?>, Set<Class<?>>> assignmentTable;

    public static String getFriendlyClassNameForObject(Object object) {
        if (object == null) {
            return null;
        }
        String javaClassName = object.getClass().getName();
        return ClassUtil.toFriendlyClassName(javaClassName, true, javaClassName);
    }

    public static String getFriendlyClassName(Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        String javaClassName = clazz.getName();
        return ClassUtil.toFriendlyClassName(javaClassName, true, javaClassName);
    }

    public static String getFriendlyClassName(String javaClassName) {
        return ClassUtil.toFriendlyClassName(javaClassName, true, javaClassName);
    }

    private static String toFriendlyClassName(String javaClassName, boolean processInnerClass, String defaultIfInvalid) {
        String name = StringUtil.trimToNull(javaClassName);
        if (name == null) {
            return defaultIfInvalid;
        }
        if (processInnerClass) {
            name = name.replace('$', '.');
        }
        int length = name.length();
        int dimension = 0;
        int i = 0;
        while (i < length && name.charAt(i) == '[') {
            ++i;
            ++dimension;
        }
        if (dimension == 0) {
            return name;
        }
        if (length <= dimension) {
            return defaultIfInvalid;
        }
        StringBuilder componentTypeName = new StringBuilder();
        switch (name.charAt(dimension)) {
            case 'Z': {
                componentTypeName.append("boolean");
                break;
            }
            case 'B': {
                componentTypeName.append("byte");
                break;
            }
            case 'C': {
                componentTypeName.append("char");
                break;
            }
            case 'D': {
                componentTypeName.append("double");
                break;
            }
            case 'F': {
                componentTypeName.append("float");
                break;
            }
            case 'I': {
                componentTypeName.append("int");
                break;
            }
            case 'J': {
                componentTypeName.append("long");
                break;
            }
            case 'S': {
                componentTypeName.append("short");
                break;
            }
            case 'L': {
                if (name.charAt(length - 1) != ';' || length <= dimension + 2) {
                    return defaultIfInvalid;
                }
                componentTypeName.append(name.substring(dimension + 1, length - 1));
                break;
            }
            default: {
                return defaultIfInvalid;
            }
        }
        for (int i2 = 0; i2 < dimension; ++i2) {
            componentTypeName.append("[]");
        }
        return componentTypeName.toString();
    }

    public static String getSimpleClassNameForObject(Object object) {
        if (object == null) {
            return null;
        }
        return ClassUtil.getSimpleClassName(object.getClass().getName());
    }

    public static String getSimpleClassNameForObject(Object object, boolean processInnerClass) {
        if (object == null) {
            return null;
        }
        return ClassUtil.getSimpleClassName(object.getClass().getName(), processInnerClass);
    }

    public static String getSimpleClassName(Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        return ClassUtil.getSimpleClassName(clazz.getName());
    }

    public static String getSimpleClassName(Class<?> clazz, boolean proccessInnerClass) {
        if (clazz == null) {
            return null;
        }
        return ClassUtil.getSimpleClassName(clazz.getName(), proccessInnerClass);
    }

    public static String getSimpleClassName(String javaClassName) {
        return ClassUtil.getSimpleClassName(javaClassName, true);
    }

    public static String getSimpleClassName(String javaClassName, boolean proccesInnerClass) {
        String friendlyClassName = ClassUtil.toFriendlyClassName(javaClassName, false, null);
        if (friendlyClassName == null) {
            return javaClassName;
        }
        if (proccesInnerClass) {
            char[] chars = friendlyClassName.toCharArray();
            int beginIndex = 0;
            for (int i = chars.length - 1; i >= 0; --i) {
                if (chars[i] == '.') {
                    beginIndex = i + 1;
                    break;
                }
                if (chars[i] != '$') continue;
                chars[i] = 46;
            }
            return new String(chars, beginIndex, chars.length - beginIndex);
        }
        return friendlyClassName.substring(friendlyClassName.lastIndexOf(".") + 1);
    }

    public static String getSimpleMethodSignature(Method method) {
        return ClassUtil.getSimpleMethodSignature(method, false, false, false, false);
    }

    public static String getSimpleMethodSignature(Method method, boolean withClassName) {
        return ClassUtil.getSimpleMethodSignature(method, false, false, withClassName, false);
    }

    public static String getSimpleMethodSignature(Method method, boolean withModifiers, boolean withReturnType, boolean withClassName, boolean withExceptionType) {
        Class<?>[] exceptionTypes;
        if (method == null) {
            return null;
        }
        StringBuilder buf = new StringBuilder();
        if (withModifiers) {
            buf.append(Modifier.toString(method.getModifiers())).append(' ');
        }
        if (withReturnType) {
            buf.append(ClassUtil.getSimpleClassName(method.getReturnType())).append(' ');
        }
        if (withClassName) {
            buf.append(ClassUtil.getSimpleClassName(method.getDeclaringClass())).append('.');
        }
        buf.append(method.getName()).append('(');
        Class<?>[] paramTypes = method.getParameterTypes();
        for (int i = 0; i < paramTypes.length; ++i) {
            Class<?> paramType = paramTypes[i];
            buf.append(ClassUtil.getSimpleClassName(paramType));
            if (i >= paramTypes.length - 1) continue;
            buf.append(", ");
        }
        buf.append(')');
        if (withExceptionType && !ArrayUtil.isEmptyArray(exceptionTypes = method.getExceptionTypes())) {
            buf.append(" throws ");
            for (int i = 0; i < exceptionTypes.length; ++i) {
                Class<?> exceptionType = exceptionTypes[i];
                buf.append(ClassUtil.getSimpleClassName(exceptionType));
                if (i >= exceptionTypes.length - 1) continue;
                buf.append(", ");
            }
        }
        return buf.toString();
    }

    public static String getPackageNameForObject(Object object) {
        if (object == null) {
            return "";
        }
        return ClassUtil.getPackageName(object.getClass().getName());
    }

    public static String getPackageName(Class<?> clazz) {
        if (clazz == null) {
            return "";
        }
        return ClassUtil.getPackageName(clazz.getName());
    }

    public static String getPackageName(String javaClassName) {
        String friendlyClassName = ClassUtil.toFriendlyClassName(javaClassName, false, null);
        if (friendlyClassName == null) {
            return "";
        }
        int i = friendlyClassName.lastIndexOf(46);
        if (i == -1) {
            return "";
        }
        return friendlyClassName.substring(0, i);
    }

    public static String getResourceNameForObjectClass(Object object) {
        if (object == null) {
            return null;
        }
        return object.getClass().getName().replace('.', '/') + ".class";
    }

    public static String getResourceNameForClass(Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        return clazz.getName().replace('.', '/') + ".class";
    }

    public static String getResourceNameForClass(String className) {
        if (className == null) {
            return null;
        }
        return className.replace('.', '/') + ".class";
    }

    public static String getResourceNameForObjectPackage(Object object) {
        if (object == null) {
            return null;
        }
        return ClassUtil.getPackageNameForObject(object).replace('.', '/');
    }

    public static String getResourceNameForPackage(Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        return ClassUtil.getPackageName(clazz).replace('.', '/');
    }

    public static String getResourceNameForPackage(String className) {
        if (className == null) {
            return null;
        }
        return ClassUtil.getPackageName(className).replace('.', '/');
    }

    public static Class<?> getArrayClass(Class<?> componentType) {
        return ClassUtil.getArrayClass(componentType, 1);
    }

    public static Class<?> getArrayClass(Class<?> componentClass, int dimension) {
        if (componentClass == null) {
            return null;
        }
        switch (dimension) {
            case 1: {
                return Array.newInstance(componentClass, 0).getClass();
            }
            case 0: {
                return componentClass;
            }
        }
        Assert.assertTrue(dimension > 0, "wrong dimension: %d", dimension);
        return Array.newInstance(componentClass, new int[dimension]).getClass();
    }

    public static Class<?> getPrimitiveType(String name) {
        PrimitiveInfo<?> info = PRIMITIVES.get(name);
        if (info != null) {
            return info.type;
        }
        return null;
    }

    public static Class<?> getPrimitiveType(Class<?> type) {
        return ClassUtil.getPrimitiveType(type.getName());
    }

    public static <T> Class<T> getWrapperTypeIfPrimitive(Class<T> type) {
        if (type.isPrimitive()) {
            return ClassUtil.PRIMITIVES.get((Object)type.getName()).wrapperType;
        }
        return type;
    }

    public static <T> T getPrimitiveDefaultValue(Class<T> type) {
        PrimitiveInfo<?> info = PRIMITIVES.get(type.getName());
        if (info != null) {
            return info.defaultValue;
        }
        return null;
    }

    private static <T> void addPrimitive(Class<T> type, String typeCode, Class<T> wrapperType, String unwrapMethod, T defaultValue) {
        PrimitiveInfo<T> info = new PrimitiveInfo<T>(type, typeCode, wrapperType, unwrapMethod, defaultValue);
        PRIMITIVES.put(type.getName(), info);
        PRIMITIVES.put(wrapperType.getName(), info);
    }

    public static boolean isAssignable(Class<?>[] classes, Class<?>[] fromClasses) {
        if (!ArrayUtil.isArraySameLength(fromClasses, classes)) {
            return false;
        }
        if (fromClasses == null) {
            fromClasses = BasicConstant.EMPTY_CLASS_ARRAY;
        }
        if (classes == null) {
            classes = BasicConstant.EMPTY_CLASS_ARRAY;
        }
        for (int i = 0; i < fromClasses.length; ++i) {
            if (ClassUtil.isAssignable(classes[i], fromClasses[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean isAssignable(Class<?> clazz, Class<?> fromClass) {
        if (clazz == null) {
            return false;
        }
        if (fromClass == null) {
            return !clazz.isPrimitive();
        }
        if (clazz.isAssignableFrom(fromClass)) {
            return true;
        }
        if (clazz.isPrimitive()) {
            return assignmentTable.get(clazz).contains(fromClass);
        }
        return false;
    }

    private static Set<Class<?>> assignableSet(Class<?> ... types) {
        HashSet<Class<?>> assignableSet = CollectionUtil.createHashSet();
        for (Class<?> type : types) {
            assignableSet.add(ClassUtil.getPrimitiveType(type));
            assignableSet.add(ClassUtil.getWrapperTypeIfPrimitive(type));
        }
        return assignableSet;
    }

    public static String locateClass(Class<?> clazz) {
        return ClassUtil.locateClass(clazz.getName(), clazz.getClassLoader());
    }

    public static String locateClass(String className) {
        return ClassUtil.locateClass(className, null);
    }

    public static String locateClass(String className, ClassLoader loader) {
        className = Assert.assertNotNull(StringUtil.trimToNull(className), "className", new Object[0]);
        if (loader == null) {
            loader = Thread.currentThread().getContextClassLoader();
        }
        String classFile = className.replace('.', '/') + ".class";
        URL locationURL = loader.getResource(classFile);
        String location = null;
        if (locationURL != null) {
            location = locationURL.toExternalForm();
            if (location.endsWith(classFile)) {
                location = location.substring(0, location.length() - classFile.length());
            }
            location = location.replaceAll("^(jar|zip):|!/$", "");
        }
        return location;
    }

    static {
        ClassUtil.addPrimitive(Boolean.TYPE, "Z", Boolean.class, "booleanValue", false);
        ClassUtil.addPrimitive(Short.TYPE, "S", Short.class, "shortValue", (short)0);
        ClassUtil.addPrimitive(Integer.TYPE, "I", Integer.class, "intValue", 0);
        ClassUtil.addPrimitive(Long.TYPE, "J", Long.class, "longValue", 0L);
        ClassUtil.addPrimitive(Float.TYPE, "F", Float.class, "floatValue", Float.valueOf(0.0f));
        ClassUtil.addPrimitive(Double.TYPE, "D", Double.class, "doubleValue", 0.0);
        ClassUtil.addPrimitive(Character.TYPE, "C", Character.class, "charValue", Character.valueOf('\u0000'));
        ClassUtil.addPrimitive(Byte.TYPE, "B", Byte.class, "byteValue", (byte)0);
        ClassUtil.addPrimitive(Void.TYPE, "V", Void.class, null, null);
        assignmentTable = CollectionUtil.createHashMap();
        assignmentTable.put(Boolean.TYPE, ClassUtil.assignableSet(Boolean.TYPE));
        assignmentTable.put(Byte.TYPE, ClassUtil.assignableSet(Byte.TYPE));
        assignmentTable.put(Character.TYPE, ClassUtil.assignableSet(Character.TYPE));
        assignmentTable.put(Short.TYPE, ClassUtil.assignableSet(Short.TYPE, Byte.TYPE));
        assignmentTable.put(Integer.TYPE, ClassUtil.assignableSet(Integer.TYPE, Byte.TYPE, Short.TYPE, Character.TYPE));
        assignmentTable.put(Long.TYPE, ClassUtil.assignableSet(Long.TYPE, Integer.TYPE, Byte.TYPE, Short.TYPE, Character.TYPE));
        assignmentTable.put(Float.TYPE, ClassUtil.assignableSet(Float.TYPE, Long.TYPE, Integer.TYPE, Byte.TYPE, Short.TYPE, Character.TYPE));
        assignmentTable.put(Double.TYPE, ClassUtil.assignableSet(Double.TYPE, Float.TYPE, Long.TYPE, Integer.TYPE, Byte.TYPE, Short.TYPE, Character.TYPE));
        Assert.assertTrue(assignmentTable.size() == 8);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PrimitiveInfo<T> {
        final Class<T> type;
        final String typeCode;
        final Class<T> wrapperType;
        final String unwrapMethod;
        final T defaultValue;

        public PrimitiveInfo(Class<T> type, String typeCode, Class<T> wrapperType, String unwrapMethod, T defaultValue) {
            this.type = type;
            this.typeCode = typeCode;
            this.wrapperType = wrapperType;
            this.unwrapMethod = unwrapMethod;
            this.defaultValue = defaultValue;
        }
    }
}

