/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.util.internal;

import com.alibaba.citrus.util.ClassLoaderUtil;
import com.alibaba.citrus.util.ObjectUtil;
import com.alibaba.citrus.util.StringUtil;
import java.lang.reflect.Method;
import net.sf.cglib.asm.Type;
import net.sf.cglib.core.Signature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class DynamicClassBuilder {
    private static final int PUBLIC_STATIC_MODIFIERS = 9;
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private final ClassLoader classLoader;

    public DynamicClassBuilder() {
        this(null);
    }

    public DynamicClassBuilder(ClassLoader cl) {
        this.classLoader = cl;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader == null ? ClassLoaderUtil.getContextClassLoader() : this.classLoader;
    }

    protected Signature getSignature(Method method, String rename) {
        String name = ObjectUtil.defaultIfNull(StringUtil.trimToNull(rename), method.getName());
        Type returnType = Type.getType(method.getReturnType());
        Type[] paramTypes = Type.getArgumentTypes((Method)method);
        return new Signature(name, returnType, paramTypes);
    }

    protected boolean isPublicStatic(Method method) {
        return (method.getModifiers() & 9) == 9;
    }

    protected boolean isEqualsMethod(Method method) {
        if (!"equals".equals(method.getName())) {
            return false;
        }
        Class<?>[] paramTypes = method.getParameterTypes();
        return paramTypes.length == 1 && paramTypes[0] == Object.class;
    }

    protected boolean isHashCodeMethod(Method method) {
        return "hashCode".equals(method.getName()) && method.getParameterTypes().length == 0;
    }

    protected boolean isToStringMethod(Method method) {
        return "toString".equals(method.getName()) && method.getParameterTypes().length == 0;
    }
}

