/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.util.internal;

import com.alibaba.citrus.util.ClassUtil;
import com.alibaba.citrus.util.CollectionUtil;
import com.alibaba.citrus.util.StringUtil;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageFormatter<T> {
    private final Map<Locale, Reference<ResourceBundle>> bundles = CollectionUtil.createConcurrentHashMap();
    private static ThreadLocal<Locale> defaultLocale;

    protected String getBundleName() {
        return this.getClass().getName();
    }

    private ResourceBundle getBundle(Locale locale) {
        if (locale == null) {
            locale = MessageFormatter.getDefaultLocale();
        }
        Reference<ResourceBundle> bundleRef = this.bundles.get(locale);
        ResourceBundle bundle = null;
        if (bundleRef != null) {
            bundle = bundleRef.get();
        }
        if (bundle == null) {
            bundle = ResourceBundle.getBundle(this.getBundleName(), locale);
            this.bundles.put(locale, new WeakReference<ResourceBundle>(bundle));
        }
        return bundle;
    }

    public String format(T key, Object ... args) {
        return this.format(key, null, args);
    }

    public String format(T key, Locale locale, Object ... args) {
        String message;
        ResourceBundle bundle = this.getBundle(locale);
        String strKey = String.valueOf(key);
        try {
            message = this.format(bundle.getString(strKey), args);
        }
        catch (MissingResourceException e) {
            StringBuilder buffer = new StringBuilder();
            buffer.append(strKey).append(": ");
            if (args != null && args.length > 0) {
                for (Object arg : args) {
                    buffer.append(arg).append(", ");
                }
            }
            buffer.setLength(buffer.length() - 2);
            message = buffer.toString();
        }
        return message;
    }

    private String format(String format, Object[] args) {
        format = StringUtil.trimToEmpty(format);
        if (args.length == 0) {
            return format;
        }
        return MessageFormat.format(format, this.preprocess(args));
    }

    protected final Object preprocess(Object o) {
        if (o == null) {
            return "";
        }
        if (o instanceof Object[]) {
            return this.preprocess((Object[])o);
        }
        if (o instanceof Throwable) {
            return this.preprocess((Throwable)o);
        }
        if (o instanceof Class) {
            return this.preprocess((Class)o);
        }
        if (o instanceof Double) {
            double d = (Double)o;
            if (Double.isNaN(d) || Double.isInfinite(d)) {
                return o.toString();
            }
            return o;
        }
        if (o instanceof Float) {
            float f = ((Float)o).floatValue();
            if (Float.isNaN(f) || Float.isInfinite(f)) {
                return o.toString();
            }
            return o;
        }
        if (o instanceof Constructor) {
            return this.preprocess((Constructor)o);
        }
        if (o instanceof Method) {
            return this.preprocess((Method)o);
        }
        return this.preprocessObject(o);
    }

    protected Object preprocessObject(Object o) {
        return o;
    }

    private Object[] preprocess(Object[] args) {
        for (int i = 0; i < args.length; ++i) {
            args[i] = this.preprocess(args[i]);
        }
        return args;
    }

    private Object preprocess(Throwable t) {
        String message = t.getMessage();
        if (message != null) {
            return ClassUtil.getSimpleClassName(t.getClass()) + " - " + message;
        }
        return ClassUtil.getSimpleClassName(t.getClass());
    }

    private Object preprocess(Class<?> c) {
        return ClassUtil.getSimpleClassName(c);
    }

    private Object preprocess(Constructor<?> method) {
        try {
            return this.preprocessMethodOrConstructor(method.getModifiers(), null, method.getDeclaringClass(), null, method.getParameterTypes(), method.getExceptionTypes());
        }
        catch (Exception e) {
            return "<" + e + ">";
        }
    }

    private Object preprocess(Method method) {
        try {
            return this.preprocessMethodOrConstructor(method.getModifiers(), method.getReturnType(), method.getDeclaringClass(), method.getName(), method.getParameterTypes(), method.getExceptionTypes());
        }
        catch (Exception e) {
            return "<" + e + ">";
        }
    }

    private Object preprocessMethodOrConstructor(int mod, Class<?> returnType, Class<?> declaringClass, String methodName, Class<?>[] paramTypes, Class<?>[] exceptionTypes) {
        int i;
        StringBuilder sb = new StringBuilder();
        if (returnType != null) {
            sb.append(ClassUtil.getSimpleClassName(returnType)).append(" ");
        }
        sb.append(ClassUtil.getSimpleClassName(declaringClass));
        if (methodName != null) {
            sb.append(".").append(methodName);
        }
        sb.append("(");
        for (i = 0; i < paramTypes.length; ++i) {
            sb.append(ClassUtil.getSimpleClassName(paramTypes[i]));
            if (i >= paramTypes.length - 1) continue;
            sb.append(", ");
        }
        sb.append(")");
        if (exceptionTypes.length > 0) {
            sb.append(" throws ");
            for (i = 0; i < exceptionTypes.length; ++i) {
                sb.append(ClassUtil.getSimpleClassName(exceptionTypes[i]));
                if (i >= exceptionTypes.length - 1) continue;
                sb.append(",");
            }
        }
        return sb.toString();
    }

    private static Locale getDefaultLocale() {
        Locale locale = null;
        if (defaultLocale != null) {
            locale = defaultLocale.get();
        }
        if (locale == null) {
            locale = Locale.getDefault();
        }
        return locale;
    }

    static void setDefaultLocale(Locale locale) {
        if (defaultLocale == null) {
            defaultLocale = new ThreadLocal();
        }
        defaultLocale.set(locale);
    }
}

