/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.webx.config.impl;

import com.alibaba.citrus.service.configuration.support.AbstractConfigurationDefinitionParser;
import com.alibaba.citrus.springext.util.DomUtil;
import com.alibaba.citrus.springext.util.SpringExtUtil;
import com.alibaba.citrus.util.Assert;
import com.alibaba.citrus.util.StringUtil;
import com.alibaba.citrus.webx.config.impl.WebxConfigurationImpl;
import com.alibaba.citrus.webx.impl.WebxControllerImpl;
import java.util.Map;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebxConfigurationDefinitionParser
extends AbstractConfigurationDefinitionParser<WebxConfigurationImpl> {
    @Override
    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        super.doParse(element, parserContext, builder);
        BeanDefinitionBuilder components = BeanDefinitionBuilder.genericBeanDefinition(WebxConfigurationImpl.ComponentsConfigImpl.class);
        Element componentsElement = DomUtil.theOnlySubElement(element, DomUtil.and(DomUtil.sameNs(element), DomUtil.name("components")));
        if (componentsElement != null) {
            SpringExtUtil.attributesToProperties(componentsElement, components, "autoDiscoverComponents", "componentConfigurationLocationPattern", "defaultControllerClass", "defaultComponent");
            Element rootControllerElement = DomUtil.theOnlySubElement(componentsElement, DomUtil.and(DomUtil.sameNs(element), DomUtil.name("rootController")));
            if (rootControllerElement != null) {
                components.addPropertyValue("rootController", SpringExtUtil.parseBean(rootControllerElement, parserContext, (BeanDefinition)components.getRawBeanDefinition()));
            }
            Map<Object, Object> specifiedComponents = SpringExtUtil.createManagedMap(element, parserContext);
            for (Element componentElement : DomUtil.subElements(componentsElement, DomUtil.and(DomUtil.sameNs(componentsElement), DomUtil.name("component")))) {
                String name = Assert.assertNotNull(StringUtil.trimToNull(componentElement.getAttribute("name")), "no component name", new Object[0]);
                BeanDefinitionBuilder componentBuilder = BeanDefinitionBuilder.genericBeanDefinition(WebxConfigurationImpl.ComponentConfigImpl.class);
                SpringExtUtil.attributesToProperties(componentElement, componentBuilder, "name", "path");
                Element controllerElement = DomUtil.theOnlySubElement(componentElement, DomUtil.and(DomUtil.sameNs(componentElement), DomUtil.name("controller")));
                Object controllerBD = controllerElement == null ? BeanDefinitionBuilder.genericBeanDefinition(WebxControllerImpl.class).getBeanDefinition() : SpringExtUtil.parseBean(controllerElement, parserContext, (BeanDefinition)components.getRawBeanDefinition());
                componentBuilder.addPropertyValue("controller", controllerBD);
                specifiedComponents.put(name, componentBuilder.getBeanDefinition());
            }
            components.addPropertyValue("components", specifiedComponents);
        }
        builder.addPropertyValue("componentsConfig", (Object)components.getBeanDefinition());
    }

    @Override
    protected DomUtil.ElementSelector getPropertyElementSelector() {
        return DomUtil.and(DomUtil.any(), DomUtil.not(DomUtil.name("components")));
    }

    @Override
    protected String getDefaultName() {
        return "webxConfiguration";
    }
}

