/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.context;

import com.alibaba.cloud.context.AliCloudConfiguration;
import com.alibaba.cloud.context.AlicloudSdkProduct;
import com.alibaba.cloud.context.AlicloudSdkRegion;
import com.alibaba.cloud.context.edas.EdasConfiguration;
import com.aliyuncs.AcsRequest;
import com.aliyuncs.AcsResponse;
import com.aliyuncs.DefaultAcsClient;
import com.aliyuncs.exceptions.ClientException;
import com.aliyuncs.http.HttpClientType;
import com.aliyuncs.profile.DefaultProfile;
import com.aliyuncs.profile.IClientProfile;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AliCloudSdk {
    private static final Logger log = LoggerFactory.getLogger(AliCloudSdk.class);
    private DefaultAcsClient defaultAcsClient;
    private static final Map<String, List<String>> productRegionMap = new HashMap<String, List<String>>();

    private static void addEndpoint(AlicloudSdkProduct alicloudSdkProduct, AlicloudSdkRegion alicloudSdkRegion) throws ClientException {
        DefaultProfile.addEndpoint((String)alicloudSdkRegion.getRegionId(), (String)alicloudSdkRegion.getRegionId(), (String)alicloudSdkProduct.getProduct(), (String)alicloudSdkRegion.getEndpoint(alicloudSdkProduct));
        List<String> regions = productRegionMap.get(alicloudSdkProduct.getProduct());
        if (regions == null) {
            regions = new ArrayList<String>();
            productRegionMap.put(alicloudSdkProduct.getProduct(), regions);
        }
        regions.add(alicloudSdkRegion.getRegionId());
    }

    public AliCloudSdk(AliCloudConfiguration aliCloudConfiguration, String regionId) {
        DefaultProfile defaultProfile = DefaultProfile.getProfile((String)regionId, (String)aliCloudConfiguration.getAccessKey(), (String)aliCloudConfiguration.getSecretKey());
        defaultProfile.getHttpClientConfig().setClientType(HttpClientType.Compatible);
        DefaultAcsClient defaultAcsClient = new DefaultAcsClient((IClientProfile)defaultProfile);
        defaultAcsClient.setAutoRetry(false);
        this.defaultAcsClient = defaultAcsClient;
    }

    public AliCloudSdk(AliCloudConfiguration aliCloudConfiguration, EdasConfiguration edasConfiguration) {
        this(aliCloudConfiguration, edasConfiguration.getRegionId());
    }

    public <T extends AcsResponse> T getAcsResponse(AcsRequest<T> request) throws ClientException {
        return (T)this.defaultAcsClient.getAcsResponse(request);
    }

    public boolean contains(AlicloudSdkProduct alicloudSdkProduct, String region) {
        List<String> regions = productRegionMap.get(alicloudSdkProduct.getProduct());
        return region != null && regions.contains(region);
    }

    static {
        try {
            AliCloudSdk.addEndpoint(AlicloudSdkProduct.EDAS, AlicloudSdkRegion.CN_BEIJING);
            AliCloudSdk.addEndpoint(AlicloudSdkProduct.EDAS, AlicloudSdkRegion.CN_QINGDAO);
            AliCloudSdk.addEndpoint(AlicloudSdkProduct.EDAS, AlicloudSdkRegion.CN_SHENZHEN);
            AliCloudSdk.addEndpoint(AlicloudSdkProduct.EDAS, AlicloudSdkRegion.CN_HANGZHOU);
            AliCloudSdk.addEndpoint(AlicloudSdkProduct.EDAS, AlicloudSdkRegion.CN_SHANGHAI);
            AliCloudSdk.addEndpoint(AlicloudSdkProduct.EDAS, AlicloudSdkRegion.AP_SOUTHEAST_1);
        }
        catch (ClientException e) {
            log.warn("Edas pop api init failed.", (Throwable)e);
        }
    }
}

