/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.context.statistics;

import com.alibaba.cloud.context.AliCloudConfiguration;
import com.alibaba.cloud.context.AlicloudSdkProduct;
import com.alibaba.cloud.context.edas.AliCloudEdasSdk;
import com.alibaba.cloud.context.edas.AliCloudEdasSdkFactory;
import com.alibaba.cloud.context.edas.EdasChangeOrderConfiguration;
import com.alibaba.cloud.context.edas.EdasChangeOrderConfigurationFactory;
import com.alibaba.cloud.context.edas.EdasConfiguration;
import com.alibaba.cloud.context.statistics.ManagedReportTask;
import com.alibaba.cloud.context.statistics.UnmanagedReportTask;
import com.alibaba.cloud.context.utils.NetUtils;
import com.aliyuncs.edas.model.v20170801.GetSecureTokenResponse;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;

public class StatisticsTask {
    private static final Long DEFAULT_INTERVAL = 600000L;
    private static final String KEYS_UUID = "vmUuid";
    private static final String KEYS_IP = "ip";
    private static final String KEYS_COMPONENTS = "components";
    private static final String KEYS_TENANT_ID = "tenantId";
    private static final String KEYS_EDAS_ID = "edasId";
    private static final String KEYS_USER_ID = "userId";
    private static final String KEYS_VERSION = "version";
    private static final String KEYS_SPRING_BOOT_VERSION = "springBootVersion";
    private static final AtomicBoolean started = new AtomicBoolean(false);
    private long interval;
    private AliCloudEdasSdk aliCloudEdasSdk;
    private EdasConfiguration edasConfiguration;
    private List<String> components;
    private EdasChangeOrderConfiguration edasChangeOrderConfiguration = EdasChangeOrderConfigurationFactory.getEdasChangeOrderConfiguration();

    public StatisticsTask(AliCloudConfiguration aliCloudConfiguration, EdasConfiguration edasConfiguration, List<String> components) {
        this(DEFAULT_INTERVAL, null, edasConfiguration, components);
        try {
            this.aliCloudEdasSdk = AliCloudEdasSdkFactory.getDefaultAliCloudEdasSdk(aliCloudConfiguration, edasConfiguration.getRegionId());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public StatisticsTask(AliCloudEdasSdk aliCloudEdasSdk, EdasConfiguration edasConfiguration, List<String> components) {
        this(DEFAULT_INTERVAL, aliCloudEdasSdk, edasConfiguration, components);
    }

    public StatisticsTask(long interval, AliCloudEdasSdk aliCloudEdasSdk, EdasConfiguration edasConfiguration, List<String> components) {
        this.interval = interval;
        this.aliCloudEdasSdk = aliCloudEdasSdk;
        this.edasConfiguration = edasConfiguration;
        this.components = components == null ? new ArrayList() : components;
    }

    public void start() {
        if (this.components == null || this.components.size() == 0) {
            return;
        }
        if (started.compareAndSet(false, true)) {
            if (this.edasChangeOrderConfiguration.isEdasManaged()) {
                HashMap<String, String> params = new HashMap<String, String>(10);
                params.put(KEYS_UUID, this.getUuid());
                params.put(KEYS_IP, this.getIp());
                params.put(KEYS_COMPONENTS, this.getComponents());
                params.putAll(this.getIds());
                params.put(KEYS_VERSION, this.getVersion());
                params.put(KEYS_SPRING_BOOT_VERSION, this.getSpringBootVersion());
                Thread thread = new Thread(new ManagedReportTask(this.interval, params));
                thread.setDaemon(true);
                thread.setName("Alicloud Managed Report Thread");
                thread.start();
            } else {
                HashMap<String, String> params = new HashMap<String, String>(10);
                params.put("scaPing", "true");
                params.put("params", this.getParamsString());
                Thread thread = new Thread(new UnmanagedReportTask(this.interval, params));
                thread.setDaemon(true);
                thread.setName("Alicloud Unmanaged Report Thread");
                thread.start();
            }
        }
    }

    private boolean isSpringCloud() {
        return this.components != null && this.components.size() > 0 && this.components.get(0).startsWith("SC-");
    }

    private boolean isDubbo() {
        return this.components != null && this.components.size() > 0 && this.components.get(0).startsWith("DUBBO-");
    }

    private String getParamsString() {
        ArrayList<String> paramsList = new ArrayList<String>();
        paramsList.add(this.getUuid());
        paramsList.add(this.getIp());
        paramsList.add(this.getIdsString());
        paramsList.add(this.getComponents());
        paramsList.add(this.getVersions());
        StringBuffer paramsString = new StringBuffer();
        for (String param : paramsList) {
            paramsString.append("|").append(param);
        }
        return paramsString.substring(1);
    }

    private String getUuid() {
        String uuid = "";
        try {
            String fileSeparator = System.getProperty("file.separator");
            String userHome = System.getProperty("user.home");
            File file = new File(userHome + fileSeparator + ".sca" + fileSeparator + "sca_temp.uid");
            if (file.exists()) {
                BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
                uuid = bufferedReader.readLine().trim();
            } else {
                uuid = UUID.randomUUID().toString();
                File dir = new File(userHome + fileSeparator + ".sca");
                if (!dir.exists()) {
                    dir.mkdir();
                }
                FileWriter fileWriter = new FileWriter(file);
                fileWriter.write(uuid);
                fileWriter.flush();
                fileWriter.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return uuid;
    }

    private String getIp() {
        return NetUtils.findFirstNonLoopbackAddress().getHostAddress();
    }

    private String getIdsString() {
        String tenantId = "";
        String edasId = "";
        String userId = "";
        Map<String, String> idsMap = this.getIds();
        if (idsMap.get(KEYS_TENANT_ID) != null) {
            tenantId = idsMap.get(KEYS_TENANT_ID);
        }
        if (idsMap.get(KEYS_EDAS_ID) != null) {
            tenantId = idsMap.get(KEYS_EDAS_ID);
        }
        if (idsMap.get(KEYS_USER_ID) != null) {
            tenantId = idsMap.get(KEYS_USER_ID);
        }
        return edasId + "|" + userId + "|" + tenantId;
    }

    private Map<String, String> getIds() {
        HashMap<String, String> idsMap = new HashMap<String, String>(3);
        if (this.edasChangeOrderConfiguration.isEdasManaged()) {
            idsMap.put(KEYS_TENANT_ID, this.edasChangeOrderConfiguration.getTenantId());
            return idsMap;
        }
        if (this.aliCloudEdasSdk == null || this.edasConfiguration == null || this.edasConfiguration.getNamespace() == null) {
            return idsMap;
        }
        if (!this.aliCloudEdasSdk.getAliCloudSdk().contains(AlicloudSdkProduct.EDAS, this.edasConfiguration.getRegionId())) {
            return idsMap;
        }
        try {
            GetSecureTokenResponse.SecureToken secureToken = this.aliCloudEdasSdk.getSecureToken(this.edasConfiguration.getNamespace());
            if (secureToken != null) {
                if (secureToken.getTenantId() != null) {
                    idsMap.put(KEYS_TENANT_ID, secureToken.getTenantId());
                }
                if (secureToken.getEdasId() != null) {
                    idsMap.put(KEYS_EDAS_ID, secureToken.getEdasId());
                }
                if (secureToken.getUserId() != null) {
                    idsMap.put(KEYS_USER_ID, secureToken.getUserId());
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return idsMap;
    }

    private String getComponents() {
        StringBuffer componentsString = new StringBuffer();
        for (String component : this.components) {
            componentsString.append(",").append(component);
        }
        return componentsString.length() > 0 ? componentsString.substring(1) : "";
    }

    private String getVersions() {
        return this.getVersion() + "|" + this.getSpringBootVersion();
    }

    private String getVersion() {
        String version = "";
        if (this.isSpringCloud()) {
            try {
                Class<?> clazz = Class.forName("org.springframework.cloud.alicloud.context.statistics.StatisticsTaskStarter");
                version = clazz.getPackage().getImplementationVersion();
            }
            catch (ClassNotFoundException clazz) {}
        } else if (this.isDubbo()) {
            try {
                Class<?> clazz = Class.forName("com.alibaba.edas.dubbo.EdasRegistry");
                version = clazz.getPackage().getImplementationVersion();
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return version;
    }

    private String getSpringBootVersion() {
        String springBootVersion = "";
        try {
            Class<?> clazz = Class.forName("org.springframework.boot.ApplicationRunner");
            springBootVersion = clazz.getPackage().getImplementationVersion();
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return springBootVersion;
    }
}

