/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.alicloud.context.ans;

import com.alibaba.cloud.context.AliCloudServerMode;
import com.alibaba.cloud.context.ans.AnsConfiguration;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.cloud.commons.util.InetUtils;
import org.springframework.util.StringUtils;

@ConfigurationProperties(value="spring.cloud.alicloud.ans")
public class AnsProperties
implements AnsConfiguration {
    private AliCloudServerMode serverMode = AliCloudServerMode.LOCAL;
    private String serverList = "127.0.0.1";
    private String serverPort = "8080";
    @Value(value="${spring.cloud.alicloud.ans.client-domains:${spring.application.name:}}")
    private String clientDomains;
    private float clientWeight = 1.0f;
    private Map<String, Float> clientWeights = new HashMap<String, Float>();
    private String clientToken;
    private Map<String, String> clientTokens = new HashMap<String, String>();
    private String clientCluster = "DEFAULT";
    private Map<String, String> clientMetadata = new HashMap<String, String>();
    private boolean registerEnabled = true;
    private String clientIp;
    private String clientInterfaceName;
    private int clientPort = -1;
    @Value(value="${spring.cloud.alicloud.ans.env:${env.id:DEFAULT}}")
    private String env;
    private boolean secure = false;
    @Autowired
    private InetUtils inetUtils;
    private Map<String, String> tags = new HashMap<String, String>();

    @PostConstruct
    public void init() throws SocketException {
        this.tags.put("ANS_SERVICE_TYPE", "SPRING_CLOUD");
        if (StringUtils.isEmpty((Object)this.clientIp)) {
            if (StringUtils.isEmpty((Object)this.clientInterfaceName)) {
                this.clientIp = this.inetUtils.findFirstNonLoopbackHostInfo().getIpAddress();
            } else {
                NetworkInterface networkInterface = NetworkInterface.getByName(this.clientInterfaceName);
                if (null == networkInterface) {
                    throw new RuntimeException("no such network interface " + this.clientInterfaceName);
                }
                Enumeration<InetAddress> inetAddress = networkInterface.getInetAddresses();
                while (inetAddress.hasMoreElements()) {
                    InetAddress currentAddress = inetAddress.nextElement();
                    if (!(currentAddress instanceof Inet4Address) || currentAddress.isLoopbackAddress()) continue;
                    this.clientIp = currentAddress.getHostAddress();
                    break;
                }
                if (StringUtils.isEmpty((Object)this.clientIp)) {
                    throw new RuntimeException("cannot find available ip from network interface " + this.clientInterfaceName);
                }
            }
        }
    }

    public String getServerPort() {
        return this.serverPort;
    }

    public void setServerPort(String serverPort) {
        this.serverPort = serverPort;
    }

    public String getServerList() {
        return this.serverList;
    }

    public void setServerList(String serverList) {
        this.serverList = serverList;
    }

    public boolean isRegisterEnabled() {
        return this.registerEnabled;
    }

    public void setRegisterEnabled(boolean registerEnabled) {
        this.registerEnabled = registerEnabled;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public void setSecure(boolean secure) {
        this.secure = secure;
    }

    public String getEnv() {
        return this.env;
    }

    public void setEnv(String env) {
        this.env = env;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public AliCloudServerMode getServerMode() {
        return this.serverMode;
    }

    public void setServerMode(AliCloudServerMode serverMode) {
        this.serverMode = serverMode;
    }

    public String getClientDomains() {
        return this.clientDomains;
    }

    public void setClientDomains(String clientDomains) {
        this.clientDomains = clientDomains;
    }

    public float getClientWeight() {
        return this.clientWeight;
    }

    public void setClientWeight(float clientWeight) {
        this.clientWeight = clientWeight;
    }

    public Map<String, Float> getClientWeights() {
        return this.clientWeights;
    }

    public void setClientWeights(Map<String, Float> clientWeights) {
        this.clientWeights = clientWeights;
    }

    public String getClientToken() {
        return this.clientToken;
    }

    public void setClientToken(String clientToken) {
        this.clientToken = clientToken;
    }

    public Map<String, String> getClientTokens() {
        return this.clientTokens;
    }

    public void setClientTokens(Map<String, String> clientTokens) {
        this.clientTokens = clientTokens;
    }

    public String getClientCluster() {
        return this.clientCluster;
    }

    public void setClientCluster(String clientCluster) {
        this.clientCluster = clientCluster;
    }

    public Map<String, String> getClientMetadata() {
        return this.clientMetadata;
    }

    public void setClientMetadata(Map<String, String> clientMetadata) {
        this.clientMetadata = clientMetadata;
    }

    public String getClientIp() {
        return this.clientIp;
    }

    public void setClientIp(String clientIp) {
        this.clientIp = clientIp;
    }

    public String getClientInterfaceName() {
        return this.clientInterfaceName;
    }

    public void setClientInterfaceName(String clientInterfaceName) {
        this.clientInterfaceName = clientInterfaceName;
    }

    public int getClientPort() {
        return this.clientPort;
    }

    public void setClientPort(int clientPort) {
        this.clientPort = clientPort;
    }

    public String toString() {
        return "AnsProperties{doms='" + this.clientDomains + '\'' + ", weight=" + this.clientWeight + ", weights=" + this.clientWeights + ", token='" + this.clientToken + '\'' + ", tokens=" + this.clientTokens + ", cluster='" + this.clientCluster + '\'' + ", metadata=" + this.clientMetadata + ", registerEnabled=" + this.registerEnabled + ", ip='" + this.clientIp + '\'' + ", interfaceName='" + this.clientInterfaceName + '\'' + ", port=" + this.clientPort + ", env='" + this.env + '\'' + ", secure=" + this.secure + ", tags=" + this.tags + '}';
    }
}

