/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.circuitbreaker.sentinel;

import com.alibaba.cloud.circuitbreaker.sentinel.ReactiveSentinelCircuitBreakerFactory;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.client.circuitbreaker.Customizer;
import org.springframework.cloud.client.circuitbreaker.ReactiveCircuitBreakerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(name={"reactor.core.publisher.Mono", "reactor.core.publisher.Flux"})
@ConditionalOnProperty(name={"spring.cloud.circuitbreaker.sentinel.enabled"}, havingValue="true", matchIfMissing=true)
public class ReactiveSentinelCircuitBreakerAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={ReactiveCircuitBreakerFactory.class})
    public ReactiveCircuitBreakerFactory reactiveSentinelCircuitBreakerFactory() {
        return new ReactiveSentinelCircuitBreakerFactory();
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(name={"reactor.core.publisher.Mono", "reactor.core.publisher.Flux"})
    public static class ReactiveSentinelCustomizerConfiguration {
        @Autowired(required=false)
        private List<Customizer<ReactiveSentinelCircuitBreakerFactory>> customizers = new ArrayList<Customizer<ReactiveSentinelCircuitBreakerFactory>>();
        @Autowired(required=false)
        private ReactiveSentinelCircuitBreakerFactory factory;

        @PostConstruct
        public void init() {
            this.customizers.forEach(customizer -> customizer.customize((Object)this.factory));
        }
    }
}

