/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.nacos.discovery;

import com.alibaba.cloud.nacos.NacosDiscoveryProperties;
import com.alibaba.cloud.nacos.NacosServiceManager;
import com.alibaba.nacos.api.naming.NamingService;
import com.alibaba.nacos.api.naming.listener.Event;
import com.alibaba.nacos.api.naming.listener.EventListener;
import com.alibaba.nacos.api.naming.listener.NamingEvent;
import com.alibaba.nacos.api.naming.pojo.Instance;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.context.SmartLifecycle;

public class NacosWatch
implements SmartLifecycle,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(NacosWatch.class);
    private final Map<String, EventListener> listenerMap = new ConcurrentHashMap<String, EventListener>(16);
    private final AtomicBoolean running = new AtomicBoolean(false);
    private final NacosServiceManager nacosServiceManager;
    private final NacosDiscoveryProperties properties;

    public NacosWatch(NacosServiceManager nacosServiceManager, NacosDiscoveryProperties properties) {
        this.nacosServiceManager = nacosServiceManager;
        this.properties = properties;
    }

    public boolean isAutoStartup() {
        return true;
    }

    public void stop(Runnable callback) {
        this.stop();
        callback.run();
    }

    public void start() {
        if (this.running.compareAndSet(false, true)) {
            EventListener eventListener = this.listenerMap.computeIfAbsent(this.buildKey(), event -> new EventListener(){

                public void onEvent(Event event) {
                    if (event instanceof NamingEvent) {
                        List instances = ((NamingEvent)event).getInstances();
                        Optional instanceOptional = NacosWatch.this.selectCurrentInstance(instances);
                        instanceOptional.ifPresent(currentInstance -> NacosWatch.this.resetIfNeeded(currentInstance));
                    }
                }
            });
            NamingService namingService = this.nacosServiceManager.getNamingService();
            try {
                namingService.subscribe(this.properties.getService(), this.properties.getGroup(), Arrays.asList(this.properties.getClusterName()), eventListener);
            }
            catch (Exception e) {
                log.error("namingService subscribe failed, properties:{}", (Object)this.properties, (Object)e);
            }
        }
    }

    private String buildKey() {
        return String.join((CharSequence)":", this.properties.getService(), this.properties.getGroup());
    }

    private void resetIfNeeded(Instance instance) {
        if (!this.properties.getMetadata().equals(instance.getMetadata())) {
            this.properties.setMetadata(instance.getMetadata());
        }
    }

    private Optional<Instance> selectCurrentInstance(List<Instance> instances) {
        return instances.stream().filter(instance -> this.properties.getIp().equals(instance.getIp()) && this.properties.getPort() == instance.getPort()).findFirst();
    }

    public void stop() {
        if (this.running.compareAndSet(true, false)) {
            EventListener eventListener = this.listenerMap.get(this.buildKey());
            try {
                NamingService namingService = this.nacosServiceManager.getNamingService();
                namingService.unsubscribe(this.properties.getService(), this.properties.getGroup(), Arrays.asList(this.properties.getClusterName()), eventListener);
            }
            catch (Exception e) {
                log.error("namingService unsubscribe failed, properties:{}", (Object)this.properties, (Object)e);
            }
        }
    }

    public boolean isRunning() {
        return this.running.get();
    }

    public int getPhase() {
        return 0;
    }

    public void destroy() {
        this.stop();
    }
}

