/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.dubbo.openfeign;

import com.alibaba.cloud.dubbo.annotation.DubboTransported;
import com.alibaba.cloud.dubbo.metadata.DubboRestServiceMetadata;
import com.alibaba.cloud.dubbo.metadata.DubboTransportedMethodMetadata;
import com.alibaba.cloud.dubbo.metadata.MethodMetadata;
import com.alibaba.cloud.dubbo.metadata.RequestMetadata;
import com.alibaba.cloud.dubbo.metadata.RestMethodMetadata;
import com.alibaba.cloud.dubbo.metadata.repository.DubboServiceMetadataRepository;
import com.alibaba.cloud.dubbo.metadata.resolver.DubboTransportedMethodMetadataResolver;
import com.alibaba.cloud.dubbo.openfeign.DubboInvocationHandler;
import com.alibaba.cloud.dubbo.openfeign.FeignMethodMetadata;
import com.alibaba.cloud.dubbo.service.DubboGenericServiceExecutionContextFactory;
import com.alibaba.cloud.dubbo.service.DubboGenericServiceFactory;
import feign.Contract;
import feign.Target;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Map;
import org.apache.dubbo.rpc.service.GenericService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.openfeign.FeignContext;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertyResolver;

class TargeterInvocationHandler
implements InvocationHandler {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Object bean;
    private final Environment environment;
    private final ClassLoader classLoader;
    private final DubboServiceMetadataRepository repository;
    private final DubboGenericServiceFactory dubboGenericServiceFactory;
    private final DubboGenericServiceExecutionContextFactory contextFactory;

    TargeterInvocationHandler(Object bean, Environment environment, ClassLoader classLoader, DubboServiceMetadataRepository repository, DubboGenericServiceFactory dubboGenericServiceFactory, DubboGenericServiceExecutionContextFactory contextFactory) {
        this.bean = bean;
        this.environment = environment;
        this.classLoader = classLoader;
        this.repository = repository;
        this.dubboGenericServiceFactory = dubboGenericServiceFactory;
        this.contextFactory = contextFactory;
    }

    private static <T> T cast(Object object) {
        return (T)object;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        FeignContext feignContext = (FeignContext)TargeterInvocationHandler.cast(args[2]);
        Target.HardCodedTarget target = (Target.HardCodedTarget)TargeterInvocationHandler.cast(args[3]);
        method.setAccessible(true);
        Object defaultProxy = method.invoke(this.bean, args);
        return this.createDubboProxyIfRequired(feignContext, (Target)target, defaultProxy);
    }

    private Object createDubboProxyIfRequired(FeignContext feignContext, Target target, Object defaultProxy) {
        DubboInvocationHandler dubboInvocationHandler = this.createDubboInvocationHandler(feignContext, target, defaultProxy);
        if (dubboInvocationHandler == null) {
            return defaultProxy;
        }
        return Proxy.newProxyInstance(target.type().getClassLoader(), new Class[]{target.type()}, (InvocationHandler)dubboInvocationHandler);
    }

    private DubboInvocationHandler createDubboInvocationHandler(FeignContext feignContext, Target target, Object defaultFeignClientProxy) {
        String serviceName = target.name();
        Class targetType = target.type();
        Contract contract = (Contract)feignContext.getInstance(serviceName, Contract.class);
        DubboTransportedMethodMetadataResolver resolver = new DubboTransportedMethodMetadataResolver((PropertyResolver)this.environment, contract);
        Map<DubboTransportedMethodMetadata, RestMethodMetadata> feignRestMethodMetadataMap = resolver.resolve(targetType);
        if (feignRestMethodMetadataMap.isEmpty()) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("@{} method was not found in the Feign target type[{}]", (Object)DubboTransported.class.getSimpleName(), (Object)targetType.getName());
            }
            return null;
        }
        this.repository.initializeMetadata(serviceName);
        Map<Method, FeignMethodMetadata> feignMethodMetadataMap = this.getFeignMethodMetadataMap(serviceName, feignRestMethodMetadataMap);
        InvocationHandler defaultFeignClientInvocationHandler = Proxy.getInvocationHandler(defaultFeignClientProxy);
        DubboInvocationHandler dubboInvocationHandler = new DubboInvocationHandler(feignMethodMetadataMap, defaultFeignClientInvocationHandler, this.classLoader, this.contextFactory);
        return dubboInvocationHandler;
    }

    private Map<Method, FeignMethodMetadata> getFeignMethodMetadataMap(String serviceName, Map<DubboTransportedMethodMetadata, RestMethodMetadata> feignRestMethodMetadataMap) {
        HashMap<Method, FeignMethodMetadata> feignMethodMetadataMap = new HashMap<Method, FeignMethodMetadata>();
        for (Map.Entry<DubboTransportedMethodMetadata, RestMethodMetadata> entry : feignRestMethodMetadataMap.entrySet()) {
            RestMethodMetadata feignRestMethodMetadata = entry.getValue();
            RequestMetadata feignRequestMetadata = feignRestMethodMetadata.getRequest();
            DubboRestServiceMetadata metadata = this.repository.get(serviceName, feignRequestMetadata);
            if (metadata == null) continue;
            DubboTransportedMethodMetadata dubboTransportedMethodMetadata = entry.getKey();
            Map<String, Object> dubboTranslatedAttributes = dubboTransportedMethodMetadata.getAttributes();
            Method method = dubboTransportedMethodMetadata.getMethod();
            GenericService dubboGenericService = this.dubboGenericServiceFactory.create(metadata, dubboTranslatedAttributes);
            RestMethodMetadata dubboRestMethodMetadata = metadata.getRestMethodMetadata();
            MethodMetadata methodMetadata = dubboTransportedMethodMetadata.getMethodMetadata();
            FeignMethodMetadata feignMethodMetadata = new FeignMethodMetadata(dubboGenericService, dubboRestMethodMetadata, feignRestMethodMetadata);
            feignMethodMetadataMap.put(method, feignMethodMetadata);
        }
        return feignMethodMetadataMap;
    }
}

