/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.dubbo.registry.event;

import java.util.Collection;
import java.util.Collections;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.context.ApplicationEvent;

public class ServiceInstancesChangedEvent
extends ApplicationEvent {
    private final String serviceName;
    private final Collection<ServiceInstance> serviceInstances;
    private boolean processed = false;

    public ServiceInstancesChangedEvent(String serviceName, Collection<ServiceInstance> serviceInstances) {
        super((Object)serviceName);
        this.serviceName = serviceName;
        this.serviceInstances = Collections.unmodifiableCollection(serviceInstances);
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public Collection<ServiceInstance> getServiceInstances() {
        return this.serviceInstances;
    }

    public void processed() {
        this.processed = true;
    }

    public boolean isProcessed() {
        return this.processed;
    }
}

