/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.stream.binder.rocketmq.metrics;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import org.springframework.context.Lifecycle;

public class Instrumentation {
    private final String name;
    private Lifecycle actuator;
    protected final AtomicBoolean started = new AtomicBoolean(false);
    protected Exception startException = null;

    public Instrumentation(String name) {
        this.name = name;
    }

    public Instrumentation(String name, Lifecycle actuator) {
        this.name = name;
        this.actuator = actuator;
    }

    public Lifecycle getActuator() {
        return this.actuator;
    }

    public void setActuator(Lifecycle actuator) {
        this.actuator = actuator;
    }

    public boolean isDown() {
        return this.startException != null;
    }

    public boolean isUp() {
        return this.started.get();
    }

    public boolean isOutOfService() {
        return !this.started.get() && this.startException == null;
    }

    public void markStartedSuccessfully() {
        this.started.set(true);
    }

    public void markStartFailed(Exception e) {
        this.started.set(false);
        this.startException = e;
    }

    public String getName() {
        return this.name;
    }

    public boolean isStarted() {
        return this.started.get();
    }

    public Exception getStartException() {
        return this.startException;
    }

    public int hashCode() {
        return Objects.hash(this.getName(), this.getActuator());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Instrumentation that = (Instrumentation)o;
        return this.name.equals(that.name) && this.actuator.equals(that.actuator);
    }
}

