/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.cluster.client.init;

import com.alibaba.csp.sentinel.cluster.client.codec.data.FlowRequestDataWriter;
import com.alibaba.csp.sentinel.cluster.client.codec.data.FlowResponseDataDecoder;
import com.alibaba.csp.sentinel.cluster.client.codec.data.ParamFlowRequestDataWriter;
import com.alibaba.csp.sentinel.cluster.client.codec.data.PingRequestDataWriter;
import com.alibaba.csp.sentinel.cluster.client.codec.data.PingResponseDataDecoder;
import com.alibaba.csp.sentinel.cluster.client.codec.registry.RequestDataWriterRegistry;
import com.alibaba.csp.sentinel.cluster.client.codec.registry.ResponseDataDecodeRegistry;
import com.alibaba.csp.sentinel.cluster.client.config.ClusterClientStartUpConfig;
import com.alibaba.csp.sentinel.init.InitFunc;
import com.alibaba.csp.sentinel.init.InitOrder;

@InitOrder(value=0)
public class DefaultClusterClientInitFunc
implements InitFunc {
    public void init() throws Exception {
        this.initDefaultEntityWriters();
        this.initDefaultEntityDecoders();
    }

    private void initDefaultEntityWriters() {
        RequestDataWriterRegistry.addWriter(0, new PingRequestDataWriter());
        RequestDataWriterRegistry.addWriter(1, new FlowRequestDataWriter());
        Integer maxParamByteSize = ClusterClientStartUpConfig.getMaxParamByteSize();
        if (maxParamByteSize == null) {
            RequestDataWriterRegistry.addWriter(2, new ParamFlowRequestDataWriter());
        } else {
            RequestDataWriterRegistry.addWriter(2, new ParamFlowRequestDataWriter(maxParamByteSize));
        }
    }

    private void initDefaultEntityDecoders() {
        ResponseDataDecodeRegistry.addDecoder(0, new PingResponseDataDecoder());
        ResponseDataDecodeRegistry.addDecoder(1, new FlowResponseDataDecoder());
        ResponseDataDecodeRegistry.addDecoder(2, new FlowResponseDataDecoder());
    }
}

