/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.cluster.client.handler;

import com.alibaba.csp.sentinel.cluster.client.handler.TokenClientPromiseHolder;
import com.alibaba.csp.sentinel.cluster.registry.ConfigSupplierRegistry;
import com.alibaba.csp.sentinel.cluster.request.ClusterRequest;
import com.alibaba.csp.sentinel.cluster.response.ClusterResponse;
import com.alibaba.csp.sentinel.log.RecordLog;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import java.net.InetSocketAddress;
import java.util.concurrent.atomic.AtomicInteger;

public class TokenClientHandler
extends ChannelInboundHandlerAdapter {
    private final AtomicInteger currentState;
    private final Runnable disconnectCallback;

    public TokenClientHandler(AtomicInteger currentState, Runnable disconnectCallback) {
        this.currentState = currentState;
        this.disconnectCallback = disconnectCallback;
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        this.currentState.set(2);
        this.fireClientPing(ctx);
        RecordLog.info((String)"[TokenClientHandler] Client handler active, remote address: {}", (Object[])new Object[]{this.getRemoteAddress(ctx)});
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof ClusterResponse) {
            ClusterResponse response = (ClusterResponse)msg;
            if (response.getType() == 0) {
                this.handlePingResponse(ctx, response);
                return;
            }
            TokenClientPromiseHolder.completePromise(response.getId(), response);
        }
    }

    private void fireClientPing(ChannelHandlerContext ctx) {
        ClusterRequest ping = new ClusterRequest().setId(0).setType(0).setData((Object)((String)ConfigSupplierRegistry.getNamespaceSupplier().get()));
        ctx.writeAndFlush((Object)ping);
    }

    private void handlePingResponse(ChannelHandlerContext ctx, ClusterResponse response) {
        if (response.getStatus() == 0) {
            int count = (Integer)response.getData();
            RecordLog.info((String)"[TokenClientHandler] Client ping OK (target server: {}, connected count: {})", (Object[])new Object[]{this.getRemoteAddress(ctx), count});
        } else {
            RecordLog.warn((String)"[TokenClientHandler] Client ping failed (target server: {})", (Object[])new Object[]{this.getRemoteAddress(ctx)});
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        RecordLog.warn((String)"[TokenClientHandler] Client exception caught", (Throwable)cause);
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        RecordLog.info((String)"[TokenClientHandler] Client handler inactive, remote address: {}", (Object[])new Object[]{this.getRemoteAddress(ctx)});
    }

    public void channelUnregistered(ChannelHandlerContext ctx) throws Exception {
        RecordLog.info((String)"[TokenClientHandler] Client channel unregistered, remote address: {}", (Object[])new Object[]{this.getRemoteAddress(ctx)});
        this.currentState.set(0);
        this.disconnectCallback.run();
    }

    private String getRemoteAddress(ChannelHandlerContext ctx) {
        if (ctx.channel().remoteAddress() == null) {
            return null;
        }
        InetSocketAddress inetAddress = (InetSocketAddress)ctx.channel().remoteAddress();
        return inetAddress.getAddress().getHostAddress() + ":" + inetAddress.getPort();
    }

    public int getCurrentState() {
        return this.currentState.get();
    }

    public boolean hasStarted() {
        return this.getCurrentState() == 2;
    }
}

