/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.cluster.flow.statistic.metric;

import com.alibaba.csp.sentinel.cluster.flow.statistic.data.ClusterFlowEvent;
import com.alibaba.csp.sentinel.cluster.flow.statistic.data.ClusterMetricBucket;
import com.alibaba.csp.sentinel.slots.statistic.base.LeapArray;
import com.alibaba.csp.sentinel.slots.statistic.base.LongAdder;
import com.alibaba.csp.sentinel.slots.statistic.base.WindowWrap;

public class ClusterMetricLeapArray
extends LeapArray<ClusterMetricBucket> {
    private final LongAdder[] occupyCounter;
    private boolean hasOccupied = false;

    public ClusterMetricLeapArray(int windowLengthInMs, int intervalInMs) {
        super(windowLengthInMs, intervalInMs / 1000);
        ClusterFlowEvent[] events = ClusterFlowEvent.values();
        this.occupyCounter = new LongAdder[events.length];
        for (ClusterFlowEvent event : events) {
            this.occupyCounter[event.ordinal()] = new LongAdder();
        }
    }

    public ClusterMetricBucket newEmptyBucket() {
        return new ClusterMetricBucket();
    }

    protected WindowWrap<ClusterMetricBucket> resetWindowTo(WindowWrap<ClusterMetricBucket> w, long startTime) {
        w.resetTo(startTime);
        ((ClusterMetricBucket)w.value()).reset();
        this.transferOccupyToBucket((ClusterMetricBucket)w.value());
        return w;
    }

    private void transferOccupyToBucket(ClusterMetricBucket bucket) {
        if (this.hasOccupied) {
            this.transferOccupiedCount(bucket, ClusterFlowEvent.PASS, ClusterFlowEvent.OCCUPIED_PASS);
            this.transferOccupiedThenReset(bucket, ClusterFlowEvent.PASS);
            this.transferOccupiedThenReset(bucket, ClusterFlowEvent.PASS_REQUEST);
            this.hasOccupied = false;
        }
    }

    private void transferOccupiedCount(ClusterMetricBucket bucket, ClusterFlowEvent source, ClusterFlowEvent target) {
        bucket.add(target, this.occupyCounter[source.ordinal()].sum());
    }

    private void transferOccupiedThenReset(ClusterMetricBucket bucket, ClusterFlowEvent event) {
        bucket.add(event, this.occupyCounter[event.ordinal()].sumThenReset());
    }

    public void addOccupyPass(int count) {
        this.occupyCounter[ClusterFlowEvent.PASS.ordinal()].add((long)count);
        this.occupyCounter[ClusterFlowEvent.PASS_REQUEST.ordinal()].add(1L);
        this.hasOccupied = true;
    }

    public long getOccupiedCount(ClusterFlowEvent event) {
        return this.occupyCounter[event.ordinal()].sum();
    }

    public long getFirstCountOfWindow(ClusterFlowEvent event) {
        if (event == null) {
            return 0L;
        }
        WindowWrap windowWrap = this.getValidHead();
        if (windowWrap == null) {
            return 0L;
        }
        return ((ClusterMetricBucket)windowWrap.value()).get(event);
    }
}

