/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.cluster.flow.statistic.metric;

import com.alibaba.csp.sentinel.slots.statistic.base.LeapArray;
import com.alibaba.csp.sentinel.slots.statistic.base.WindowWrap;
import com.alibaba.csp.sentinel.slots.statistic.cache.CacheMap;
import com.alibaba.csp.sentinel.slots.statistic.cache.ConcurrentLinkedHashMapWrapper;
import com.alibaba.csp.sentinel.util.AssertUtil;

public class ClusterParameterLeapArray<C>
extends LeapArray<CacheMap<Object, C>> {
    private final int maxCapacity;

    public ClusterParameterLeapArray(int windowLengthInMs, int intervalInMs, int maxCapacity) {
        super(windowLengthInMs, intervalInMs / 1000);
        AssertUtil.isTrue((maxCapacity > 0 ? 1 : 0) != 0, (String)"maxCapacity of LRU map should be positive");
        this.maxCapacity = maxCapacity;
    }

    public CacheMap<Object, C> newEmptyBucket() {
        return new ConcurrentLinkedHashMapWrapper((long)this.maxCapacity);
    }

    protected WindowWrap<CacheMap<Object, C>> resetWindowTo(WindowWrap<CacheMap<Object, C>> w, long startTime) {
        w.resetTo(startTime);
        ((CacheMap)w.value()).clear();
        return w;
    }
}

