/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.cluster.flow.statistic;

import com.alibaba.csp.sentinel.cluster.flow.statistic.metric.ClusterMetric;
import com.alibaba.csp.sentinel.cluster.server.config.ClusterServerConfigManager;
import com.alibaba.csp.sentinel.util.AssertUtil;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public final class ClusterMetricStatistics {
    private static final Map<Long, ClusterMetric> METRIC_MAP = new ConcurrentHashMap<Long, ClusterMetric>();

    public static void clear() {
        METRIC_MAP.clear();
    }

    public static void putMetric(long id, ClusterMetric metric) {
        AssertUtil.notNull((Object)metric, (String)"Cluster metric cannot be null");
        METRIC_MAP.put(id, metric);
    }

    public static boolean putMetricIfAbsent(long id, ClusterMetric metric) {
        AssertUtil.notNull((Object)metric, (String)"Cluster metric cannot be null");
        if (METRIC_MAP.containsKey(id)) {
            return false;
        }
        METRIC_MAP.put(id, metric);
        return true;
    }

    public static void removeMetric(long id) {
        METRIC_MAP.remove(id);
    }

    public static ClusterMetric getMetric(long id) {
        return METRIC_MAP.get(id);
    }

    public static void resetFlowMetrics() {
        Set<Long> keySet = METRIC_MAP.keySet();
        for (Long id : keySet) {
            METRIC_MAP.put(id, new ClusterMetric(ClusterServerConfigManager.getSampleCount(), ClusterServerConfigManager.getIntervalMs()));
        }
    }

    private ClusterMetricStatistics() {
    }
}

