/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.cluster.server.connection;

import com.alibaba.csp.sentinel.cluster.server.connection.Connection;
import com.alibaba.csp.sentinel.cluster.server.connection.NettyConnection;
import com.alibaba.csp.sentinel.cluster.server.connection.ScanIdleConnectionTask;
import com.alibaba.csp.sentinel.log.RecordLog;
import io.netty.channel.Channel;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class ConnectionPool {
    private static final ScheduledExecutorService TIMER = Executors.newScheduledThreadPool(2);
    private final Map<String, Connection> CONNECTION_MAP = new ConcurrentHashMap<String, Connection>();
    private ScheduledFuture scanTaskFuture = null;

    public void createConnection(Channel channel) {
        if (channel != null) {
            NettyConnection connection = new NettyConnection(channel, this);
            String connKey = this.getConnectionKey(channel);
            this.CONNECTION_MAP.put(connKey, connection);
        }
    }

    private synchronized void startScan() {
        if (this.scanTaskFuture == null || this.scanTaskFuture.isCancelled() || this.scanTaskFuture.isDone()) {
            this.scanTaskFuture = TIMER.scheduleAtFixedRate(new ScanIdleConnectionTask(this), 10L, 30L, TimeUnit.SECONDS);
        }
    }

    private String getConnectionKey(Channel channel) {
        InetSocketAddress socketAddress = (InetSocketAddress)channel.remoteAddress();
        String remoteIp = socketAddress.getAddress().getHostAddress();
        int remotePort = socketAddress.getPort();
        return remoteIp + ":" + remotePort;
    }

    private String getConnectionKey(String ip, int port) {
        return ip + ":" + port;
    }

    public void refreshLastReadTime(Channel channel) {
        String connKey;
        Connection connection;
        if (channel != null && (connection = this.CONNECTION_MAP.get(connKey = this.getConnectionKey(channel))) != null) {
            connection.refreshLastReadTime(System.currentTimeMillis());
        }
    }

    public Connection getConnection(String remoteIp, int remotePort) {
        String connKey = this.getConnectionKey(remoteIp, remotePort);
        return this.CONNECTION_MAP.get(connKey);
    }

    public void remove(Channel channel) {
        String connKey = this.getConnectionKey(channel);
        this.CONNECTION_MAP.remove(connKey);
    }

    public List<Connection> listAllConnection() {
        ArrayList<Connection> connections = new ArrayList<Connection>(this.CONNECTION_MAP.values());
        return connections;
    }

    public int count() {
        return this.CONNECTION_MAP.size();
    }

    public void clear() {
        this.CONNECTION_MAP.clear();
    }

    public void shutdownAll() throws Exception {
        for (Connection c : this.CONNECTION_MAP.values()) {
            c.close();
        }
    }

    public void refreshIdleTask() {
        if (this.scanTaskFuture == null || this.scanTaskFuture.cancel(false)) {
            this.startScan();
        } else {
            RecordLog.info((String)"The result of canceling scanTask is error.", (Object[])new Object[0]);
        }
    }
}

