/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.node.metric;

import com.alibaba.csp.sentinel.config.SentinelConfig;
import com.alibaba.csp.sentinel.log.RecordLog;
import com.alibaba.csp.sentinel.node.ClusterNode;
import com.alibaba.csp.sentinel.node.metric.MetricNode;
import com.alibaba.csp.sentinel.node.metric.MetricWriter;
import com.alibaba.csp.sentinel.slotchain.ResourceWrapper;
import com.alibaba.csp.sentinel.slots.clusterbuilder.ClusterBuilderSlot;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class MetricTimerListener
implements Runnable {
    private static final MetricWriter metricWriter = new MetricWriter(SentinelConfig.singleMetricFileSize(), SentinelConfig.totalMetricFileCount());

    @Override
    public void run() {
        TreeMap maps = new TreeMap();
        for (Map.Entry<ResourceWrapper, ClusterNode> entry : ClusterBuilderSlot.getClusterNodeMap().entrySet()) {
            String name = entry.getKey().getName();
            ClusterNode node = entry.getValue();
            Map<Long, MetricNode> metrics = node.metrics();
            for (Map.Entry<Long, MetricNode> entry2 : metrics.entrySet()) {
                long time = entry2.getKey();
                MetricNode metricNode = entry2.getValue();
                metricNode.setResource(name);
                if (maps.get(time) == null) {
                    maps.put(time, new ArrayList());
                }
                List nodes = (List)maps.get(time);
                nodes.add(entry2.getValue());
            }
        }
        if (!maps.isEmpty()) {
            for (Map.Entry<ResourceWrapper, ClusterNode> entry : maps.entrySet()) {
                try {
                    metricWriter.write((Long)((Object)entry.getKey()), (List)((Object)entry.getValue()));
                }
                catch (Exception e) {
                    RecordLog.info("write metric error: ", e);
                }
            }
        }
    }
}

