/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.node.metric;

import com.alibaba.csp.sentinel.node.metric.MetricNode;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;

class MetricsReader {
    private static final int maxLinesReturn = 100000;
    private Charset charset;

    public MetricsReader(Charset charset) {
        this.charset = charset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean readMetricsInOneFileByEndTime(List<MetricNode> list, String fileName, long offset, long endTimeMs, String identity) throws Exception {
        FileInputStream in = null;
        long endSecond = endTimeMs / 1000L;
        try {
            String line;
            in = new FileInputStream(fileName);
            in.getChannel().position(offset);
            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)in, this.charset));
            while ((line = reader.readLine()) != null) {
                MetricNode node = MetricNode.fromFatString(line);
                long currentSecond = node.getTimestamp() / 1000L;
                if (currentSecond <= endSecond) {
                    if (identity == null) {
                        list.add(node);
                    } else if (node.getResource().equals(identity)) {
                        list.add(node);
                    }
                } else {
                    boolean bl = false;
                    return bl;
                }
                if (list.size() < 100000) continue;
                boolean bl = false;
                return bl;
            }
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void readMetricsInOneFile(List<MetricNode> list, String fileName, long offset, int recommendLines) throws Exception {
        long lastSecond = -1L;
        if (list.size() > 0) {
            lastSecond = list.get(list.size() - 1).getTimestamp() / 1000L;
        }
        FileInputStream in = null;
        try {
            String line;
            in = new FileInputStream(fileName);
            in.getChannel().position(offset);
            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)in, this.charset));
            while ((line = reader.readLine()) != null) {
                MetricNode node = MetricNode.fromFatString(line);
                long currentSecond = node.getTimestamp() / 1000L;
                if (list.size() < recommendLines) {
                    list.add(node);
                } else {
                    if (currentSecond != lastSecond) break;
                    list.add(node);
                }
                lastSecond = currentSecond;
            }
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    List<MetricNode> readMetricsByEndTime(List<String> fileNames, int pos, long offset, long endTimeMs, String identity) throws Exception {
        ArrayList<MetricNode> list = new ArrayList<MetricNode>(1024);
        if (this.readMetricsInOneFileByEndTime(list, fileNames.get(pos++), offset, endTimeMs, identity)) {
            while (pos < fileNames.size() && this.readMetricsInOneFileByEndTime(list, fileNames.get(pos++), 0L, endTimeMs, identity)) {
            }
        }
        return list;
    }

    List<MetricNode> readMetrics(List<String> fileNames, int pos, long offset, int recommendLines) throws Exception {
        ArrayList<MetricNode> list = new ArrayList<MetricNode>(recommendLines);
        this.readMetricsInOneFile(list, fileNames.get(pos++), offset, recommendLines);
        while (list.size() < recommendLines && pos < fileNames.size()) {
            this.readMetricsInOneFile(list, fileNames.get(pos++), 0L, recommendLines);
        }
        return list;
    }
}

