/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.slots.block.degrade;

import com.alibaba.csp.sentinel.context.Context;
import com.alibaba.csp.sentinel.log.RecordLog;
import com.alibaba.csp.sentinel.node.DefaultNode;
import com.alibaba.csp.sentinel.property.DynamicSentinelProperty;
import com.alibaba.csp.sentinel.property.PropertyListener;
import com.alibaba.csp.sentinel.property.SentinelProperty;
import com.alibaba.csp.sentinel.slotchain.ResourceWrapper;
import com.alibaba.csp.sentinel.slots.block.BlockException;
import com.alibaba.csp.sentinel.slots.block.degrade.DegradeException;
import com.alibaba.csp.sentinel.slots.block.degrade.DegradeRule;
import com.alibaba.csp.sentinel.util.StringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class DegradeRuleManager {
    private static volatile Map<String, List<DegradeRule>> degradeRules = new ConcurrentHashMap<String, List<DegradeRule>>();
    static final RulePropertyListener listener = new RulePropertyListener();
    private static SentinelProperty<List<DegradeRule>> currentProperty = new DynamicSentinelProperty<List<DegradeRule>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void register2Property(SentinelProperty<List<DegradeRule>> property) {
        RulePropertyListener rulePropertyListener = listener;
        synchronized (rulePropertyListener) {
            RecordLog.info("[DegradeRuleManager] Registering new property to degrade rule manager", new Object[0]);
            currentProperty.removeListener(listener);
            property.addListener(listener);
            currentProperty = property;
        }
    }

    public static void checkDegrade(ResourceWrapper resource, Context context, DefaultNode node, int count) throws BlockException {
        if (degradeRules == null) {
            return;
        }
        List<DegradeRule> rules = degradeRules.get(resource.getName());
        if (rules == null) {
            return;
        }
        for (DegradeRule rule : rules) {
            if (rule.passCheck(context, node, count, new Object[0])) continue;
            throw new DegradeException(rule.getLimitApp());
        }
    }

    public static boolean hasConfig(String resource) {
        return degradeRules.containsKey(resource);
    }

    public static List<DegradeRule> getRules() {
        ArrayList<DegradeRule> rules = new ArrayList<DegradeRule>();
        if (degradeRules == null) {
            return rules;
        }
        for (Map.Entry<String, List<DegradeRule>> entry : degradeRules.entrySet()) {
            rules.addAll((Collection<DegradeRule>)entry.getValue());
        }
        return rules;
    }

    public static void loadRules(List<DegradeRule> rules) {
        try {
            currentProperty.updateValue(rules);
        }
        catch (Throwable e) {
            RecordLog.info(e.getMessage(), e);
        }
    }

    public static boolean isValidRule(DegradeRule rule) {
        boolean baseValid;
        boolean bl = baseValid = rule != null && !StringUtil.isBlank(rule.getResource()) && rule.getCount() >= 0.0 && rule.getTimeWindow() > 0;
        if (!baseValid) {
            return false;
        }
        return rule.getGrade() != 1 || !(rule.getCount() > 1.0);
    }

    static {
        currentProperty.addListener(listener);
    }

    private static class RulePropertyListener
    implements PropertyListener<List<DegradeRule>> {
        private RulePropertyListener() {
        }

        @Override
        public void configUpdate(List<DegradeRule> conf) {
            Map<String, List<DegradeRule>> rules = this.loadDegradeConf(conf);
            if (rules != null) {
                degradeRules.clear();
                degradeRules.putAll(rules);
            }
            RecordLog.info("[DegradeRuleManager] Degrade rules received: " + degradeRules, new Object[0]);
        }

        @Override
        public void configLoad(List<DegradeRule> conf) {
            Map<String, List<DegradeRule>> rules = this.loadDegradeConf(conf);
            if (rules != null) {
                degradeRules.clear();
                degradeRules.putAll(rules);
            }
            RecordLog.info("[DegradeRuleManager] Degrade rules loaded: " + degradeRules, new Object[0]);
        }

        private Map<String, List<DegradeRule>> loadDegradeConf(List<DegradeRule> list) {
            ConcurrentHashMap<String, List<DegradeRule>> newRuleMap = new ConcurrentHashMap<String, List<DegradeRule>>();
            if (list == null || list.isEmpty()) {
                return newRuleMap;
            }
            for (DegradeRule rule : list) {
                String identity;
                ArrayList<DegradeRule> ruleM;
                if (!DegradeRuleManager.isValidRule(rule)) {
                    RecordLog.warn("[DegradeRuleManager] Ignoring invalid degrade rule when loading new rules: " + rule, new Object[0]);
                    continue;
                }
                if (StringUtil.isBlank(rule.getLimitApp())) {
                    rule.setLimitApp("default");
                }
                if ((ruleM = (ArrayList<DegradeRule>)newRuleMap.get(identity = rule.getResource())) == null) {
                    ruleM = new ArrayList<DegradeRule>();
                    newRuleMap.put(identity, ruleM);
                }
                ruleM.add(rule);
            }
            return newRuleMap;
        }
    }
}

