/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.slots.clusterbuilder;

import com.alibaba.csp.sentinel.EntryType;
import com.alibaba.csp.sentinel.Env;
import com.alibaba.csp.sentinel.context.Context;
import com.alibaba.csp.sentinel.node.ClusterNode;
import com.alibaba.csp.sentinel.node.DefaultNode;
import com.alibaba.csp.sentinel.node.Node;
import com.alibaba.csp.sentinel.slotchain.AbstractLinkedProcessorSlot;
import com.alibaba.csp.sentinel.slotchain.ResourceWrapper;
import com.alibaba.csp.sentinel.slotchain.StringResourceWrapper;
import java.util.HashMap;
import java.util.Map;

public class ClusterBuilderSlot
extends AbstractLinkedProcessorSlot<DefaultNode> {
    private static volatile Map<ResourceWrapper, ClusterNode> clusterNodeMap = new HashMap<ResourceWrapper, ClusterNode>();
    private static final Object lock = new Object();
    private ClusterNode clusterNode = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void entry(Context context, ResourceWrapper resourceWrapper, DefaultNode node, int count, Object ... args) throws Throwable {
        if (this.clusterNode == null) {
            Object object = lock;
            synchronized (object) {
                if (this.clusterNode == null) {
                    this.clusterNode = Env.nodeBuilder.buildClusterNode();
                    HashMap<ResourceWrapper, ClusterNode> newMap = new HashMap<ResourceWrapper, ClusterNode>(16);
                    newMap.putAll(clusterNodeMap);
                    newMap.put(node.getId(), this.clusterNode);
                    clusterNodeMap = newMap;
                }
            }
        }
        node.setClusterNode(this.clusterNode);
        if (!"".equals(context.getOrigin())) {
            Node originNode = node.getClusterNode().getOriginNode(context.getOrigin());
            context.getCurEntry().setOriginNode(originNode);
        }
        this.fireEntry(context, resourceWrapper, node, count, args);
    }

    @Override
    public void exit(Context context, ResourceWrapper resourceWrapper, int count, Object ... args) {
        this.fireExit(context, resourceWrapper, count, args);
    }

    public static ClusterNode getClusterNode(String id, EntryType type) {
        return clusterNodeMap.get(new StringResourceWrapper(id, type));
    }

    public static ClusterNode getClusterNode(String id) {
        EntryType nodeType;
        if (id == null) {
            return null;
        }
        ClusterNode clusterNode = null;
        EntryType[] entryTypeArray = EntryType.values();
        int n = entryTypeArray.length;
        for (int i = 0; i < n && (clusterNode = clusterNodeMap.get(new StringResourceWrapper(id, nodeType = entryTypeArray[i]))) == null; ++i) {
        }
        return clusterNode;
    }

    public static Map<ResourceWrapper, ClusterNode> getClusterNodeMap() {
        return clusterNodeMap;
    }

    public static void resetClusterNodes() {
        for (ClusterNode node : clusterNodeMap.values()) {
            node.reset();
        }
    }
}

