/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.slots.statistic.base;

import com.alibaba.csp.sentinel.slots.statistic.base.LongAdder;

public class MetricBucket {
    private final LongAdder pass = new LongAdder();
    private final LongAdder block = new LongAdder();
    private final LongAdder exception = new LongAdder();
    private final LongAdder rt = new LongAdder();
    private final LongAdder success = new LongAdder();
    private volatile long minRt;

    public MetricBucket() {
        this.initMinRt();
    }

    private void initMinRt() {
        this.minRt = 4900L;
    }

    public MetricBucket reset() {
        this.pass.reset();
        this.block.reset();
        this.exception.reset();
        this.rt.reset();
        this.success.reset();
        this.initMinRt();
        return this;
    }

    public long pass() {
        return this.pass.sum();
    }

    public long block() {
        return this.block.sum();
    }

    public long exception() {
        return this.exception.sum();
    }

    public long rt() {
        return this.rt.sum();
    }

    public long minRt() {
        return this.minRt;
    }

    public long success() {
        return this.success.sum();
    }

    public void addPass() {
        this.pass.add(1L);
    }

    public void addException() {
        this.exception.add(1L);
    }

    public void addBlock() {
        this.block.add(1L);
    }

    public void addSuccess() {
        this.success.add(1L);
    }

    public void addRT(long rt) {
        this.rt.add(rt);
        if (rt < this.minRt) {
            this.minRt = rt;
        }
    }
}

