/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.slots.block.flow;

import com.alibaba.csp.sentinel.log.RecordLog;
import com.alibaba.csp.sentinel.slots.block.flow.ClusterFlowConfig;
import com.alibaba.csp.sentinel.slots.block.flow.ColdFactorProperty;
import com.alibaba.csp.sentinel.slots.block.flow.FlowRule;
import com.alibaba.csp.sentinel.slots.block.flow.FlowRuleComparator;
import com.alibaba.csp.sentinel.slots.block.flow.TrafficShapingController;
import com.alibaba.csp.sentinel.slots.block.flow.controller.DefaultController;
import com.alibaba.csp.sentinel.slots.block.flow.controller.RateLimiterController;
import com.alibaba.csp.sentinel.slots.block.flow.controller.WarmUpController;
import com.alibaba.csp.sentinel.slots.block.flow.controller.WarmUpRateLimiterController;
import com.alibaba.csp.sentinel.util.StringUtil;
import com.alibaba.csp.sentinel.util.function.Function;
import com.alibaba.csp.sentinel.util.function.Predicate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class FlowRuleUtil {
    private static final Function<FlowRule, String> extractResource = new Function<FlowRule, String>(){

        @Override
        public String apply(FlowRule rule) {
            return rule.getResource();
        }
    };

    public static Map<String, List<FlowRule>> buildFlowRuleMap(List<FlowRule> list) {
        return FlowRuleUtil.buildFlowRuleMap(list, null);
    }

    public static Map<String, List<FlowRule>> buildFlowRuleMap(List<FlowRule> list, Predicate<FlowRule> filter) {
        return FlowRuleUtil.buildFlowRuleMap(list, filter, true);
    }

    public static Map<String, List<FlowRule>> buildFlowRuleMap(List<FlowRule> list, Predicate<FlowRule> filter, boolean shouldSort) {
        return FlowRuleUtil.buildFlowRuleMap(list, extractResource, filter, shouldSort);
    }

    public static <K> Map<K, List<FlowRule>> buildFlowRuleMap(List<FlowRule> list, Function<FlowRule, K> groupFunction, Predicate<FlowRule> filter, boolean shouldSort) {
        ConcurrentHashMap<K, ArrayList<FlowRule>> newRuleMap = new ConcurrentHashMap<K, ArrayList<FlowRule>>();
        if (list == null || list.isEmpty()) {
            return newRuleMap;
        }
        for (FlowRule rule : list) {
            if (!FlowRuleUtil.isValidRule(rule)) {
                RecordLog.warn("[FlowRuleManager] Ignoring invalid flow rule when loading new flow rules: " + rule, new Object[0]);
                continue;
            }
            if (filter != null && !filter.test(rule)) continue;
            if (StringUtil.isBlank(rule.getLimitApp())) {
                rule.setLimitApp("default");
            }
            TrafficShapingController rater = FlowRuleUtil.generateRater(rule);
            rule.setRater(rater);
            K key = groupFunction.apply(rule);
            if (key == null) continue;
            ArrayList<FlowRule> flowRules = (ArrayList<FlowRule>)newRuleMap.get(key);
            if (flowRules == null) {
                flowRules = new ArrayList<FlowRule>();
                newRuleMap.put(key, flowRules);
            }
            flowRules.add(rule);
        }
        if (shouldSort && !newRuleMap.isEmpty()) {
            FlowRuleComparator comparator = new FlowRuleComparator();
            for (List rules : newRuleMap.values()) {
                Collections.sort(rules, comparator);
            }
        }
        return newRuleMap;
    }

    private static TrafficShapingController generateRater(FlowRule rule) {
        if (rule.getGrade() == 1) {
            switch (rule.getControlBehavior()) {
                case 1: {
                    return new WarmUpController(rule.getCount(), rule.getWarmUpPeriodSec(), ColdFactorProperty.coldFactor);
                }
                case 2: {
                    return new RateLimiterController(rule.getMaxQueueingTimeMs(), rule.getCount());
                }
                case 3: {
                    return new WarmUpRateLimiterController(rule.getCount(), rule.getWarmUpPeriodSec(), rule.getMaxQueueingTimeMs(), ColdFactorProperty.coldFactor);
                }
            }
        }
        return new DefaultController(rule.getCount(), rule.getGrade());
    }

    public static boolean validClusterRuleId(Long id) {
        return id != null && id > 0L;
    }

    public static boolean isValidRule(FlowRule rule) {
        boolean baseValid;
        boolean bl = baseValid = rule != null && !StringUtil.isBlank(rule.getResource()) && rule.getCount() >= 0.0 && rule.getGrade() >= 0 && rule.getStrategy() >= 0 && rule.getControlBehavior() >= 0;
        if (!baseValid) {
            return false;
        }
        return FlowRuleUtil.checkClusterField(rule) && FlowRuleUtil.checkStrategyField(rule) && FlowRuleUtil.checkControlBehaviorField(rule);
    }

    private static boolean checkClusterField(FlowRule rule) {
        if (!rule.isClusterMode()) {
            return true;
        }
        ClusterFlowConfig clusterConfig = rule.getClusterConfig();
        if (clusterConfig == null) {
            return false;
        }
        if (!FlowRuleUtil.validClusterRuleId(clusterConfig.getFlowId())) {
            return false;
        }
        switch (rule.getStrategy()) {
            case 0: {
                return true;
            }
        }
        return false;
    }

    private static boolean checkStrategyField(FlowRule rule) {
        if (rule.getStrategy() == 1 || rule.getStrategy() == 2) {
            return StringUtil.isNotBlank(rule.getRefResource());
        }
        return true;
    }

    private static boolean checkControlBehaviorField(FlowRule rule) {
        switch (rule.getControlBehavior()) {
            case 1: {
                return rule.getWarmUpPeriodSec() > 0;
            }
            case 2: {
                return rule.getMaxQueueingTimeMs() > 0;
            }
            case 3: {
                return rule.getWarmUpPeriodSec() > 0 && rule.getMaxQueueingTimeMs() > 0;
            }
        }
        return true;
    }

    private FlowRuleUtil() {
    }
}

