/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.slots.statistic.metric;

import com.alibaba.csp.sentinel.node.metric.MetricNode;
import com.alibaba.csp.sentinel.slots.statistic.base.WindowWrap;
import com.alibaba.csp.sentinel.slots.statistic.data.MetricBucket;
import com.alibaba.csp.sentinel.slots.statistic.metric.Metric;
import com.alibaba.csp.sentinel.slots.statistic.metric.MetricsLeapArray;
import java.util.ArrayList;
import java.util.List;

public class ArrayMetric
implements Metric {
    private final MetricsLeapArray data;

    public ArrayMetric(int windowLengthInMs, int intervalInSec) {
        this.data = new MetricsLeapArray(windowLengthInMs, intervalInSec);
    }

    public ArrayMetric(MetricsLeapArray array) {
        this.data = array;
    }

    @Override
    public long success() {
        this.data.currentWindow();
        long success = 0L;
        List list = this.data.values();
        for (MetricBucket window : list) {
            success += window.success();
        }
        return success;
    }

    @Override
    public long maxSuccess() {
        this.data.currentWindow();
        long success = 0L;
        List list = this.data.values();
        for (MetricBucket window : list) {
            if (window.success() <= success) continue;
            success = window.success();
        }
        return Math.max(success, 1L);
    }

    @Override
    public long exception() {
        this.data.currentWindow();
        long exception = 0L;
        List list = this.data.values();
        for (MetricBucket window : list) {
            exception += window.exception();
        }
        return exception;
    }

    @Override
    public long block() {
        this.data.currentWindow();
        long block = 0L;
        List list = this.data.values();
        for (MetricBucket window : list) {
            block += window.block();
        }
        return block;
    }

    @Override
    public long pass() {
        this.data.currentWindow();
        long pass = 0L;
        List list = this.data.values();
        for (MetricBucket window : list) {
            pass += window.pass();
        }
        return pass;
    }

    @Override
    public long rt() {
        this.data.currentWindow();
        long rt = 0L;
        List list = this.data.values();
        for (MetricBucket window : list) {
            rt += window.rt();
        }
        return rt;
    }

    @Override
    public long minRt() {
        this.data.currentWindow();
        long rt = 4900L;
        List list = this.data.values();
        for (MetricBucket window : list) {
            if (window.minRt() >= rt) continue;
            rt = window.minRt();
        }
        return Math.max(1L, rt);
    }

    @Override
    public List<MetricNode> details() {
        ArrayList<MetricNode> details = new ArrayList<MetricNode>();
        this.data.currentWindow();
        for (WindowWrap window : this.data.list()) {
            if (window == null) continue;
            MetricNode node = new MetricNode();
            node.setBlockQps(((MetricBucket)window.value()).block());
            node.setExceptionQps(((MetricBucket)window.value()).exception());
            node.setPassQps(((MetricBucket)window.value()).pass());
            long passQps = ((MetricBucket)window.value()).success();
            node.setSuccessQps(passQps);
            if (passQps != 0L) {
                node.setRt(((MetricBucket)window.value()).rt() / passQps);
            } else {
                node.setRt(((MetricBucket)window.value()).rt());
            }
            node.setTimestamp(window.windowStart());
            details.add(node);
        }
        return details;
    }

    @Override
    public MetricBucket[] windows() {
        this.data.currentWindow();
        return this.data.values().toArray(new MetricBucket[this.data.values().size()]);
    }

    @Override
    public void addException() {
        WindowWrap wrap = this.data.currentWindow();
        ((MetricBucket)wrap.value()).addException();
    }

    @Override
    public void addBlock() {
        WindowWrap wrap = this.data.currentWindow();
        ((MetricBucket)wrap.value()).addBlock();
    }

    @Override
    public void addSuccess() {
        WindowWrap wrap = this.data.currentWindow();
        ((MetricBucket)wrap.value()).addSuccess();
    }

    @Override
    public void addPass() {
        WindowWrap wrap = this.data.currentWindow();
        ((MetricBucket)wrap.value()).addPass();
    }

    @Override
    public void addRT(long rt) {
        WindowWrap wrap = this.data.currentWindow();
        ((MetricBucket)wrap.value()).addRT(rt);
    }

    @Override
    public void debugQps() {
        this.data.currentWindow();
        StringBuilder sb = new StringBuilder();
        sb.append(Thread.currentThread().getId()).append("_");
        for (WindowWrap windowWrap : this.data.list()) {
            sb.append(windowWrap.windowStart()).append(":").append(((MetricBucket)windowWrap.value()).pass()).append(":").append(((MetricBucket)windowWrap.value()).block());
            sb.append(",");
        }
        System.out.println(sb);
    }

    @Override
    public long previousWindowBlock() {
        WindowWrap wrap = this.data.currentWindow();
        wrap = this.data.getPreviousWindow();
        if (wrap == null) {
            return 0L;
        }
        return ((MetricBucket)wrap.value()).block();
    }

    @Override
    public long previousWindowPass() {
        WindowWrap wrap = this.data.currentWindow();
        wrap = this.data.getPreviousWindow();
        if (wrap == null) {
            return 0L;
        }
        return ((MetricBucket)wrap.value()).pass();
    }
}

