/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel;

import com.alibaba.csp.sentinel.Entry;
import com.alibaba.csp.sentinel.context.Context;
import com.alibaba.csp.sentinel.context.ContextUtil;
import com.alibaba.csp.sentinel.node.ClusterNode;
import com.alibaba.csp.sentinel.node.DefaultNode;
import com.alibaba.csp.sentinel.slots.block.BlockException;

public final class Tracer {
    public static void trace(Throwable e) {
        Tracer.trace(e, 1);
    }

    public static void trace(Throwable e, int count) {
        if (e == null || e instanceof BlockException) {
            return;
        }
        Context context = ContextUtil.getContext();
        if (context == null) {
            return;
        }
        DefaultNode curNode = (DefaultNode)context.getCurNode();
        Tracer.traceExceptionToNode(e, count, curNode);
    }

    public static void traceContext(Throwable e, int count, Context context) {
        if (e == null || e instanceof BlockException) {
            return;
        }
        if (context == null) {
            return;
        }
        DefaultNode curNode = (DefaultNode)context.getCurNode();
        Tracer.traceExceptionToNode(e, count, curNode);
    }

    public static void traceEntry(Throwable e, Entry entry) {
        Tracer.traceEntry(e, 1, entry);
    }

    public static void traceEntry(Throwable e, int count, Entry entry) {
        if (e == null || e instanceof BlockException) {
            return;
        }
        if (entry == null || entry.getCurNode() == null) {
            return;
        }
        DefaultNode curNode = (DefaultNode)entry.getCurNode();
        Tracer.traceExceptionToNode(e, count, curNode);
    }

    private static void traceExceptionToNode(Throwable t, int count, DefaultNode curNode) {
        if (curNode == null) {
            return;
        }
        ClusterNode clusterNode = curNode.getClusterNode();
        if (clusterNode == null) {
            return;
        }
        clusterNode.trace(t, count);
    }

    private Tracer() {
    }
}

