/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.node;

import com.alibaba.csp.sentinel.node.Node;
import com.alibaba.csp.sentinel.node.StatisticNode;
import com.alibaba.csp.sentinel.slots.block.BlockException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;

public class ClusterNode
extends StatisticNode {
    private Map<String, StatisticNode> originCountMap = new HashMap<String, StatisticNode>();
    private final ReentrantLock lock = new ReentrantLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Node getOrCreateOriginNode(String origin) {
        StatisticNode statisticNode = this.originCountMap.get(origin);
        if (statisticNode == null) {
            try {
                this.lock.lock();
                statisticNode = this.originCountMap.get(origin);
                if (statisticNode == null) {
                    statisticNode = new StatisticNode();
                    HashMap<String, StatisticNode> newMap = new HashMap<String, StatisticNode>(this.originCountMap.size() + 1);
                    newMap.putAll(this.originCountMap);
                    newMap.put(origin, statisticNode);
                    this.originCountMap = newMap;
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        return statisticNode;
    }

    public synchronized Map<String, StatisticNode> getOriginCountMap() {
        return this.originCountMap;
    }

    public void trace(Throwable throwable, int count) {
        if (count <= 0) {
            return;
        }
        if (!BlockException.isBlockException(throwable)) {
            this.increaseExceptionQps(count);
        }
    }
}

