/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.log;

import com.alibaba.csp.sentinel.log.ConsoleHandler;
import com.alibaba.csp.sentinel.log.CspFormatter;
import com.alibaba.csp.sentinel.log.DateFileLogHandler;
import com.alibaba.csp.sentinel.log.LoggerUtils;
import com.alibaba.csp.sentinel.util.PidUtil;
import com.alibaba.csp.sentinel.util.StringUtil;
import java.io.File;
import java.io.IOException;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LogBase {
    public static final String LOG_CHARSET = "utf-8";
    public static final String LOG_OUTPUT_TYPE_FILE = "file";
    public static final String LOG_OUTPUT_TYPE_CONSOLE = "console";
    private static final String DIR_NAME = "logs" + File.separator + "csp";
    private static final String USER_HOME = "user.home";
    public static final String LOG_OUTPUT_TYPE = "csp.sentinel.log.output.type";
    public static final String LOG_DIR = "csp.sentinel.log.dir";
    public static final String LOG_NAME_USE_PID = "csp.sentinel.log.use.pid";
    private static String logOutputType;
    private static String logBaseDir;
    private static boolean logNameUsePid;

    private static void init() {
        File dir;
        logOutputType = System.getProperty(LOG_OUTPUT_TYPE);
        if (StringUtil.isBlank(logOutputType)) {
            logOutputType = LOG_OUTPUT_TYPE_FILE;
        } else if (!LOG_OUTPUT_TYPE_FILE.equalsIgnoreCase(logOutputType) && !LOG_OUTPUT_TYPE_CONSOLE.equalsIgnoreCase(logOutputType)) {
            logOutputType = LOG_OUTPUT_TYPE_FILE;
        }
        String logDir = System.getProperty(LOG_DIR);
        if (logDir == null || logDir.isEmpty()) {
            logDir = System.getProperty(USER_HOME);
            logDir = LogBase.addSeparator(logDir) + DIR_NAME + File.separator;
        }
        if (!(dir = new File(logDir = LogBase.addSeparator(logDir))).exists() && !dir.mkdirs()) {
            System.err.println("ERROR: create log base dir error: " + logDir);
        }
        logBaseDir = logDir;
        System.out.println("INFO: log base dir is: " + logBaseDir);
        String usePid = System.getProperty(LOG_NAME_USE_PID, "");
        logNameUsePid = "true".equalsIgnoreCase(usePid);
        System.out.println("INFO: log name use pid is: " + logNameUsePid);
    }

    public static boolean isLogNameUsePid() {
        return logNameUsePid;
    }

    private static String addSeparator(String logDir) {
        if (!logDir.endsWith(File.separator)) {
            logDir = logDir + File.separator;
        }
        return logDir;
    }

    protected static void log(Logger logger, Handler handler, Level level, String detail, Object ... params) {
        if (detail == null) {
            return;
        }
        LoggerUtils.disableOtherHandlers(logger, handler);
        if (params.length == 0) {
            logger.log(level, detail);
        } else {
            logger.log(level, detail, params);
        }
    }

    protected static void log(Logger logger, Handler handler, Level level, String detail, Throwable throwable) {
        if (detail == null) {
            return;
        }
        LoggerUtils.disableOtherHandlers(logger, handler);
        logger.log(level, detail, throwable);
    }

    public static String getLogBaseDir() {
        return logBaseDir;
    }

    protected static Handler makeLogger(String logName, Logger heliumRecordLog) {
        CspFormatter formatter = new CspFormatter();
        Handler handler = null;
        switch (logOutputType) {
            case "file": {
                String fileName = LogBase.getLogBaseDir() + logName;
                if (LogBase.isLogNameUsePid()) {
                    fileName = fileName + ".pid" + PidUtil.getPid();
                }
                try {
                    handler = new DateFileLogHandler(fileName + ".%d", 0xC800000, 4, true);
                    handler.setFormatter(formatter);
                    handler.setEncoding(LOG_CHARSET);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                break;
            }
            case "console": {
                try {
                    handler = new ConsoleHandler();
                    handler.setFormatter(formatter);
                    handler.setEncoding(LOG_CHARSET);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                break;
            }
        }
        if (handler != null) {
            LoggerUtils.disableOtherHandlers(heliumRecordLog, handler);
        }
        heliumRecordLog.setLevel(Level.ALL);
        return handler;
    }

    static {
        logNameUsePid = false;
        try {
            LogBase.init();
        }
        catch (Throwable t) {
            System.err.println("[LogBase] FATAL ERROR when initializing log class");
            t.printStackTrace();
        }
    }
}

