/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.slots.system;

import com.alibaba.csp.sentinel.Constants;
import com.alibaba.csp.sentinel.log.RecordLog;
import com.alibaba.csp.sentinel.slots.system.SystemRuleManager;
import com.sun.management.OperatingSystemMXBean;
import java.lang.management.ManagementFactory;

public class SystemStatusListener
implements Runnable {
    volatile double currentLoad = -1.0;
    volatile double currentCpuUsage = -1.0;
    volatile String reason = "";

    public double getSystemAverageLoad() {
        return this.currentLoad;
    }

    public double getCpuUsage() {
        return this.currentCpuUsage;
    }

    @Override
    public void run() {
        try {
            OperatingSystemMXBean osBean = ManagementFactory.getPlatformMXBean(OperatingSystemMXBean.class);
            this.currentLoad = osBean.getSystemLoadAverage();
            this.currentCpuUsage = osBean.getSystemCpuLoad();
            StringBuilder sb = new StringBuilder();
            if (this.currentLoad > SystemRuleManager.getHighestSystemLoad()) {
                sb.append("load:").append(this.currentLoad).append(";");
                sb.append("cpu:").append(this.currentCpuUsage).append(";");
                sb.append("qps:").append(Constants.ENTRY_NODE.passQps()).append(";");
                sb.append("rt:").append(Constants.ENTRY_NODE.avgRt()).append(";");
                sb.append("thread:").append(Constants.ENTRY_NODE.curThreadNum()).append(";");
                sb.append("success:").append(Constants.ENTRY_NODE.successQps()).append(";");
                sb.append("minRt:").append(Constants.ENTRY_NODE.minRt()).append(";");
                sb.append("maxSuccess:").append(Constants.ENTRY_NODE.maxSuccessQps()).append(";");
                RecordLog.info(sb.toString(), new Object[0]);
            }
        }
        catch (Throwable e) {
            RecordLog.info("could not get system error ", e);
        }
    }
}

