/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.log.jul;

import com.alibaba.csp.sentinel.concurrent.NamedThreadFactory;
import java.io.File;
import java.io.IOException;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.Date;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.LogRecord;

class DateFileLogHandler
extends Handler {
    private final DateTimeFormatter dateFormat = DateTimeFormatter.ofPattern("yyyy-MM-dd").withZone(ZoneId.systemDefault());
    private static final ThreadPoolExecutor executor = new ThreadPoolExecutor(1, 5, 1L, TimeUnit.HOURS, new ArrayBlockingQueue<Runnable>(1024), new NamedThreadFactory("sentinel-datafile-log-executor", true), new ThreadPoolExecutor.DiscardOldestPolicy());
    private volatile FileHandler handler;
    private final String pattern;
    private final int limit;
    private final int count;
    private final boolean append;
    private volatile boolean initialized = false;
    private volatile long startDate = System.currentTimeMillis();
    private volatile long endDate;
    private final Object monitor = new Object();

    DateFileLogHandler(String pattern, int limit, int count, boolean append) throws SecurityException {
        this.pattern = pattern;
        this.limit = limit;
        this.count = count;
        this.append = append;
        this.rotateDate();
        this.initialized = true;
    }

    @Override
    public void close() throws SecurityException {
        this.handler.close();
    }

    @Override
    public void flush() {
        this.handler.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void publish(LogRecord record) {
        if (this.shouldRotate(record)) {
            Object object = this.monitor;
            synchronized (object) {
                if (this.shouldRotate(record)) {
                    this.rotateDate();
                }
            }
        }
        if (System.currentTimeMillis() - this.startDate > 90000000L) {
            String msg = record.getMessage();
            record.setMessage("missed file rolling at: " + new Date(this.endDate) + "\n" + msg);
        }
        executor.execute(new LogTask(record, this.handler));
    }

    private boolean shouldRotate(LogRecord record) {
        return this.endDate <= record.getMillis() || !this.logFileExits();
    }

    @Override
    public void setFormatter(Formatter newFormatter) {
        super.setFormatter(newFormatter);
        if (this.handler != null) {
            this.handler.setFormatter(newFormatter);
        }
    }

    private boolean logFileExits() {
        try {
            String fileName = this.pattern.replace("%d", this.dateFormat.format(Instant.now()));
            if (this.count != 1) {
                fileName = fileName + ".0";
            }
            File logFile = new File(fileName);
            return logFile.exists();
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    private void rotateDate() {
        this.startDate = System.currentTimeMillis();
        if (this.handler != null) {
            this.handler.close();
        }
        String newPattern = this.pattern.replace("%d", this.dateFormat.format(Instant.now()));
        Calendar next = Calendar.getInstance();
        next.set(11, 0);
        next.set(12, 0);
        next.set(13, 0);
        next.set(14, 0);
        next.add(5, 1);
        this.endDate = next.getTimeInMillis();
        try {
            this.handler = new FileHandler(newPattern, this.limit, this.count, this.append);
            if (this.initialized) {
                this.handler.setEncoding(this.getEncoding());
                this.handler.setErrorManager(this.getErrorManager());
                this.handler.setFilter(this.getFilter());
                this.handler.setFormatter(this.getFormatter());
                this.handler.setLevel(this.getLevel());
            }
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    static {
        executor.allowCoreThreadTimeOut(true);
    }

    static class LogTask
    implements Runnable {
        private final LogRecord record;
        private final FileHandler handler;

        public LogTask(LogRecord record, FileHandler handler) {
            this.record = record;
            this.handler = handler;
        }

        @Override
        public void run() {
            this.handler.publish(this.record);
        }

        public LogRecord getRecord() {
            return this.record;
        }
    }

    static class LogRejectedExecutionHandler
    implements RejectedExecutionHandler {
        private final long recordPeriod;
        private Long lastRecordTime;

        public LogRejectedExecutionHandler() {
            String DEFAULT_REJECTED_RECORD_PERIOD = "60000";
            String REJECTED_RECORD_PERIOD_KEY = "sentinel.rejected.record.period";
            this.lastRecordTime = null;
            this.recordPeriod = Long.parseLong(System.getProperty(REJECTED_RECORD_PERIOD_KEY, DEFAULT_REJECTED_RECORD_PERIOD));
        }

        @Override
        public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
            long currentTimestamp = System.currentTimeMillis();
            if (this.lastRecordTime == null || currentTimestamp - this.lastRecordTime > this.recordPeriod) {
                System.err.println("Failed to log sentinel record with datafile, rejected");
                this.lastRecordTime = currentTimestamp;
            }
        }
    }
}

