/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.datasource.redis.config;

import com.alibaba.csp.sentinel.datasource.redis.config.RedisHostAndPort;
import com.alibaba.csp.sentinel.util.AssertUtil;
import com.alibaba.csp.sentinel.util.StringUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class RedisConnectionConfig {
    public static final int DEFAULT_SENTINEL_PORT = 26379;
    public static final int DEFAULT_CLUSTER_PORT = 6379;
    public static final int DEFAULT_REDIS_PORT = 6379;
    public static final long DEFAULT_TIMEOUT_MILLISECONDS = 60000L;
    private String host;
    private String redisSentinelMasterId;
    private int port;
    private boolean sslEnable;
    private String trustedCertificatesPath;
    private String trustedCertificatesJksPassword;
    private String keyCertChainFilePath;
    private String keyFilePath;
    private String keyFilePassword;
    private int database;
    private String clientName;
    private char[] password;
    private long timeout = 60000L;
    private final List<RedisConnectionConfig> redisSentinels = new ArrayList<RedisConnectionConfig>();
    private final List<RedisConnectionConfig> redisClusters = new ArrayList<RedisConnectionConfig>();

    public RedisConnectionConfig() {
    }

    public RedisConnectionConfig(String host, int port, long timeout) {
        AssertUtil.notEmpty((String)host, (String)"Host must not be empty");
        AssertUtil.notNull((Object)timeout, (String)"Timeout duration must not be null");
        AssertUtil.isTrue((timeout >= 0L ? 1 : 0) != 0, (String)"Timeout duration must be greater or equal to zero");
        this.setHost(host);
        this.setPort(port);
        this.setTimeout(timeout);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getRedisSentinelMasterId() {
        return this.redisSentinelMasterId;
    }

    public void setRedisSentinelMasterId(String redisSentinelMasterId) {
        this.redisSentinelMasterId = redisSentinelMasterId;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public char[] getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        AssertUtil.notNull((Object)password, (String)"Password must not be null");
        this.password = password.toCharArray();
    }

    public void setPassword(char[] password) {
        AssertUtil.notNull((Object)password, (String)"Password must not be null");
        this.password = Arrays.copyOf(password, password.length);
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(Long timeout) {
        AssertUtil.notNull((Object)timeout, (String)"Timeout must not be null");
        AssertUtil.isTrue((timeout >= 0L ? 1 : 0) != 0, (String)"Timeout must be greater or equal 0");
        this.timeout = timeout;
    }

    public int getDatabase() {
        return this.database;
    }

    public void setDatabase(int database) {
        AssertUtil.isTrue((database >= 0 ? 1 : 0) != 0, (String)("Invalid database number: " + database));
        this.database = database;
    }

    public String getClientName() {
        return this.clientName;
    }

    public void setClientName(String clientName) {
        this.clientName = clientName;
    }

    public List<RedisConnectionConfig> getRedisSentinels() {
        return this.redisSentinels;
    }

    public List<RedisConnectionConfig> getRedisClusters() {
        return this.redisClusters;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append(" [");
        if (this.host != null) {
            sb.append("host='").append(this.host).append('\'');
            sb.append(", port=").append(this.port);
        }
        if (this.redisSentinelMasterId != null) {
            sb.append("redisSentinels=").append(this.getRedisSentinels());
            sb.append(", redisSentinelMasterId=").append(this.redisSentinelMasterId);
        }
        if (this.redisClusters.size() > 0) {
            sb.append("redisClusters=").append(this.getRedisClusters());
        }
        sb.append(']');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RedisConnectionConfig)) {
            return false;
        }
        RedisConnectionConfig redisURI = (RedisConnectionConfig)o;
        if (this.port != redisURI.port) {
            return false;
        }
        if (this.database != redisURI.database) {
            return false;
        }
        if (this.host != null ? !this.host.equals(redisURI.host) : redisURI.host != null) {
            return false;
        }
        if (this.redisSentinelMasterId != null ? !this.redisSentinelMasterId.equals(redisURI.redisSentinelMasterId) : redisURI.redisSentinelMasterId != null) {
            return false;
        }
        if (this.redisClusters != null ? !this.redisClusters.equals(redisURI.redisClusters) : redisURI.redisClusters != null) {
            return false;
        }
        return !(this.redisSentinels == null ? redisURI.redisSentinels != null : !this.redisSentinels.equals(redisURI.redisSentinels));
    }

    public int hashCode() {
        int result = this.host != null ? this.host.hashCode() : 0;
        result = 31 * result + (this.redisSentinelMasterId != null ? this.redisSentinelMasterId.hashCode() : 0);
        result = 31 * result + this.port;
        result = 31 * result + this.database;
        result = 31 * result + (this.redisSentinels != null ? this.redisSentinels.hashCode() : 0);
        result = 31 * result + (this.redisClusters != null ? this.redisClusters.hashCode() : 0);
        return result;
    }

    private static boolean isValidPort(int port) {
        return port >= 0 && port <= 65535;
    }

    public String getTrustedCertificatesPath() {
        return this.trustedCertificatesPath;
    }

    public void setTrustedCertificatesPath(String trustedCertificatesPath) {
        this.trustedCertificatesPath = trustedCertificatesPath;
    }

    public String getTrustedCertificatesJksPassword() {
        return this.trustedCertificatesJksPassword;
    }

    public void setTrustedCertificatesJksPassword(String trustedCertificatesJksPassword) {
        this.trustedCertificatesJksPassword = trustedCertificatesJksPassword;
    }

    public String getKeyCertChainFilePath() {
        return this.keyCertChainFilePath;
    }

    public void setKeyCertChainFilePath(String keyCertChainFilePath) {
        this.keyCertChainFilePath = keyCertChainFilePath;
    }

    public String getKeyFilePath() {
        return this.keyFilePath;
    }

    public void setKeyFilePath(String keyFilePath) {
        this.keyFilePath = keyFilePath;
    }

    public String getKeyFilePassword() {
        return this.keyFilePassword;
    }

    public void setKeyFilePassword(String keyFilePassword) {
        this.keyFilePassword = keyFilePassword;
    }

    public void setSslEnable(boolean sslEnable) {
        this.sslEnable = sslEnable;
    }

    public boolean isSslEnable() {
        return this.sslEnable;
    }

    public static class Builder {
        private String host;
        private String redisSentinelMasterId;
        private int port;
        private int database;
        private String clientName;
        private char[] password;
        private boolean sslEnable;
        private String trustedCertificatesPath;
        private String trustedCertificatesJksPassword;
        private String keyCertChainFilePath;
        private String keyFilePath;
        private String keyFilePassword;
        private long timeout = 60000L;
        private final List<RedisHostAndPort> redisSentinels = new ArrayList<RedisHostAndPort>();
        private final List<RedisHostAndPort> redisClusters = new ArrayList<RedisHostAndPort>();

        private Builder() {
        }

        public static Builder redis(String host) {
            return Builder.redis(host, 6379);
        }

        public static Builder redis(String host, int port) {
            AssertUtil.notEmpty((String)host, (String)"Host must not be empty");
            AssertUtil.isTrue((boolean)RedisConnectionConfig.isValidPort(port), (String)String.format("Port out of range: %s", port));
            Builder builder = RedisConnectionConfig.builder();
            return builder.withHost(host).withPort(port);
        }

        public static Builder redisSentinel(String host) {
            AssertUtil.notEmpty((String)host, (String)"Host must not be empty");
            Builder builder = RedisConnectionConfig.builder();
            return builder.withRedisSentinel(host);
        }

        public static Builder redisSentinel(String host, int port) {
            AssertUtil.notEmpty((String)host, (String)"Host must not be empty");
            AssertUtil.isTrue((boolean)RedisConnectionConfig.isValidPort(port), (String)String.format("Port out of range: %s", port));
            Builder builder = RedisConnectionConfig.builder();
            return builder.withRedisSentinel(host, port);
        }

        public static Builder redisSentinel(String host, String masterId) {
            return Builder.redisSentinel(host, 26379, masterId);
        }

        public static Builder redisSentinel(String host, int port, String masterId) {
            AssertUtil.notEmpty((String)host, (String)"Host must not be empty");
            AssertUtil.isTrue((boolean)RedisConnectionConfig.isValidPort(port), (String)String.format("Port out of range: %s", port));
            Builder builder = RedisConnectionConfig.builder();
            return builder.withSentinelMasterId(masterId).withRedisSentinel(host, port);
        }

        public Builder withRedisSentinel(String host) {
            return this.withRedisSentinel(host, 26379);
        }

        public Builder withRedisSentinel(String host, int port) {
            AssertUtil.assertState((this.host == null ? 1 : 0) != 0, (String)"Cannot use with Redis mode.");
            AssertUtil.notEmpty((String)host, (String)"Host must not be empty");
            AssertUtil.isTrue((boolean)RedisConnectionConfig.isValidPort(port), (String)String.format("Port out of range: %s", port));
            this.redisSentinels.add(RedisHostAndPort.of(host, port));
            return this;
        }

        public static Builder redisCluster(String host) {
            AssertUtil.notEmpty((String)host, (String)"Host must not be empty");
            Builder builder = RedisConnectionConfig.builder();
            return builder.withRedisCluster(host);
        }

        public static Builder redisCluster(String host, int port) {
            AssertUtil.notEmpty((String)host, (String)"Host must not be empty");
            AssertUtil.isTrue((boolean)RedisConnectionConfig.isValidPort(port), (String)String.format("Port out of range: %s", port));
            Builder builder = RedisConnectionConfig.builder();
            return builder.withRedisCluster(host, port);
        }

        public Builder withRedisCluster(String host) {
            return this.withRedisCluster(host, 6379);
        }

        public Builder withRedisCluster(String host, int port) {
            AssertUtil.assertState((this.host == null ? 1 : 0) != 0, (String)"Cannot use with Redis mode.");
            AssertUtil.notEmpty((String)host, (String)"Host must not be empty");
            AssertUtil.isTrue((boolean)RedisConnectionConfig.isValidPort(port), (String)String.format("Port out of range: %s", port));
            this.redisClusters.add(RedisHostAndPort.of(host, port));
            return this;
        }

        public Builder withHost(String host) {
            AssertUtil.assertState((boolean)this.redisSentinels.isEmpty(), (String)"Sentinels are non-empty. Cannot use in Sentinel mode.");
            AssertUtil.notEmpty((String)host, (String)"Host must not be empty");
            this.host = host;
            return this;
        }

        public Builder withPort(int port) {
            AssertUtil.assertState((this.host != null ? 1 : 0) != 0, (String)"Host is null. Cannot use in Sentinel mode.");
            AssertUtil.isTrue((boolean)RedisConnectionConfig.isValidPort(port), (String)String.format("Port out of range: %s", port));
            this.port = port;
            return this;
        }

        public Builder withDatabase(int database) {
            AssertUtil.isTrue((database >= 0 ? 1 : 0) != 0, (String)("Invalid database number: " + database));
            this.database = database;
            return this;
        }

        public Builder withClientName(String clientName) {
            AssertUtil.notNull((Object)clientName, (String)"Client name must not be null");
            this.clientName = clientName;
            return this;
        }

        public Builder withPassword(String password) {
            AssertUtil.notNull((Object)password, (String)"Password must not be null");
            return this.withPassword(password.toCharArray());
        }

        public Builder withPassword(char[] password) {
            AssertUtil.notNull((Object)password, (String)"Password must not be null");
            this.password = Arrays.copyOf(password, password.length);
            return this;
        }

        public Builder withTimeout(long timeout) {
            AssertUtil.notNull((Object)timeout, (String)"Timeout must not be null");
            AssertUtil.notNull((Object)(timeout >= 0L ? 1 : 0), (String)"Timeout must be greater or equal 0");
            this.timeout = timeout;
            return this;
        }

        public Builder withSentinelMasterId(String sentinelMasterId) {
            AssertUtil.notEmpty((String)sentinelMasterId, (String)"Sentinel master id must not empty");
            this.redisSentinelMasterId = sentinelMasterId;
            return this;
        }

        public Builder withSslEnable(boolean sslEnable) {
            this.sslEnable = sslEnable;
            return this;
        }

        public Builder withTrustedCertificatesPath(String trustedCertificatesPath) {
            AssertUtil.notEmpty((String)trustedCertificatesPath, (String)"trusted certificates path must not empty");
            this.trustedCertificatesPath = trustedCertificatesPath;
            return this;
        }

        public Builder withTrustedCertificatesJksPassword(String trustedCertificatesJksPassword) {
            this.trustedCertificatesJksPassword = trustedCertificatesJksPassword;
            return this;
        }

        public Builder withKeyCertChainFilePath(String keyCertChainFilePath) {
            this.keyCertChainFilePath = keyCertChainFilePath;
            return this;
        }

        public Builder withKeyFilePath(String keyFilePath) {
            this.keyFilePath = keyFilePath;
            return this;
        }

        public Builder withKeyFilePassword(String keyFilePassword) {
            this.keyFilePassword = keyFilePassword;
            return this;
        }

        public RedisConnectionConfig build() {
            if (this.redisSentinels.isEmpty() && this.redisClusters.isEmpty() && StringUtil.isEmpty((String)this.host)) {
                throw new IllegalStateException("Cannot build a RedisConnectionConfig. One of the following must be provided Host, Socket, Cluster or Sentinel");
            }
            RedisConnectionConfig redisConnectionConfig = new RedisConnectionConfig();
            redisConnectionConfig.setHost(this.host);
            redisConnectionConfig.setPort(this.port);
            if (this.sslEnable) {
                redisConnectionConfig.setSslEnable(true);
                redisConnectionConfig.setTrustedCertificatesPath(this.trustedCertificatesPath);
                redisConnectionConfig.setTrustedCertificatesJksPassword(this.trustedCertificatesJksPassword);
                redisConnectionConfig.setKeyCertChainFilePath(this.keyCertChainFilePath);
                redisConnectionConfig.setKeyFilePath(this.keyFilePath);
                redisConnectionConfig.setKeyFilePassword(this.keyFilePassword);
            }
            if (this.password != null) {
                redisConnectionConfig.setPassword(this.password);
            }
            redisConnectionConfig.setDatabase(this.database);
            redisConnectionConfig.setClientName(this.clientName);
            redisConnectionConfig.setRedisSentinelMasterId(this.redisSentinelMasterId);
            for (RedisHostAndPort sentinel : this.redisSentinels) {
                redisConnectionConfig.getRedisSentinels().add(new RedisConnectionConfig(sentinel.getHost(), sentinel.getPort(), this.timeout));
            }
            for (RedisHostAndPort sentinel : this.redisClusters) {
                redisConnectionConfig.getRedisClusters().add(new RedisConnectionConfig(sentinel.getHost(), sentinel.getPort(), this.timeout));
            }
            redisConnectionConfig.setTimeout(this.timeout);
            return redisConnectionConfig;
        }
    }
}

