/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.datasource.zookeeper;

import com.alibaba.csp.sentinel.concurrent.NamedThreadFactory;
import com.alibaba.csp.sentinel.datasource.AbstractDataSource;
import com.alibaba.csp.sentinel.datasource.Converter;
import com.alibaba.csp.sentinel.log.RecordLog;
import com.alibaba.csp.sentinel.util.StringUtil;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.AuthInfo;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.framework.recipes.cache.ChildData;
import org.apache.curator.framework.recipes.cache.NodeCache;
import org.apache.curator.framework.recipes.cache.NodeCacheListener;
import org.apache.curator.retry.ExponentialBackoffRetry;

public class ZookeeperDataSource<T>
extends AbstractDataSource<String, T> {
    private static final int RETRY_TIMES = 3;
    private static final int SLEEP_TIME = 1000;
    private final ExecutorService pool = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(1), (ThreadFactory)new NamedThreadFactory("sentinel-zookeeper-ds-update"), new ThreadPoolExecutor.DiscardOldestPolicy());
    private NodeCacheListener listener;
    private final String path;
    private CuratorFramework zkClient = null;
    private NodeCache nodeCache = null;

    public ZookeeperDataSource(String serverAddr, String path, Converter<String, T> parser) {
        super(parser);
        if (StringUtil.isBlank((String)serverAddr) || StringUtil.isBlank((String)path)) {
            throw new IllegalArgumentException(String.format("Bad argument: serverAddr=[%s], path=[%s]", serverAddr, path));
        }
        this.path = path;
        this.init(serverAddr, null);
    }

    public ZookeeperDataSource(String serverAddr, String groupId, String dataId, Converter<String, T> parser) {
        super(parser);
        if (StringUtil.isBlank((String)serverAddr) || StringUtil.isBlank((String)groupId) || StringUtil.isBlank((String)dataId)) {
            throw new IllegalArgumentException(String.format("Bad argument: serverAddr=[%s], groupId=[%s], dataId=[%s]", serverAddr, groupId, dataId));
        }
        this.path = this.getPath(groupId, dataId);
        this.init(serverAddr, null);
    }

    public ZookeeperDataSource(String serverAddr, List<AuthInfo> authInfos, String groupId, String dataId, Converter<String, T> parser) {
        super(parser);
        if (StringUtil.isBlank((String)serverAddr) || StringUtil.isBlank((String)groupId) || StringUtil.isBlank((String)dataId)) {
            throw new IllegalArgumentException(String.format("Bad argument: serverAddr=[%s], authInfos=[%s], groupId=[%s], dataId=[%s]", serverAddr, authInfos, groupId, dataId));
        }
        this.path = this.getPath(groupId, dataId);
        this.init(serverAddr, authInfos);
    }

    private void init(String serverAddr, List<AuthInfo> authInfos) {
        this.initZookeeperListener(serverAddr, authInfos);
        this.loadInitialConfig();
    }

    private void loadInitialConfig() {
        try {
            Object newValue = this.loadConfig();
            if (newValue == null) {
                RecordLog.warn((String)"[ZookeeperDataSource] WARN: initial config is null, you may have to check your data source", (Object[])new Object[0]);
            }
            this.getProperty().updateValue(newValue);
        }
        catch (Exception ex) {
            RecordLog.warn((String)"[ZookeeperDataSource] Error when loading initial config", (Throwable)ex);
        }
    }

    private void initZookeeperListener(final String serverAddr, List<AuthInfo> authInfos) {
        try {
            this.listener = new NodeCacheListener(){

                public void nodeChanged() {
                    try {
                        Object newValue = ZookeeperDataSource.this.loadConfig();
                        RecordLog.info((String)String.format("[ZookeeperDataSource] New property value received for (%s, %s): %s", serverAddr, ZookeeperDataSource.this.path, newValue), (Object[])new Object[0]);
                        ZookeeperDataSource.this.getProperty().updateValue(newValue);
                    }
                    catch (Exception ex) {
                        RecordLog.warn((String)"[ZookeeperDataSource] loadConfig exception", (Throwable)ex);
                    }
                }
            };
            this.zkClient = authInfos == null || authInfos.size() == 0 ? CuratorFrameworkFactory.newClient((String)serverAddr, (RetryPolicy)new ExponentialBackoffRetry(1000, 3)) : CuratorFrameworkFactory.builder().connectString(serverAddr).retryPolicy((RetryPolicy)new ExponentialBackoffRetry(1000, 3)).authorization(authInfos).build();
            this.zkClient.start();
            this.nodeCache = new NodeCache(this.zkClient, this.path);
            this.nodeCache.getListenable().addListener((Object)this.listener, (Executor)this.pool);
            this.nodeCache.start();
        }
        catch (Exception e) {
            RecordLog.warn((String)"[ZookeeperDataSource] Error occurred when initializing Zookeeper data source", (Throwable)e);
            e.printStackTrace();
        }
    }

    public String readSource() throws Exception {
        if (this.zkClient == null) {
            throw new IllegalStateException("Zookeeper has not been initialized or error occurred");
        }
        String configInfo = null;
        ChildData childData = this.nodeCache.getCurrentData();
        if (null != childData && childData.getData() != null) {
            configInfo = new String(childData.getData());
        }
        return configInfo;
    }

    public void close() throws Exception {
        if (this.nodeCache != null) {
            this.nodeCache.getListenable().removeListener((Object)this.listener);
            this.nodeCache.close();
        }
        if (this.zkClient != null) {
            this.zkClient.close();
        }
        this.pool.shutdown();
    }

    private String getPath(String groupId, String dataId) {
        return String.format("/%s/%s", groupId, dataId);
    }
}

