/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.slots.block.flow.param;

import com.alibaba.csp.sentinel.log.RecordLog;
import com.alibaba.csp.sentinel.node.IntervalProperty;
import com.alibaba.csp.sentinel.node.SampleCountProperty;
import com.alibaba.csp.sentinel.slots.block.flow.param.RollingParamEvent;
import com.alibaba.csp.sentinel.slots.statistic.cache.CacheMap;
import com.alibaba.csp.sentinel.slots.statistic.cache.ConcurrentLinkedHashMapWrapper;
import com.alibaba.csp.sentinel.slots.statistic.metric.HotParameterLeapArray;
import com.alibaba.csp.sentinel.util.AssertUtil;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;

public class ParameterMetric {
    private final int sampleCount;
    private final int intervalMs;
    private Map<Integer, HotParameterLeapArray> rollingParameters = new ConcurrentHashMap<Integer, HotParameterLeapArray>();
    private Map<Integer, CacheMap<Object, AtomicInteger>> threadCountMap = new ConcurrentHashMap<Integer, CacheMap<Object, AtomicInteger>>();
    private static final long THREAD_COUNT_MAX_CAPACITY = 4000L;

    public ParameterMetric() {
        this(SampleCountProperty.SAMPLE_COUNT, IntervalProperty.INTERVAL);
    }

    public ParameterMetric(int sampleCount, int intervalInMs) {
        AssertUtil.isTrue((sampleCount > 0 ? 1 : 0) != 0, (String)"sampleCount should be positive");
        AssertUtil.isTrue((intervalInMs > 0 ? 1 : 0) != 0, (String)"window interval should be positive");
        AssertUtil.isTrue((intervalInMs % sampleCount == 0 ? 1 : 0) != 0, (String)"time span needs to be evenly divided");
        this.sampleCount = sampleCount;
        this.intervalMs = intervalInMs;
    }

    public Map<Integer, HotParameterLeapArray> getRollingParameters() {
        return this.rollingParameters;
    }

    public Map<Integer, CacheMap<Object, AtomicInteger>> getThreadCountMap() {
        return this.threadCountMap;
    }

    public synchronized void clear() {
        this.rollingParameters.clear();
        this.threadCountMap.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initializeForIndex(int index) {
        if (!this.rollingParameters.containsKey(index)) {
            ParameterMetric parameterMetric = this;
            synchronized (parameterMetric) {
                if (this.rollingParameters.get(index) == null) {
                    this.rollingParameters.put(index, new HotParameterLeapArray(this.sampleCount, this.intervalMs));
                }
                if (this.threadCountMap.get(index) == null) {
                    this.threadCountMap.put(index, new ConcurrentLinkedHashMapWrapper(4000L));
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    public void decreaseThreadCount(Object ... args) {
        if (args == null) {
            return;
        }
        try {
            int index = 0;
            while (index < args.length) {
                Object arg;
                CacheMap<Object, AtomicInteger> threadCount = this.threadCountMap.get(index);
                if (threadCount != null && (arg = args[index]) != null) {
                    if (Collection.class.isAssignableFrom(arg.getClass())) {
                        for (Object value : (Collection)arg) {
                            int currentValue;
                            AtomicInteger oldValue = threadCount.putIfAbsent(value, new AtomicInteger());
                            if (oldValue == null || (currentValue = oldValue.decrementAndGet()) > 0) continue;
                            threadCount.remove(value);
                        }
                    } else if (arg.getClass().isArray()) {
                        int length = Array.getLength(arg);
                        for (int i = 0; i < length; ++i) {
                            int currentValue;
                            Object value = Array.get(arg, i);
                            AtomicInteger oldValue = threadCount.putIfAbsent(value, new AtomicInteger());
                            if (oldValue == null || (currentValue = oldValue.decrementAndGet()) > 0) continue;
                            threadCount.remove(value);
                        }
                    } else {
                        int currentValue;
                        AtomicInteger oldValue = threadCount.putIfAbsent(arg, new AtomicInteger());
                        if (oldValue != null && (currentValue = oldValue.decrementAndGet()) <= 0) {
                            threadCount.remove(arg);
                        }
                    }
                }
                ++index;
            }
            return;
        }
        catch (Throwable e) {
            RecordLog.warn((String)"[ParameterMetric] Param exception", (Throwable)e);
        }
    }

    /*
     * Unable to fully structure code
     */
    public void addThreadCount(Object ... args) {
        if (args == null) {
            return;
        }
lbl3:
        // 4 sources

        try {
            for (index = 0; index < args.length; ++index) {
                block10: {
                    block9: {
                        threadCount = this.threadCountMap.get(index);
                        if (threadCount == null || (arg = args[index]) == null) continue;
                        if (!Collection.class.isAssignableFrom(arg.getClass())) break block9;
                        for (E value : (Collection)arg) {
                            oldValue = threadCount.putIfAbsent(value, new AtomicInteger());
                            if (oldValue != null) {
                                oldValue.incrementAndGet();
                                continue;
                            }
                            threadCount.put(value, new AtomicInteger(1));
                        }
                        ** GOTO lbl3
                    }
                    if (!arg.getClass().isArray()) break block10;
                    length = Array.getLength(arg);
                    for (i = 0; i < length; ++i) {
                        value = Array.get(arg, i);
                        oldValue = threadCount.putIfAbsent(value, new AtomicInteger());
                        if (oldValue != null) {
                            oldValue.incrementAndGet();
                            continue;
                        }
                        threadCount.put(value, new AtomicInteger(1));
                    }
                    ** GOTO lbl3
                }
                oldValue = threadCount.putIfAbsent(arg, new AtomicInteger());
                if (oldValue != null) {
                    oldValue.incrementAndGet();
                    continue;
                }
                threadCount.put(arg, new AtomicInteger(1));
            }
        }
        catch (Throwable e) {
            RecordLog.warn((String)"[ParameterMetric] Param exception", (Throwable)e);
        }
    }

    public void addPass(int count, Object ... args) {
        this.add(RollingParamEvent.REQUEST_PASSED, count, args);
    }

    public void addBlock(int count, Object ... args) {
        this.add(RollingParamEvent.REQUEST_BLOCKED, count, args);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    private void add(RollingParamEvent event, int count, Object ... args) {
        if (args == null) {
            return;
        }
        try {
            int index = 0;
            while (index < args.length) {
                Object arg;
                HotParameterLeapArray param = this.rollingParameters.get(index);
                if (param != null && (arg = args[index]) != null) {
                    if (Collection.class.isAssignableFrom(arg.getClass())) {
                        for (Object value : (Collection)arg) {
                            param.addValue(event, count, value);
                        }
                    } else if (arg.getClass().isArray()) {
                        int length = Array.getLength(arg);
                        for (int i = 0; i < length; ++i) {
                            Object value = Array.get(arg, i);
                            param.addValue(event, count, value);
                        }
                    } else {
                        param.addValue(event, count, arg);
                    }
                }
                ++index;
            }
            return;
        }
        catch (Throwable e) {
            RecordLog.warn((String)"[ParameterMetric] Param exception", (Throwable)e);
        }
    }

    public double getPassParamQps(int index, Object value) {
        try {
            HotParameterLeapArray parameter = this.rollingParameters.get(index);
            if (parameter == null || value == null) {
                return -1.0;
            }
            return parameter.getRollingAvg(RollingParamEvent.REQUEST_PASSED, value);
        }
        catch (Throwable e) {
            RecordLog.info((String)e.getMessage(), (Throwable)e);
            return -1.0;
        }
    }

    public long getBlockParamQps(int index, Object value) {
        try {
            HotParameterLeapArray parameter = this.rollingParameters.get(index);
            if (parameter == null || value == null) {
                return -1L;
            }
            return (long)this.rollingParameters.get(index).getRollingAvg(RollingParamEvent.REQUEST_BLOCKED, value);
        }
        catch (Throwable e) {
            RecordLog.info((String)e.getMessage(), (Throwable)e);
            return -1L;
        }
    }

    public Map<Object, Double> getTopPassParamCount(int index, int number) {
        try {
            HotParameterLeapArray parameter = this.rollingParameters.get(index);
            if (parameter == null) {
                return new HashMap<Object, Double>();
            }
            return parameter.getTopValues(RollingParamEvent.REQUEST_PASSED, number);
        }
        catch (Throwable e) {
            RecordLog.info((String)e.getMessage(), (Throwable)e);
            return new HashMap<Object, Double>();
        }
    }

    public long getThreadCount(int index, Object value) {
        if (this.threadCountMap.get(index) == null) {
            return 0L;
        }
        AtomicInteger count = this.threadCountMap.get(index).get(value);
        return count == null ? 0L : (long)count.get();
    }
}

