/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.adapter.gateway.zuul.filters;

import com.alibaba.csp.sentinel.adapter.gateway.zuul.filters.SentinelEntryUtils;
import com.alibaba.csp.sentinel.log.RecordLog;
import com.alibaba.csp.sentinel.slots.block.BlockException;
import com.netflix.zuul.ZuulFilter;
import com.netflix.zuul.context.RequestContext;
import com.netflix.zuul.exception.ZuulException;

public class SentinelZuulErrorFilter
extends ZuulFilter {
    private final int order;

    public SentinelZuulErrorFilter() {
        this(-1);
    }

    public SentinelZuulErrorFilter(int order) {
        this.order = order;
    }

    public String filterType() {
        return "error";
    }

    public boolean shouldFilter() {
        RequestContext ctx = RequestContext.getCurrentContext();
        return ctx.getThrowable() != null;
    }

    public int filterOrder() {
        return this.order;
    }

    public Object run() throws ZuulException {
        RequestContext ctx = RequestContext.getCurrentContext();
        Throwable throwable = ctx.getThrowable();
        if (throwable != null && !BlockException.isBlockException((Throwable)throwable)) {
            SentinelEntryUtils.tryTraceExceptionThenExitFromCurrentContext(throwable);
            RecordLog.info((String)"[SentinelZuulErrorFilter] Trace error cause", (Throwable)throwable.getCause());
        }
        return null;
    }
}

