/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dashscope.assistants;

import com.alibaba.dashscope.api.GeneralApi;
import com.alibaba.dashscope.assistants.Assistant;
import com.alibaba.dashscope.assistants.AssistantFile;
import com.alibaba.dashscope.assistants.AssistantFileParam;
import com.alibaba.dashscope.assistants.AssistantParam;
import com.alibaba.dashscope.base.HalfDuplexParamBase;
import com.alibaba.dashscope.common.DashScopeResult;
import com.alibaba.dashscope.common.DeletionStatus;
import com.alibaba.dashscope.common.FlattenResultBase;
import com.alibaba.dashscope.common.GeneralGetParam;
import com.alibaba.dashscope.common.GeneralListParam;
import com.alibaba.dashscope.common.ListResult;
import com.alibaba.dashscope.exception.ApiException;
import com.alibaba.dashscope.exception.InputRequiredException;
import com.alibaba.dashscope.exception.NoApiKeyException;
import com.alibaba.dashscope.protocol.ConnectionOptions;
import com.alibaba.dashscope.protocol.GeneralServiceOption;
import com.alibaba.dashscope.protocol.HttpMethod;
import com.alibaba.dashscope.protocol.Protocol;
import com.alibaba.dashscope.protocol.StreamingMode;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;

public final class Assistants {
    private final GeneralApi<HalfDuplexParamBase> api;
    private final GeneralServiceOption serviceOption = this.defaultServiceOption();

    private GeneralServiceOption defaultServiceOption() {
        return ((GeneralServiceOption.GeneralServiceOptionBuilder)((GeneralServiceOption.GeneralServiceOptionBuilder)((GeneralServiceOption.GeneralServiceOptionBuilder)((GeneralServiceOption.GeneralServiceOptionBuilder)GeneralServiceOption.builder().protocol(Protocol.HTTP)).httpMethod(HttpMethod.POST)).streamingMode(StreamingMode.OUT)).path("assistants")).build();
    }

    public Assistants() {
        this.api = new GeneralApi();
    }

    public Assistants(String baseUrl, ConnectionOptions connectionOptions) {
        this.serviceOption.setBaseHttpUrl(baseUrl);
        this.api = new GeneralApi(connectionOptions);
    }

    public Assistant create(AssistantParam param) throws ApiException, NoApiKeyException {
        this.serviceOption.setHttpMethod(HttpMethod.POST);
        this.serviceOption.setPath(String.format("assistants", new Object[0]));
        DashScopeResult result = this.api.call(param, this.serviceOption);
        return (Assistant)FlattenResultBase.fromDashScopeResult(result, Assistant.class);
    }

    public Assistant update(String assistantId, AssistantParam param) throws ApiException, NoApiKeyException, InputRequiredException {
        if (assistantId == null || assistantId.equals("")) {
            throw new InputRequiredException("assistantId is required!");
        }
        this.serviceOption.setHttpMethod(HttpMethod.POST);
        this.serviceOption.setPath(String.format("assistants/%s", assistantId));
        DashScopeResult result = this.api.call(param, this.serviceOption);
        return (Assistant)FlattenResultBase.fromDashScopeResult(result, Assistant.class);
    }

    public ListResult<Assistant> list(GeneralListParam listParam) throws ApiException, NoApiKeyException {
        this.serviceOption.setHttpMethod(HttpMethod.GET);
        this.serviceOption.setPath("assistants");
        DashScopeResult result = this.api.get(listParam, this.serviceOption);
        Type typeOfT = new TypeToken<ListResult<Assistant>>(){}.getType();
        return (ListResult)FlattenResultBase.fromDashScopeResult(result, typeOfT);
    }

    public Assistant retrieve(String assistantId) throws ApiException, NoApiKeyException, InputRequiredException {
        return this.retrieve(assistantId, null);
    }

    public Assistant retrieve(String assistantId, String apiKey) throws ApiException, NoApiKeyException, InputRequiredException {
        if (assistantId == null || assistantId.isEmpty()) {
            throw new InputRequiredException("assistantId is required!");
        }
        this.serviceOption.setHttpMethod(HttpMethod.GET);
        this.serviceOption.setPath(String.format("assistants/%s", assistantId));
        DashScopeResult result = this.api.get(((GeneralGetParam.GeneralGetParamBuilder)GeneralGetParam.builder().apiKey(apiKey)).build(), this.serviceOption);
        return (Assistant)FlattenResultBase.fromDashScopeResult(result, Assistant.class);
    }

    public DeletionStatus delete(String assistantId) throws ApiException, NoApiKeyException, InputRequiredException {
        return this.delete(assistantId, null);
    }

    public DeletionStatus delete(String assistantId, String apiKey) throws ApiException, NoApiKeyException, InputRequiredException {
        if (assistantId == null || assistantId.isEmpty()) {
            throw new InputRequiredException("assistantId is required!");
        }
        this.serviceOption.setHttpMethod(HttpMethod.DELETE);
        this.serviceOption.setPath(String.format("assistants/%s", assistantId));
        DashScopeResult result = this.api.delete(((GeneralGetParam.GeneralGetParamBuilder)GeneralGetParam.builder().apiKey(apiKey)).build(), this.serviceOption);
        return (DeletionStatus)FlattenResultBase.fromDashScopeResult(result, DeletionStatus.class);
    }

    public AssistantFile createFile(String assistantId, AssistantFileParam param) throws ApiException, NoApiKeyException, InputRequiredException {
        if (assistantId == null || assistantId.isEmpty()) {
            throw new InputRequiredException("assistantId is required!");
        }
        this.serviceOption.setHttpMethod(HttpMethod.POST);
        this.serviceOption.setPath(String.format("assistants/%s/files", assistantId));
        DashScopeResult result = this.api.call(param, this.serviceOption);
        return (AssistantFile)FlattenResultBase.fromDashScopeResult(result, AssistantFile.class);
    }

    public ListResult<AssistantFile> listFiles(String assistantId, GeneralListParam listParam) throws ApiException, NoApiKeyException, InputRequiredException {
        if (assistantId == null || assistantId.isEmpty()) {
            throw new InputRequiredException("assistantId is required!");
        }
        this.serviceOption.setHttpMethod(HttpMethod.GET);
        this.serviceOption.setPath(String.format("assistants/%s/files", assistantId));
        DashScopeResult result = this.api.get(listParam, this.serviceOption);
        Type typeOfT = new TypeToken<ListResult<AssistantFile>>(){}.getType();
        return (ListResult)FlattenResultBase.fromDashScopeResult(result, typeOfT);
    }

    public AssistantFile retrieveFile(String assistantId, String fileId) throws ApiException, NoApiKeyException, InputRequiredException {
        return this.retrieveFile(assistantId, fileId, null);
    }

    public AssistantFile retrieveFile(String assistantId, String fileId, String apiKey) throws ApiException, NoApiKeyException, InputRequiredException {
        if (assistantId == null || assistantId.isEmpty() || fileId == null || fileId.isEmpty()) {
            throw new InputRequiredException("assistantId and fileId are required!");
        }
        this.serviceOption.setHttpMethod(HttpMethod.GET);
        this.serviceOption.setPath(String.format("assistants/%s/files/%s", assistantId, fileId));
        DashScopeResult result = this.api.get(((GeneralGetParam.GeneralGetParamBuilder)GeneralGetParam.builder().apiKey(apiKey)).build(), this.serviceOption);
        return (AssistantFile)FlattenResultBase.fromDashScopeResult(result, AssistantFile.class);
    }
}

