/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dashscope.audio.asr.transcription;

import com.alibaba.dashscope.audio.asr.transcription.TranscriptionMetrics;
import com.alibaba.dashscope.audio.asr.transcription.TranscriptionTaskResult;
import com.alibaba.dashscope.common.DashScopeResult;
import com.alibaba.dashscope.common.TaskStatus;
import com.alibaba.dashscope.exception.ApiException;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.List;

public class TranscriptionResult {
    @SerializedName(value="request_id")
    private String requestId;
    private JsonObject output;
    private JsonObject usage;
    private TaskStatus taskStatus;
    private String taskId;
    private List<TranscriptionTaskResult> results = new ArrayList<TranscriptionTaskResult>();
    private TranscriptionMetrics metrics;

    public static TranscriptionResult fromDashScopeResult(DashScopeResult dashScopeResult) throws ApiException {
        TranscriptionResult result = new TranscriptionResult();
        result.output = (JsonObject)dashScopeResult.getOutput();
        if (dashScopeResult.getUsage() != null) {
            result.usage = dashScopeResult.getUsage().getAsJsonObject();
        }
        result.requestId = dashScopeResult.getRequestId();
        if (dashScopeResult.getOutput() != null) {
            if (result.output.has("task_status")) {
                JsonElement jsonTaskStatus = result.output.get("task_status");
                result.taskStatus = jsonTaskStatus != null ? TaskStatus.valueOf(jsonTaskStatus.getAsString()) : TaskStatus.FAILED;
            }
            result.taskId = result.output.has("task_id") ? result.output.get("task_id").getAsString() : null;
            if (result.output.has("results")) {
                JsonElement jsonResults = result.output.get("results");
                if (jsonResults != null) {
                    if (result.results == null) {
                        result.results = new ArrayList<TranscriptionTaskResult>();
                    }
                    JsonArray array = jsonResults.getAsJsonArray();
                    for (JsonElement object : array) {
                        TranscriptionTaskResult taskResult = TranscriptionTaskResult.from(object.getAsJsonObject());
                        result.results.add(taskResult);
                    }
                } else {
                    result.results = new ArrayList<TranscriptionTaskResult>();
                }
            }
            if (result.output.has("task_metrics")) {
                JsonElement jsonMetrics = result.output.get("task_metrics");
                if (jsonMetrics != null) {
                    result.setMetrics(TranscriptionMetrics.from(jsonMetrics.getAsJsonObject()));
                } else {
                    result.setMetrics(new TranscriptionMetrics());
                }
            }
        }
        return result;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public JsonObject getOutput() {
        return this.output;
    }

    public JsonObject getUsage() {
        return this.usage;
    }

    public TaskStatus getTaskStatus() {
        return this.taskStatus;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public List<TranscriptionTaskResult> getResults() {
        return this.results;
    }

    public TranscriptionMetrics getMetrics() {
        return this.metrics;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public void setOutput(JsonObject output) {
        this.output = output;
    }

    public void setUsage(JsonObject usage) {
        this.usage = usage;
    }

    public void setTaskStatus(TaskStatus taskStatus) {
        this.taskStatus = taskStatus;
    }

    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    public void setResults(List<TranscriptionTaskResult> results) {
        this.results = results;
    }

    public void setMetrics(TranscriptionMetrics metrics) {
        this.metrics = metrics;
    }

    public String toString() {
        return "TranscriptionResult(requestId=" + this.getRequestId() + ", output=" + this.getOutput() + ", usage=" + this.getUsage() + ", taskStatus=" + (Object)((Object)this.getTaskStatus()) + ", taskId=" + this.getTaskId() + ", results=" + this.getResults() + ", metrics=" + this.getMetrics() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TranscriptionResult)) {
            return false;
        }
        TranscriptionResult other = (TranscriptionResult)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$requestId = this.getRequestId();
        String other$requestId = other.getRequestId();
        if (this$requestId == null ? other$requestId != null : !this$requestId.equals(other$requestId)) {
            return false;
        }
        JsonObject this$output = this.getOutput();
        JsonObject other$output = other.getOutput();
        if (this$output == null ? other$output != null : !this$output.equals(other$output)) {
            return false;
        }
        JsonObject this$usage = this.getUsage();
        JsonObject other$usage = other.getUsage();
        if (this$usage == null ? other$usage != null : !this$usage.equals(other$usage)) {
            return false;
        }
        TaskStatus this$taskStatus = this.getTaskStatus();
        TaskStatus other$taskStatus = other.getTaskStatus();
        if (this$taskStatus == null ? other$taskStatus != null : !((Object)((Object)this$taskStatus)).equals((Object)other$taskStatus)) {
            return false;
        }
        String this$taskId = this.getTaskId();
        String other$taskId = other.getTaskId();
        if (this$taskId == null ? other$taskId != null : !this$taskId.equals(other$taskId)) {
            return false;
        }
        List<TranscriptionTaskResult> this$results = this.getResults();
        List<TranscriptionTaskResult> other$results = other.getResults();
        if (this$results == null ? other$results != null : !((Object)this$results).equals(other$results)) {
            return false;
        }
        TranscriptionMetrics this$metrics = this.getMetrics();
        TranscriptionMetrics other$metrics = other.getMetrics();
        return !(this$metrics == null ? other$metrics != null : !((Object)this$metrics).equals(other$metrics));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TranscriptionResult;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $requestId = this.getRequestId();
        result = result * 59 + ($requestId == null ? 43 : $requestId.hashCode());
        JsonObject $output = this.getOutput();
        result = result * 59 + ($output == null ? 43 : $output.hashCode());
        JsonObject $usage = this.getUsage();
        result = result * 59 + ($usage == null ? 43 : $usage.hashCode());
        TaskStatus $taskStatus = this.getTaskStatus();
        result = result * 59 + ($taskStatus == null ? 43 : ((Object)((Object)$taskStatus)).hashCode());
        String $taskId = this.getTaskId();
        result = result * 59 + ($taskId == null ? 43 : $taskId.hashCode());
        List<TranscriptionTaskResult> $results = this.getResults();
        result = result * 59 + ($results == null ? 43 : ((Object)$results).hashCode());
        TranscriptionMetrics $metrics = this.getMetrics();
        result = result * 59 + ($metrics == null ? 43 : ((Object)$metrics).hashCode());
        return result;
    }
}

