/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dashscope.aigc.completion;

import com.alibaba.dashscope.aigc.completion.ChatCompletionStreamOptions;
import com.alibaba.dashscope.base.FlattenHalfDuplexParamBase;
import com.alibaba.dashscope.common.Message;
import com.alibaba.dashscope.exception.InputRequiredException;
import com.alibaba.dashscope.tools.ToolBase;
import com.alibaba.dashscope.utils.JsonUtils;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import io.reactivex.annotations.NonNull;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class ChatCompletionParam
extends FlattenHalfDuplexParamBase {
    @NonNull
    private List<Message> messages;
    @NonNull
    private String model;
    @SerializedName(value="frequency_penalty")
    Float frequencyPenalty;
    @SerializedName(value="logit_bias")
    Map<Integer, Integer> logitBias;
    Boolean logprobs;
    @SerializedName(value="top_logprobs")
    Integer topLogprobs;
    @SerializedName(value="max_tokens")
    Integer maxTokens;
    Integer n;
    @SerializedName(value="presence_penalty")
    Float presencePenalty;
    @SerializedName(value="response_format")
    String responseFormat;
    Integer seed;
    @SerializedName(value="service_tier")
    String serviceTier;
    private List<String> stop;
    Boolean stream;
    @SerializedName(value="stream_options")
    private ChatCompletionStreamOptions streamOptions;
    private Float temperature;
    @SerializedName(value="top_p")
    private Integer topP;
    private List<ToolBase> tools;
    @SerializedName(value="tool_choice")
    protected Object toolChoice;
    @SerializedName(value="parallel_tool_calls")
    private Boolean parallelToolCalls;
    private String user;

    @Override
    public JsonObject getHttpBody() {
        JsonObject requestObject = new JsonObject();
        requestObject.addProperty("model", this.model);
        requestObject.add("messages", (JsonElement)JsonUtils.toJsonArray(this.messages));
        if (this.frequencyPenalty != null) {
            requestObject.addProperty("frequency_penalty", (Number)this.frequencyPenalty);
        }
        if (this.logitBias != null) {
            requestObject.add("logit_bias", (JsonElement)JsonUtils.toJsonObject(this.logitBias));
        }
        if (this.logprobs != null) {
            requestObject.addProperty("logprobs", this.logprobs);
        }
        if (this.topLogprobs != null) {
            requestObject.addProperty("top_logprobs", (Number)this.topLogprobs);
        }
        if (this.maxTokens != null) {
            requestObject.addProperty("max_tokens", (Number)this.maxTokens);
        }
        if (this.n != null) {
            requestObject.addProperty("n", (Number)this.n);
        }
        if (this.presencePenalty != null) {
            requestObject.addProperty("presence_penalty", (Number)this.presencePenalty);
        }
        if (this.responseFormat != null) {
            requestObject.addProperty("response_format", this.responseFormat);
        }
        if (this.seed != null) {
            requestObject.addProperty("seed", (Number)this.seed);
        }
        if (this.serviceTier != null) {
            requestObject.addProperty("service_tier", this.serviceTier);
        }
        if (this.stop != null && !this.stop.isEmpty()) {
            requestObject.add("stop", (JsonElement)JsonUtils.toJsonArray(this.stop));
        }
        if (this.stream != null) {
            requestObject.addProperty("stream", this.stream);
        }
        if (this.streamOptions != null) {
            requestObject.add("stream_options", (JsonElement)JsonUtils.toJsonObject(this.streamOptions));
        }
        if (this.temperature != null) {
            requestObject.addProperty("temperature", (Number)this.temperature);
        }
        if (this.topP != null) {
            requestObject.addProperty("top_p", (Number)this.topP);
        }
        if (this.tools != null && !this.tools.isEmpty()) {
            requestObject.add("tools", (JsonElement)JsonUtils.toJsonArray(this.tools));
        }
        if (this.toolChoice != null) {
            requestObject.add("tool_choice", (JsonElement)JsonUtils.toJsonObject(this.toolChoice));
        }
        if (this.parallelToolCalls != null) {
            requestObject.addProperty("parallel_tool_calls", this.parallelToolCalls);
        }
        if (this.user != null) {
            requestObject.addProperty("user", this.user);
        }
        this.addExtraBody(requestObject);
        return requestObject;
    }

    @Override
    public void validate() throws InputRequiredException {
        if (this.model == null || this.messages.isEmpty()) {
            throw new InputRequiredException("The model and message must be set");
        }
    }

    protected ChatCompletionParam(ChatCompletionParamBuilder<?, ?> b) {
        super((FlattenHalfDuplexParamBase.FlattenHalfDuplexParamBaseBuilder<?, ?>)b);
        List<Object> stop;
        this.messages = ((ChatCompletionParamBuilder)b).messages;
        if (this.messages == null) {
            throw new NullPointerException("messages is marked non-null but is null");
        }
        this.model = ((ChatCompletionParamBuilder)b).model;
        if (this.model == null) {
            throw new NullPointerException("model is marked non-null but is null");
        }
        this.frequencyPenalty = ((ChatCompletionParamBuilder)b).frequencyPenalty;
        this.logitBias = ((ChatCompletionParamBuilder)b).logitBias;
        this.logprobs = ((ChatCompletionParamBuilder)b).logprobs;
        this.topLogprobs = ((ChatCompletionParamBuilder)b).topLogprobs;
        this.maxTokens = ((ChatCompletionParamBuilder)b).maxTokens;
        this.n = ((ChatCompletionParamBuilder)b).n;
        this.presencePenalty = ((ChatCompletionParamBuilder)b).presencePenalty;
        this.responseFormat = ((ChatCompletionParamBuilder)b).responseFormat;
        this.seed = ((ChatCompletionParamBuilder)b).seed;
        this.serviceTier = ((ChatCompletionParamBuilder)b).serviceTier;
        switch (((ChatCompletionParamBuilder)b).stop == null ? 0 : ((ChatCompletionParamBuilder)b).stop.size()) {
            case 0: {
                stop = Collections.emptyList();
                break;
            }
            case 1: {
                stop = Collections.singletonList(((ChatCompletionParamBuilder)b).stop.get(0));
                break;
            }
            default: {
                stop = Collections.unmodifiableList(new ArrayList(((ChatCompletionParamBuilder)b).stop));
            }
        }
        this.stop = stop;
        this.stream = ((ChatCompletionParamBuilder)b).stream;
        this.streamOptions = ((ChatCompletionParamBuilder)b).streamOptions;
        this.temperature = ((ChatCompletionParamBuilder)b).temperature;
        this.topP = ((ChatCompletionParamBuilder)b).topP;
        this.tools = ((ChatCompletionParamBuilder)b).tools;
        this.toolChoice = ((ChatCompletionParamBuilder)b).toolChoice;
        this.parallelToolCalls = ((ChatCompletionParamBuilder)b).parallelToolCalls;
        this.user = ((ChatCompletionParamBuilder)b).user;
    }

    public static ChatCompletionParamBuilder<?, ?> builder() {
        return new ChatCompletionParamBuilderImpl();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChatCompletionParam)) {
            return false;
        }
        ChatCompletionParam other = (ChatCompletionParam)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Float this$frequencyPenalty = this.getFrequencyPenalty();
        Float other$frequencyPenalty = other.getFrequencyPenalty();
        if (this$frequencyPenalty == null ? other$frequencyPenalty != null : !((Object)this$frequencyPenalty).equals(other$frequencyPenalty)) {
            return false;
        }
        Boolean this$logprobs = this.getLogprobs();
        Boolean other$logprobs = other.getLogprobs();
        if (this$logprobs == null ? other$logprobs != null : !((Object)this$logprobs).equals(other$logprobs)) {
            return false;
        }
        Integer this$topLogprobs = this.getTopLogprobs();
        Integer other$topLogprobs = other.getTopLogprobs();
        if (this$topLogprobs == null ? other$topLogprobs != null : !((Object)this$topLogprobs).equals(other$topLogprobs)) {
            return false;
        }
        Integer this$maxTokens = this.getMaxTokens();
        Integer other$maxTokens = other.getMaxTokens();
        if (this$maxTokens == null ? other$maxTokens != null : !((Object)this$maxTokens).equals(other$maxTokens)) {
            return false;
        }
        Integer this$n = this.getN();
        Integer other$n = other.getN();
        if (this$n == null ? other$n != null : !((Object)this$n).equals(other$n)) {
            return false;
        }
        Float this$presencePenalty = this.getPresencePenalty();
        Float other$presencePenalty = other.getPresencePenalty();
        if (this$presencePenalty == null ? other$presencePenalty != null : !((Object)this$presencePenalty).equals(other$presencePenalty)) {
            return false;
        }
        Integer this$seed = this.getSeed();
        Integer other$seed = other.getSeed();
        if (this$seed == null ? other$seed != null : !((Object)this$seed).equals(other$seed)) {
            return false;
        }
        Boolean this$stream = this.getStream();
        Boolean other$stream = other.getStream();
        if (this$stream == null ? other$stream != null : !((Object)this$stream).equals(other$stream)) {
            return false;
        }
        Float this$temperature = this.getTemperature();
        Float other$temperature = other.getTemperature();
        if (this$temperature == null ? other$temperature != null : !((Object)this$temperature).equals(other$temperature)) {
            return false;
        }
        Integer this$topP = this.getTopP();
        Integer other$topP = other.getTopP();
        if (this$topP == null ? other$topP != null : !((Object)this$topP).equals(other$topP)) {
            return false;
        }
        Boolean this$parallelToolCalls = this.getParallelToolCalls();
        Boolean other$parallelToolCalls = other.getParallelToolCalls();
        if (this$parallelToolCalls == null ? other$parallelToolCalls != null : !((Object)this$parallelToolCalls).equals(other$parallelToolCalls)) {
            return false;
        }
        List<Message> this$messages = this.getMessages();
        List<Message> other$messages = other.getMessages();
        if (this$messages == null ? other$messages != null : !((Object)this$messages).equals(other$messages)) {
            return false;
        }
        String this$model = this.getModel();
        String other$model = other.getModel();
        if (this$model == null ? other$model != null : !this$model.equals(other$model)) {
            return false;
        }
        Map<Integer, Integer> this$logitBias = this.getLogitBias();
        Map<Integer, Integer> other$logitBias = other.getLogitBias();
        if (this$logitBias == null ? other$logitBias != null : !((Object)this$logitBias).equals(other$logitBias)) {
            return false;
        }
        String this$responseFormat = this.getResponseFormat();
        String other$responseFormat = other.getResponseFormat();
        if (this$responseFormat == null ? other$responseFormat != null : !this$responseFormat.equals(other$responseFormat)) {
            return false;
        }
        String this$serviceTier = this.getServiceTier();
        String other$serviceTier = other.getServiceTier();
        if (this$serviceTier == null ? other$serviceTier != null : !this$serviceTier.equals(other$serviceTier)) {
            return false;
        }
        List<String> this$stop = this.getStop();
        List<String> other$stop = other.getStop();
        if (this$stop == null ? other$stop != null : !((Object)this$stop).equals(other$stop)) {
            return false;
        }
        ChatCompletionStreamOptions this$streamOptions = this.getStreamOptions();
        ChatCompletionStreamOptions other$streamOptions = other.getStreamOptions();
        if (this$streamOptions == null ? other$streamOptions != null : !((Object)this$streamOptions).equals(other$streamOptions)) {
            return false;
        }
        List<ToolBase> this$tools = this.getTools();
        List<ToolBase> other$tools = other.getTools();
        if (this$tools == null ? other$tools != null : !((Object)this$tools).equals(other$tools)) {
            return false;
        }
        Object this$toolChoice = this.getToolChoice();
        Object other$toolChoice = other.getToolChoice();
        if (this$toolChoice == null ? other$toolChoice != null : !this$toolChoice.equals(other$toolChoice)) {
            return false;
        }
        String this$user = this.getUser();
        String other$user = other.getUser();
        return !(this$user == null ? other$user != null : !this$user.equals(other$user));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ChatCompletionParam;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Float $frequencyPenalty = this.getFrequencyPenalty();
        result = result * 59 + ($frequencyPenalty == null ? 43 : ((Object)$frequencyPenalty).hashCode());
        Boolean $logprobs = this.getLogprobs();
        result = result * 59 + ($logprobs == null ? 43 : ((Object)$logprobs).hashCode());
        Integer $topLogprobs = this.getTopLogprobs();
        result = result * 59 + ($topLogprobs == null ? 43 : ((Object)$topLogprobs).hashCode());
        Integer $maxTokens = this.getMaxTokens();
        result = result * 59 + ($maxTokens == null ? 43 : ((Object)$maxTokens).hashCode());
        Integer $n = this.getN();
        result = result * 59 + ($n == null ? 43 : ((Object)$n).hashCode());
        Float $presencePenalty = this.getPresencePenalty();
        result = result * 59 + ($presencePenalty == null ? 43 : ((Object)$presencePenalty).hashCode());
        Integer $seed = this.getSeed();
        result = result * 59 + ($seed == null ? 43 : ((Object)$seed).hashCode());
        Boolean $stream = this.getStream();
        result = result * 59 + ($stream == null ? 43 : ((Object)$stream).hashCode());
        Float $temperature = this.getTemperature();
        result = result * 59 + ($temperature == null ? 43 : ((Object)$temperature).hashCode());
        Integer $topP = this.getTopP();
        result = result * 59 + ($topP == null ? 43 : ((Object)$topP).hashCode());
        Boolean $parallelToolCalls = this.getParallelToolCalls();
        result = result * 59 + ($parallelToolCalls == null ? 43 : ((Object)$parallelToolCalls).hashCode());
        List<Message> $messages = this.getMessages();
        result = result * 59 + ($messages == null ? 43 : ((Object)$messages).hashCode());
        String $model = this.getModel();
        result = result * 59 + ($model == null ? 43 : $model.hashCode());
        Map<Integer, Integer> $logitBias = this.getLogitBias();
        result = result * 59 + ($logitBias == null ? 43 : ((Object)$logitBias).hashCode());
        String $responseFormat = this.getResponseFormat();
        result = result * 59 + ($responseFormat == null ? 43 : $responseFormat.hashCode());
        String $serviceTier = this.getServiceTier();
        result = result * 59 + ($serviceTier == null ? 43 : $serviceTier.hashCode());
        List<String> $stop = this.getStop();
        result = result * 59 + ($stop == null ? 43 : ((Object)$stop).hashCode());
        ChatCompletionStreamOptions $streamOptions = this.getStreamOptions();
        result = result * 59 + ($streamOptions == null ? 43 : ((Object)$streamOptions).hashCode());
        List<ToolBase> $tools = this.getTools();
        result = result * 59 + ($tools == null ? 43 : ((Object)$tools).hashCode());
        Object $toolChoice = this.getToolChoice();
        result = result * 59 + ($toolChoice == null ? 43 : $toolChoice.hashCode());
        String $user = this.getUser();
        result = result * 59 + ($user == null ? 43 : $user.hashCode());
        return result;
    }

    @NonNull
    public List<Message> getMessages() {
        return this.messages;
    }

    @Override
    @NonNull
    public String getModel() {
        return this.model;
    }

    public Float getFrequencyPenalty() {
        return this.frequencyPenalty;
    }

    public Map<Integer, Integer> getLogitBias() {
        return this.logitBias;
    }

    public Boolean getLogprobs() {
        return this.logprobs;
    }

    public Integer getTopLogprobs() {
        return this.topLogprobs;
    }

    public Integer getMaxTokens() {
        return this.maxTokens;
    }

    public Integer getN() {
        return this.n;
    }

    public Float getPresencePenalty() {
        return this.presencePenalty;
    }

    public String getResponseFormat() {
        return this.responseFormat;
    }

    public Integer getSeed() {
        return this.seed;
    }

    public String getServiceTier() {
        return this.serviceTier;
    }

    public List<String> getStop() {
        return this.stop;
    }

    public Boolean getStream() {
        return this.stream;
    }

    public ChatCompletionStreamOptions getStreamOptions() {
        return this.streamOptions;
    }

    public Float getTemperature() {
        return this.temperature;
    }

    public Integer getTopP() {
        return this.topP;
    }

    public List<ToolBase> getTools() {
        return this.tools;
    }

    public Object getToolChoice() {
        return this.toolChoice;
    }

    public Boolean getParallelToolCalls() {
        return this.parallelToolCalls;
    }

    public String getUser() {
        return this.user;
    }

    public void setMessages(@NonNull List<Message> messages) {
        if (messages == null) {
            throw new NullPointerException("messages is marked non-null but is null");
        }
        this.messages = messages;
    }

    public void setModel(@NonNull String model) {
        if (model == null) {
            throw new NullPointerException("model is marked non-null but is null");
        }
        this.model = model;
    }

    public void setFrequencyPenalty(Float frequencyPenalty) {
        this.frequencyPenalty = frequencyPenalty;
    }

    public void setLogitBias(Map<Integer, Integer> logitBias) {
        this.logitBias = logitBias;
    }

    public void setLogprobs(Boolean logprobs) {
        this.logprobs = logprobs;
    }

    public void setTopLogprobs(Integer topLogprobs) {
        this.topLogprobs = topLogprobs;
    }

    public void setMaxTokens(Integer maxTokens) {
        this.maxTokens = maxTokens;
    }

    public void setN(Integer n) {
        this.n = n;
    }

    public void setPresencePenalty(Float presencePenalty) {
        this.presencePenalty = presencePenalty;
    }

    public void setResponseFormat(String responseFormat) {
        this.responseFormat = responseFormat;
    }

    public void setSeed(Integer seed) {
        this.seed = seed;
    }

    public void setServiceTier(String serviceTier) {
        this.serviceTier = serviceTier;
    }

    public void setStop(List<String> stop) {
        this.stop = stop;
    }

    public void setStream(Boolean stream) {
        this.stream = stream;
    }

    public void setStreamOptions(ChatCompletionStreamOptions streamOptions) {
        this.streamOptions = streamOptions;
    }

    public void setTemperature(Float temperature) {
        this.temperature = temperature;
    }

    public void setTopP(Integer topP) {
        this.topP = topP;
    }

    public void setTools(List<ToolBase> tools) {
        this.tools = tools;
    }

    public void setToolChoice(Object toolChoice) {
        this.toolChoice = toolChoice;
    }

    public void setParallelToolCalls(Boolean parallelToolCalls) {
        this.parallelToolCalls = parallelToolCalls;
    }

    public void setUser(String user) {
        this.user = user;
    }

    @Override
    public String toString() {
        return "ChatCompletionParam(messages=" + this.getMessages() + ", model=" + this.getModel() + ", frequencyPenalty=" + this.getFrequencyPenalty() + ", logitBias=" + this.getLogitBias() + ", logprobs=" + this.getLogprobs() + ", topLogprobs=" + this.getTopLogprobs() + ", maxTokens=" + this.getMaxTokens() + ", n=" + this.getN() + ", presencePenalty=" + this.getPresencePenalty() + ", responseFormat=" + this.getResponseFormat() + ", seed=" + this.getSeed() + ", serviceTier=" + this.getServiceTier() + ", stop=" + this.getStop() + ", stream=" + this.getStream() + ", streamOptions=" + this.getStreamOptions() + ", temperature=" + this.getTemperature() + ", topP=" + this.getTopP() + ", tools=" + this.getTools() + ", toolChoice=" + this.getToolChoice() + ", parallelToolCalls=" + this.getParallelToolCalls() + ", user=" + this.getUser() + ")";
    }

    private static final class ChatCompletionParamBuilderImpl
    extends ChatCompletionParamBuilder<ChatCompletionParam, ChatCompletionParamBuilderImpl> {
        private ChatCompletionParamBuilderImpl() {
        }

        @Override
        protected ChatCompletionParamBuilderImpl self() {
            return this;
        }

        @Override
        public ChatCompletionParam build() {
            return new ChatCompletionParam(this);
        }
    }

    public static abstract class ChatCompletionParamBuilder<C extends ChatCompletionParam, B extends ChatCompletionParamBuilder<C, B>>
    extends FlattenHalfDuplexParamBase.FlattenHalfDuplexParamBaseBuilder<C, B> {
        private List<Message> messages;
        private String model;
        private Float frequencyPenalty;
        private Map<Integer, Integer> logitBias;
        private Boolean logprobs;
        private Integer topLogprobs;
        private Integer maxTokens;
        private Integer n;
        private Float presencePenalty;
        private String responseFormat;
        private Integer seed;
        private String serviceTier;
        private ArrayList<String> stop;
        private Boolean stream;
        private ChatCompletionStreamOptions streamOptions;
        private Float temperature;
        private Integer topP;
        private List<ToolBase> tools;
        private Object toolChoice;
        private Boolean parallelToolCalls;
        private String user;

        public B messages(@NonNull List<Message> messages) {
            this.messages = messages;
            return (B)this.self();
        }

        public B model(@NonNull String model) {
            this.model = model;
            return (B)this.self();
        }

        public B frequencyPenalty(Float frequencyPenalty) {
            this.frequencyPenalty = frequencyPenalty;
            return (B)this.self();
        }

        public B logitBias(Map<Integer, Integer> logitBias) {
            this.logitBias = logitBias;
            return (B)this.self();
        }

        public B logprobs(Boolean logprobs) {
            this.logprobs = logprobs;
            return (B)this.self();
        }

        public B topLogprobs(Integer topLogprobs) {
            this.topLogprobs = topLogprobs;
            return (B)this.self();
        }

        public B maxTokens(Integer maxTokens) {
            this.maxTokens = maxTokens;
            return (B)this.self();
        }

        public B n(Integer n) {
            this.n = n;
            return (B)this.self();
        }

        public B presencePenalty(Float presencePenalty) {
            this.presencePenalty = presencePenalty;
            return (B)this.self();
        }

        public B responseFormat(String responseFormat) {
            this.responseFormat = responseFormat;
            return (B)this.self();
        }

        public B seed(Integer seed) {
            this.seed = seed;
            return (B)this.self();
        }

        public B serviceTier(String serviceTier) {
            this.serviceTier = serviceTier;
            return (B)this.self();
        }

        public B stop(String stop) {
            if (this.stop == null) {
                this.stop = new ArrayList();
            }
            this.stop.add(stop);
            return (B)this.self();
        }

        public B stop(Collection<? extends String> stop) {
            if (stop == null) {
                throw new NullPointerException("stop cannot be null");
            }
            if (this.stop == null) {
                this.stop = new ArrayList();
            }
            this.stop.addAll(stop);
            return (B)this.self();
        }

        public B clearStop() {
            if (this.stop != null) {
                this.stop.clear();
            }
            return (B)this.self();
        }

        public B stream(Boolean stream) {
            this.stream = stream;
            return (B)this.self();
        }

        public B streamOptions(ChatCompletionStreamOptions streamOptions) {
            this.streamOptions = streamOptions;
            return (B)this.self();
        }

        public B temperature(Float temperature) {
            this.temperature = temperature;
            return (B)this.self();
        }

        public B topP(Integer topP) {
            this.topP = topP;
            return (B)this.self();
        }

        public B tools(List<ToolBase> tools) {
            this.tools = tools;
            return (B)this.self();
        }

        public B toolChoice(Object toolChoice) {
            this.toolChoice = toolChoice;
            return (B)this.self();
        }

        public B parallelToolCalls(Boolean parallelToolCalls) {
            this.parallelToolCalls = parallelToolCalls;
            return (B)this.self();
        }

        public B user(String user) {
            this.user = user;
            return (B)this.self();
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        @Override
        public String toString() {
            return "ChatCompletionParam.ChatCompletionParamBuilder(super=" + super.toString() + ", messages=" + this.messages + ", model=" + this.model + ", frequencyPenalty=" + this.frequencyPenalty + ", logitBias=" + this.logitBias + ", logprobs=" + this.logprobs + ", topLogprobs=" + this.topLogprobs + ", maxTokens=" + this.maxTokens + ", n=" + this.n + ", presencePenalty=" + this.presencePenalty + ", responseFormat=" + this.responseFormat + ", seed=" + this.seed + ", serviceTier=" + this.serviceTier + ", stop=" + this.stop + ", stream=" + this.stream + ", streamOptions=" + this.streamOptions + ", temperature=" + this.temperature + ", topP=" + this.topP + ", tools=" + this.tools + ", toolChoice=" + this.toolChoice + ", parallelToolCalls=" + this.parallelToolCalls + ", user=" + this.user + ")";
        }
    }
}

