/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dashscope.audio.asr.translation;

import com.alibaba.dashscope.api.SynchronizeFullDuplexApi;
import com.alibaba.dashscope.audio.asr.translation.TranslationRecognizerParam;
import com.alibaba.dashscope.audio.asr.translation.TranslationRecognizerState;
import com.alibaba.dashscope.audio.asr.translation.results.TranslationRecognizerResult;
import com.alibaba.dashscope.audio.asr.translation.results.TranslationRecognizerResultPack;
import com.alibaba.dashscope.common.DashScopeResult;
import com.alibaba.dashscope.common.Function;
import com.alibaba.dashscope.common.OutputMode;
import com.alibaba.dashscope.common.ResultCallback;
import com.alibaba.dashscope.common.Task;
import com.alibaba.dashscope.common.TaskGroup;
import com.alibaba.dashscope.exception.ApiException;
import com.alibaba.dashscope.exception.InputRequiredException;
import com.alibaba.dashscope.exception.NoApiKeyException;
import com.alibaba.dashscope.protocol.ApiServiceOption;
import com.alibaba.dashscope.protocol.ConnectionOptions;
import com.alibaba.dashscope.protocol.Protocol;
import com.alibaba.dashscope.protocol.StreamingMode;
import io.reactivex.BackpressureStrategy;
import io.reactivex.Emitter;
import io.reactivex.Flowable;
import java.io.File;
import java.io.FileInputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.LinkedList;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TranslationRecognizerRealtime {
    private static final Logger log = LoggerFactory.getLogger(TranslationRecognizerRealtime.class);
    SynchronizeFullDuplexApi<TranslationRecognizerParamWithStream> duplexApi;
    private ApiServiceOption serviceOption;
    private Emitter<ByteBuffer> audioEmitter;
    private final Queue<AsyncCmdBuffer> cmdBuffer = new LinkedList<AsyncCmdBuffer>();
    private TranslationRecognizerState state = TranslationRecognizerState.IDLE;
    private AtomicReference<CountDownLatch> stopLatch = new AtomicReference<Object>(null);
    private long startStreamTimeStamp = -1L;
    private long firstPackageTimeStamp = -1L;
    private long stopStreamTimeStamp = -1L;
    private long onCompleteTimeStamp = -1L;
    private String preRequestId = null;

    public TranslationRecognizerRealtime() {
        this.serviceOption = ((ApiServiceOption.ApiServiceOptionBuilder)((ApiServiceOption.ApiServiceOptionBuilder)((ApiServiceOption.ApiServiceOptionBuilder)((ApiServiceOption.ApiServiceOptionBuilder)((ApiServiceOption.ApiServiceOptionBuilder)((ApiServiceOption.ApiServiceOptionBuilder)ApiServiceOption.builder().protocol(Protocol.WEBSOCKET)).streamingMode(StreamingMode.DUPLEX)).outputMode(OutputMode.ACCUMULATE)).taskGroup(TaskGroup.AUDIO.getValue())).task(Task.ASR.getValue())).function(Function.SPEECH_TRANSLATION.getValue())).build();
        this.duplexApi = new SynchronizeFullDuplexApi(this.serviceOption);
    }

    public TranslationRecognizerRealtime(String baseUrl) {
        this.serviceOption = ((ApiServiceOption.ApiServiceOptionBuilder)((ApiServiceOption.ApiServiceOptionBuilder)((ApiServiceOption.ApiServiceOptionBuilder)((ApiServiceOption.ApiServiceOptionBuilder)((ApiServiceOption.ApiServiceOptionBuilder)((ApiServiceOption.ApiServiceOptionBuilder)((ApiServiceOption.ApiServiceOptionBuilder)ApiServiceOption.builder().protocol(Protocol.WEBSOCKET)).streamingMode(StreamingMode.DUPLEX)).outputMode(OutputMode.ACCUMULATE)).taskGroup(TaskGroup.AUDIO.getValue())).task(Task.ASR.getValue())).function(Function.SPEECH_TRANSLATION.getValue())).baseWebSocketUrl(baseUrl)).build();
        this.duplexApi = new SynchronizeFullDuplexApi(this.serviceOption);
    }

    public TranslationRecognizerRealtime(String baseUrl, ConnectionOptions connectionOptions) {
        this.serviceOption = ((ApiServiceOption.ApiServiceOptionBuilder)((ApiServiceOption.ApiServiceOptionBuilder)((ApiServiceOption.ApiServiceOptionBuilder)((ApiServiceOption.ApiServiceOptionBuilder)((ApiServiceOption.ApiServiceOptionBuilder)((ApiServiceOption.ApiServiceOptionBuilder)((ApiServiceOption.ApiServiceOptionBuilder)ApiServiceOption.builder().protocol(Protocol.WEBSOCKET)).streamingMode(StreamingMode.DUPLEX)).outputMode(OutputMode.ACCUMULATE)).taskGroup(TaskGroup.AUDIO.getValue())).task(Task.ASR.getValue())).function(Function.SPEECH_TRANSLATION.getValue())).baseWebSocketUrl(baseUrl)).build();
        this.duplexApi = new SynchronizeFullDuplexApi(connectionOptions, this.serviceOption);
    }

    public Flowable<TranslationRecognizerResult> streamCall(TranslationRecognizerParam param, Flowable<ByteBuffer> audioFrame) throws ApiException, NoApiKeyException {
        this.reset();
        this.preRequestId = UUID.randomUUID().toString();
        return this.duplexApi.duplexCall(TranslationRecognizerParamWithStream.FromTranslationRecognizerParam(param, (Flowable<ByteBuffer>)audioFrame.doOnNext(buffer -> {
            if (this.startStreamTimeStamp < 0L) {
                this.startStreamTimeStamp = System.currentTimeMillis();
            }
            log.debug("send audio frame: " + buffer.remaining());
        }), this.preRequestId)).doOnComplete(() -> {
            this.stopStreamTimeStamp = System.currentTimeMillis();
        }).map(item -> TranslationRecognizerResult.fromDashScopeResult(item)).filter(item -> item != null && (item.getTranslationResult() != null || item.getTranscriptionResult() != null) && !item.isCompleteResult()).doOnNext(result -> {
            if (this.firstPackageTimeStamp < 0L) {
                this.firstPackageTimeStamp = System.currentTimeMillis();
                log.debug("first package delay: " + this.getFirstPackageDelay());
            }
            log.debug("[Recv Result] transcription: " + result.getTranslationResult() + " translation: " + result.getTranscriptionResult());
        }).doOnComplete(() -> {
            this.onCompleteTimeStamp = System.currentTimeMillis();
            log.debug("last package delay: " + this.getLastPackageDelay());
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void call(TranslationRecognizerParam param, final ResultCallback<TranslationRecognizerResult> callback) {
        block7: {
            this.reset();
            if (param == null) {
                throw new ApiException(new InputRequiredException("Parameter invalid: TranslationRecognizerParam is null"));
            }
            if (callback == null) {
                throw new ApiException(new InputRequiredException("Parameter invalid: ResultCallback is null"));
            }
            Flowable audioFrames = Flowable.create(emitter -> {
                TranslationRecognizerRealtime translationRecognizerRealtime = this;
                synchronized (translationRecognizerRealtime) {
                    if (this.cmdBuffer.size() > 0) {
                        for (AsyncCmdBuffer buffer : this.cmdBuffer) {
                            if (buffer.isStop) {
                                emitter.onComplete();
                                return;
                            }
                            emitter.onNext((Object)buffer.audioFrame);
                        }
                        this.cmdBuffer.clear();
                    }
                    this.audioEmitter = emitter;
                }
            }, (BackpressureStrategy)BackpressureStrategy.BUFFER);
            TranslationRecognizerRealtime translationRecognizerRealtime = this;
            synchronized (translationRecognizerRealtime) {
                this.state = TranslationRecognizerState.SPEECH_TRANSLATION_STARTED;
                this.cmdBuffer.clear();
            }
            this.stopLatch = new AtomicReference<CountDownLatch>(new CountDownLatch(1));
            this.preRequestId = UUID.randomUUID().toString();
            try {
                this.duplexApi.duplexCall(TranslationRecognizerParamWithStream.FromTranslationRecognizerParam(param, (Flowable<ByteBuffer>)audioFrames, this.preRequestId), new ResultCallback<DashScopeResult>(){

                    @Override
                    public void onEvent(DashScopeResult message) {
                        TranslationRecognizerResult translationRecognizerResult = TranslationRecognizerResult.fromDashScopeResult(message);
                        if (!translationRecognizerResult.isCompleteResult()) {
                            if (TranslationRecognizerRealtime.this.firstPackageTimeStamp < 0L) {
                                TranslationRecognizerRealtime.this.firstPackageTimeStamp = System.currentTimeMillis();
                                log.debug("first package delay: " + TranslationRecognizerRealtime.this.getFirstPackageDelay());
                            }
                            log.debug("[Recv Result] transcription: " + translationRecognizerResult.getTranslationResult() + " translation: " + translationRecognizerResult.getTranscriptionResult());
                            callback.onEvent(translationRecognizerResult);
                        }
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void onComplete() {
                        TranslationRecognizerRealtime.this.onCompleteTimeStamp = System.currentTimeMillis();
                        log.debug("last package delay: " + TranslationRecognizerRealtime.this.getLastPackageDelay());
                        TranslationRecognizerRealtime translationRecognizerRealtime = TranslationRecognizerRealtime.this;
                        synchronized (translationRecognizerRealtime) {
                            TranslationRecognizerRealtime.this.state = TranslationRecognizerState.IDLE;
                        }
                        callback.onComplete();
                        if (TranslationRecognizerRealtime.this.stopLatch.get() != null) {
                            ((CountDownLatch)TranslationRecognizerRealtime.this.stopLatch.get()).countDown();
                        }
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void onError(Exception e) {
                        TranslationRecognizerRealtime translationRecognizerRealtime = TranslationRecognizerRealtime.this;
                        synchronized (translationRecognizerRealtime) {
                            TranslationRecognizerRealtime.this.state = TranslationRecognizerState.IDLE;
                        }
                        ApiException apiException = new ApiException(e);
                        apiException.setStackTrace(e.getStackTrace());
                        callback.onError(apiException);
                        if (TranslationRecognizerRealtime.this.stopLatch.get() != null) {
                            ((CountDownLatch)TranslationRecognizerRealtime.this.stopLatch.get()).countDown();
                        }
                    }
                });
            }
            catch (NoApiKeyException e) {
                ApiException apiException = new ApiException(e);
                apiException.setStackTrace(e.getStackTrace());
                callback.onError(apiException);
                if (this.stopLatch.get() == null) break block7;
                this.stopLatch.get().countDown();
            }
        }
        log.debug("TranslationRecognizerRealtime started");
    }

    public TranslationRecognizerResultPack call(TranslationRecognizerParam param, File file) {
        this.reset();
        if (param == null) {
            throw new ApiException(new InputRequiredException("Parameter invalid: TranslationRecognizerParam is null"));
        }
        if (file == null || !file.canRead()) {
            throw new ApiException(new InputRequiredException("Parameter invalid: Input file is null or not exists"));
        }
        this.startStreamTimeStamp = System.currentTimeMillis();
        AtomicBoolean cancel = new AtomicBoolean(false);
        TranslationRecognizerResultPack results = new TranslationRecognizerResultPack();
        Flowable audioFrames = Flowable.create(emitter -> new Thread(() -> {
            try {
                try (FileChannel channel = new FileInputStream(file).getChannel();){
                    ByteBuffer buffer = ByteBuffer.allocate(16384);
                    while (channel.read(buffer) != -1 && !cancel.get()) {
                        buffer.flip();
                        emitter.onNext((Object)buffer);
                        buffer = ByteBuffer.allocate(16384);
                        Thread.sleep(100L);
                    }
                }
                emitter.onComplete();
                this.stopStreamTimeStamp = System.currentTimeMillis();
            }
            catch (Exception e) {
                emitter.onError((Throwable)e);
            }
        }).start(), (BackpressureStrategy)BackpressureStrategy.BUFFER);
        this.preRequestId = UUID.randomUUID().toString();
        try {
            this.duplexApi.duplexCall(TranslationRecognizerParamWithStream.FromTranslationRecognizerParam(param, (Flowable<ByteBuffer>)audioFrames, this.preRequestId)).doOnComplete(() -> {
                this.onCompleteTimeStamp = System.currentTimeMillis();
                log.debug("last package delay: " + this.getLastPackageDelay());
            }).blockingSubscribe(res -> {
                TranslationRecognizerResult translationRecognizerResult = TranslationRecognizerResult.fromDashScopeResult(res);
                if (!translationRecognizerResult.isCompleteResult() && translationRecognizerResult.isSentenceEnd()) {
                    if (this.firstPackageTimeStamp < 0L) {
                        this.firstPackageTimeStamp = System.currentTimeMillis();
                        log.debug("first package delay: " + this.getFirstPackageDelay());
                    }
                    log.debug("[Recv SentenceEnd]: transcription" + translationRecognizerResult.getTranslationResult() + ", translation: " + translationRecognizerResult.getTranscriptionResult());
                    results.setRequestId(translationRecognizerResult.getRequestId());
                    results.getTranslationResultList().add(translationRecognizerResult.getTranslationResult());
                    results.getTranscriptionResultList().add(translationRecognizerResult.getTranscriptionResult());
                    results.getUsageList().add(translationRecognizerResult.getUsage());
                }
            }, e -> {
                results.setError((Throwable)e);
                cancel.set(true);
            }, () -> {});
        }
        catch (NoApiKeyException e2) {
            throw new ApiException(e2);
        }
        if (results.getError() != null) {
            ApiException apiException = new ApiException(results.getError());
            apiException.setStackTrace(results.getError().getStackTrace());
            throw apiException;
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendAudioFrame(ByteBuffer audioFrame) {
        if (audioFrame == null) {
            throw new ApiException(new InputRequiredException("Parameter invalid: audioFrame is null"));
        }
        if (this.startStreamTimeStamp < 0L) {
            this.startStreamTimeStamp = System.currentTimeMillis();
        }
        log.debug("send audio frame: " + audioFrame.remaining());
        TranslationRecognizerRealtime translationRecognizerRealtime = this;
        synchronized (translationRecognizerRealtime) {
            if (this.state != TranslationRecognizerState.SPEECH_TRANSLATION_STARTED) {
                throw new ApiException(new InputRequiredException("State invalid: expect recognition state is started but " + this.state.getValue()));
            }
            if (this.audioEmitter == null) {
                this.cmdBuffer.add((AsyncCmdBuffer)((AsyncCmdBuffer.AsyncCmdBufferBuilder)AsyncCmdBuffer.builder().audioFrame(audioFrame)).build());
            } else {
                this.audioEmitter.onNext((Object)audioFrame);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        this.stopStreamTimeStamp = System.currentTimeMillis();
        TranslationRecognizerRealtime translationRecognizerRealtime = this;
        synchronized (translationRecognizerRealtime) {
            if (this.state != TranslationRecognizerState.SPEECH_TRANSLATION_STARTED) {
                throw new ApiException(new RuntimeException("State invalid: expect recognition state is started but " + this.state.getValue()));
            }
            if (this.audioEmitter == null) {
                this.cmdBuffer.add((AsyncCmdBuffer)((AsyncCmdBuffer.AsyncCmdBufferBuilder)AsyncCmdBuffer.builder().isStop(true)).build());
            } else {
                this.audioEmitter.onComplete();
            }
        }
        if (this.stopLatch.get() != null) {
            try {
                this.stopLatch.get().await();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private void reset() {
        this.audioEmitter = null;
        this.cmdBuffer.clear();
        this.state = TranslationRecognizerState.IDLE;
        this.stopLatch = new AtomicReference<Object>(null);
        this.startStreamTimeStamp = -1L;
        this.firstPackageTimeStamp = -1L;
        this.stopStreamTimeStamp = -1L;
        this.onCompleteTimeStamp = -1L;
        this.preRequestId = null;
    }

    public long getFirstPackageDelay() {
        return this.firstPackageTimeStamp - this.startStreamTimeStamp;
    }

    public long getLastPackageDelay() {
        return this.onCompleteTimeStamp - this.stopStreamTimeStamp;
    }

    public String getLastRequestId() {
        return this.preRequestId;
    }

    public SynchronizeFullDuplexApi<TranslationRecognizerParamWithStream> getDuplexApi() {
        return this.duplexApi;
    }

    private static class TranslationRecognizerParamWithStream
    extends TranslationRecognizerParam {
        @NonNull
        private Flowable<ByteBuffer> audioStream;

        @Override
        public Flowable<Object> getStreamingData() {
            return this.audioStream.cast(Object.class);
        }

        public static TranslationRecognizerParamWithStream FromTranslationRecognizerParam(TranslationRecognizerParam param, Flowable<ByteBuffer> audioStream, String preRequestId) {
            TranslationRecognizerParam translationRecognizerParamWithStream = ((TranslationRecognizerParamWithStreamBuilder)((TranslationRecognizerParamWithStreamBuilder)((TranslationRecognizerParamWithStreamBuilder)((TranslationRecognizerParamWithStreamBuilder)((TranslationRecognizerParam.TranslationRecognizerParamBuilder)((TranslationRecognizerParamWithStreamBuilder)((TranslationRecognizerParamWithStreamBuilder)((TranslationRecognizerParamWithStreamBuilder)((TranslationRecognizerParamWithStreamBuilder)TranslationRecognizerParamWithStream.builder().parameters(param.getParameters())).parameter("pre_task_id", preRequestId)).headers(param.getHeaders())).format(param.getFormat())).audioStream(audioStream)).disfluencyRemovalEnabled(param.isDisfluencyRemovalEnabled())).model(param.getModel())).sampleRate(param.getSampleRate())).apiKey(param.getApiKey())).build();
            if (param.getPhraseId() != null && !param.getPhraseId().isEmpty()) {
                translationRecognizerParamWithStream.setPhraseId(param.getPhraseId());
            }
            return translationRecognizerParamWithStream;
        }

        protected TranslationRecognizerParamWithStream(TranslationRecognizerParamWithStreamBuilder<?, ?> b) {
            super((TranslationRecognizerParam.TranslationRecognizerParamBuilder<?, ?>)b);
            this.audioStream = ((TranslationRecognizerParamWithStreamBuilder)b).audioStream;
            if (this.audioStream == null) {
                throw new NullPointerException("audioStream is marked non-null but is null");
            }
        }

        public static TranslationRecognizerParamWithStreamBuilder<?, ?> builder() {
            return new TranslationRecognizerParamWithStreamBuilderImpl();
        }

        private static final class TranslationRecognizerParamWithStreamBuilderImpl
        extends TranslationRecognizerParamWithStreamBuilder<TranslationRecognizerParamWithStream, TranslationRecognizerParamWithStreamBuilderImpl> {
            private TranslationRecognizerParamWithStreamBuilderImpl() {
            }

            @Override
            protected TranslationRecognizerParamWithStreamBuilderImpl self() {
                return this;
            }

            @Override
            public TranslationRecognizerParamWithStream build() {
                return new TranslationRecognizerParamWithStream(this);
            }
        }

        public static abstract class TranslationRecognizerParamWithStreamBuilder<C extends TranslationRecognizerParamWithStream, B extends TranslationRecognizerParamWithStreamBuilder<C, B>>
        extends TranslationRecognizerParam.TranslationRecognizerParamBuilder<C, B> {
            private Flowable<ByteBuffer> audioStream;

            public B audioStream(@NonNull Flowable<ByteBuffer> audioStream) {
                if (audioStream == null) {
                    throw new NullPointerException("audioStream is marked non-null but is null");
                }
                this.audioStream = audioStream;
                return (B)this.self();
            }

            @Override
            protected abstract B self();

            @Override
            public abstract C build();

            @Override
            public String toString() {
                return "TranslationRecognizerRealtime.TranslationRecognizerParamWithStream.TranslationRecognizerParamWithStreamBuilder(super=" + super.toString() + ", audioStream=" + this.audioStream + ")";
            }
        }
    }

    private static class AsyncCmdBuffer {
        private boolean isStop;
        private ByteBuffer audioFrame;

        private static boolean $default$isStop() {
            return false;
        }

        protected AsyncCmdBuffer(AsyncCmdBufferBuilder<?, ?> b) {
            this.isStop = ((AsyncCmdBufferBuilder)b).isStop$set ? ((AsyncCmdBufferBuilder)b).isStop$value : AsyncCmdBuffer.$default$isStop();
            this.audioFrame = ((AsyncCmdBufferBuilder)b).audioFrame;
        }

        public static AsyncCmdBufferBuilder<?, ?> builder() {
            return new AsyncCmdBufferBuilderImpl();
        }

        private static final class AsyncCmdBufferBuilderImpl
        extends AsyncCmdBufferBuilder<AsyncCmdBuffer, AsyncCmdBufferBuilderImpl> {
            private AsyncCmdBufferBuilderImpl() {
            }

            @Override
            protected AsyncCmdBufferBuilderImpl self() {
                return this;
            }

            @Override
            public AsyncCmdBuffer build() {
                return new AsyncCmdBuffer(this);
            }
        }

        public static abstract class AsyncCmdBufferBuilder<C extends AsyncCmdBuffer, B extends AsyncCmdBufferBuilder<C, B>> {
            private boolean isStop$set;
            private boolean isStop$value;
            private ByteBuffer audioFrame;

            public B isStop(boolean isStop) {
                this.isStop$value = isStop;
                this.isStop$set = true;
                return this.self();
            }

            public B audioFrame(ByteBuffer audioFrame) {
                this.audioFrame = audioFrame;
                return this.self();
            }

            protected abstract B self();

            public abstract C build();

            public String toString() {
                return "TranslationRecognizerRealtime.AsyncCmdBuffer.AsyncCmdBufferBuilder(isStop$value=" + this.isStop$value + ", audioFrame=" + this.audioFrame + ")";
            }
        }
    }
}

