/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.parser;

import com.alibaba.druid.sql.dialect.mysql.parser.MySqlExprParser;
import com.alibaba.druid.sql.dialect.mysql.parser.MySqlStatementParser;
import com.alibaba.druid.sql.dialect.oracle.parser.OracleExprParser;
import com.alibaba.druid.sql.dialect.oracle.parser.OracleStatementParser;
import com.alibaba.druid.sql.dialect.postgresql.parser.PGExprParser;
import com.alibaba.druid.sql.dialect.postgresql.parser.PGSQLStatementParser;
import com.alibaba.druid.sql.dialect.sqlserver.parser.SQLServerExprParser;
import com.alibaba.druid.sql.dialect.sqlserver.parser.SQLServerStatementParser;
import com.alibaba.druid.sql.parser.SQLExprParser;
import com.alibaba.druid.sql.parser.SQLStatementParser;

public class SQLParserUtils {
    public static SQLStatementParser createSQLStatementParser(String sql, String dbType) {
        if ("oracle".equals(dbType) || "AliOracle".equals(dbType)) {
            return new OracleStatementParser(sql);
        }
        if ("mysql".equals(dbType)) {
            return new MySqlStatementParser(sql);
        }
        if ("mariadb".equals(dbType)) {
            return new MySqlStatementParser(sql);
        }
        if ("postgresql".equals(dbType)) {
            return new PGSQLStatementParser(sql);
        }
        if ("sqlserver".equals(dbType)) {
            return new SQLServerStatementParser(sql);
        }
        if ("jtds".equals(dbType)) {
            return new SQLServerStatementParser(sql);
        }
        if ("h2".equals(dbType)) {
            return new MySqlStatementParser(sql);
        }
        return new SQLStatementParser(sql);
    }

    public static SQLExprParser createExprParser(String sql, String dbType) {
        if ("oracle".equals(dbType) || "AliOracle".equals(dbType)) {
            return new OracleExprParser(sql);
        }
        if ("mysql".equals(dbType) || "mariadb".equals(dbType) || "h2".equals(dbType)) {
            return new MySqlExprParser(sql);
        }
        if ("postgresql".equals(dbType)) {
            return new PGExprParser(sql);
        }
        if ("sqlserver".equals(dbType)) {
            return new SQLServerExprParser(sql);
        }
        if ("jtds".equals(dbType)) {
            return new SQLServerExprParser(sql);
        }
        return new SQLExprParser(sql);
    }
}

