/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.stat;

import com.alibaba.druid.util.IOUtils;
import com.alibaba.druid.util.JMXUtils;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.management.JMException;

public class JdbcSqlStatValue {
    protected String sql;
    protected long id;
    protected String dataSource;
    protected long executeLastStartTime;
    protected long executeBatchSizeTotal;
    protected int executeBatchSizeMax;
    protected long executeSuccessCount;
    protected long executeSpanNanoTotal;
    protected long executeSpanNanoMax;
    protected int runningCount;
    protected int concurrentMax;
    protected long resultSetHoldTimeNano;
    protected long executeAndResultSetHoldTime;
    protected String name;
    protected String file;
    protected String dbType;
    protected long executeNanoSpanMaxOccurTime;
    protected long executeErrorCount;
    protected Throwable executeErrorLast;
    protected long executeErrorLastTime;
    protected long updateCount;
    protected long updateCountMax;
    protected long fetchRowCount;
    protected long fetchRowCountMax;
    protected long inTransactionCount;
    protected String lastSlowParameters;
    protected long clobOpenCount;
    protected long blobOpenCount;
    protected long readStringLength;
    protected long readBytesLength;
    protected long inputStreamOpenCount;
    protected long readerOpenCount;
    protected long histogram_0_1;
    protected long histogram_1_10;
    protected int histogram_10_100;
    protected int histogram_100_1000;
    protected int histogram_1000_10000;
    protected int histogram_10000_100000;
    protected int histogram_100000_1000000;
    protected int histogram_1000000_more;
    protected long executeAndResultHoldTime_0_1;
    protected long executeAndResultHoldTime_1_10;
    protected int executeAndResultHoldTime_10_100;
    protected int executeAndResultHoldTime_100_1000;
    protected int executeAndResultHoldTime_1000_10000;
    protected int executeAndResultHoldTime_10000_100000;
    protected int executeAndResultHoldTime_100000_1000000;
    protected int executeAndResultHoldTime_1000000_more;
    protected long fetchRowCount_0_1;
    protected long fetchRowCount_1_10;
    protected long fetchRowCount_10_100;
    protected int fetchRowCount_100_1000;
    protected int fetchRowCount_1000_10000;
    protected int fetchRowCount_10000_more;
    protected long updateCount_0_1;
    protected long updateCount_1_10;
    protected long updateCount_10_100;
    protected int updateCount_100_1000;
    protected int updateCount_1000_10000;
    protected int updateCount_10000_more;

    public long[] getExecuteHistogram() {
        return new long[]{this.histogram_0_1, this.histogram_1_10, this.histogram_10_100, this.histogram_100_1000, this.histogram_1000_10000, this.histogram_10000_100000, this.histogram_100000_1000000, this.histogram_1000000_more};
    }

    public long[] getExecuteAndResultHoldHistogram() {
        return new long[]{this.executeAndResultHoldTime_0_1, this.executeAndResultHoldTime_1_10, this.executeAndResultHoldTime_10_100, this.executeAndResultHoldTime_100_1000, this.executeAndResultHoldTime_1000_10000, this.executeAndResultHoldTime_10000_100000, this.executeAndResultHoldTime_100000_1000000, this.executeAndResultHoldTime_1000000_more};
    }

    public long[] getFetchRowHistogram() {
        return new long[]{this.fetchRowCount_0_1, this.fetchRowCount_1_10, this.fetchRowCount_10_100, this.fetchRowCount_100_1000, this.fetchRowCount_1000_10000, this.fetchRowCount_10000_more};
    }

    public long[] getUpdateHistogram() {
        return new long[]{this.updateCount_0_1, this.updateCount_1_10, this.updateCount_10_100, this.updateCount_100_1000, this.updateCount_1000_10000, this.updateCount_10000_more};
    }

    public long getExecuteCount() {
        return this.executeErrorCount + this.executeSuccessCount;
    }

    public long getExecuteMillisMax() {
        return this.executeSpanNanoMax / 1000000L;
    }

    public long getExecuteMillisTotal() {
        return this.executeSpanNanoTotal / 1000000L;
    }

    public String getSql() {
        return this.sql;
    }

    public void setSql(String sql) {
        this.sql = sql;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public String getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(String dataSource) {
        this.dataSource = dataSource;
    }

    public long getExecuteLastStartTimeMillis() {
        return this.executeLastStartTime;
    }

    public Date getExecuteLastStartTime() {
        if (this.executeLastStartTime <= 0L) {
            return null;
        }
        return new Date(this.executeLastStartTime);
    }

    public void setExecuteLastStartTime(long executeLastStartTime) {
        this.executeLastStartTime = executeLastStartTime;
    }

    public long getExecuteBatchSizeTotal() {
        return this.executeBatchSizeTotal;
    }

    public void setExecuteBatchSizeTotal(long executeBatchSizeTotal) {
        this.executeBatchSizeTotal = executeBatchSizeTotal;
    }

    public int getExecuteBatchSizeMax() {
        return this.executeBatchSizeMax;
    }

    public void setExecuteBatchSizeMax(int executeBatchSizeMax) {
        this.executeBatchSizeMax = executeBatchSizeMax;
    }

    public long getExecuteSuccessCount() {
        return this.executeSuccessCount;
    }

    public void setExecuteSuccessCount(long executeSuccessCount) {
        this.executeSuccessCount = executeSuccessCount;
    }

    public long getExecuteSpanNanoTotal() {
        return this.executeSpanNanoTotal;
    }

    public void setExecuteSpanNanoTotal(long executeSpanNanoTotal) {
        this.executeSpanNanoTotal = executeSpanNanoTotal;
    }

    public long getExecuteSpanNanoMax() {
        return this.executeSpanNanoMax;
    }

    public void setExecuteSpanNanoMax(long executeSpanNanoMax) {
        this.executeSpanNanoMax = executeSpanNanoMax;
    }

    public int getRunningCount() {
        return this.runningCount;
    }

    public void setRunningCount(int runningCount) {
        this.runningCount = runningCount;
    }

    public int getConcurrentMax() {
        return this.concurrentMax;
    }

    public void setConcurrentMax(int concurrentMax) {
        this.concurrentMax = concurrentMax;
    }

    public long getResultSetHoldTimeNano() {
        return this.resultSetHoldTimeNano;
    }

    public void setResultSetHoldTimeNano(long resultSetHoldTimeNano) {
        this.resultSetHoldTimeNano = resultSetHoldTimeNano;
    }

    public long getExecuteAndResultSetHoldTimeNano() {
        return this.executeAndResultSetHoldTime;
    }

    public void setExecuteAndResultSetHoldTime(long executeAndResultSetHoldTime) {
        this.executeAndResultSetHoldTime = executeAndResultSetHoldTime;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getFile() {
        return this.file;
    }

    public void setFile(String file) {
        this.file = file;
    }

    public String getDbType() {
        return this.dbType;
    }

    public void setDbType(String dbType) {
        this.dbType = dbType;
    }

    public long getExecuteNanoSpanMaxOccurTimeMillis() {
        return this.executeNanoSpanMaxOccurTime;
    }

    public Date getExecuteNanoSpanMaxOccurTime() {
        if (this.executeNanoSpanMaxOccurTime <= 0L) {
            return null;
        }
        return new Date(this.executeNanoSpanMaxOccurTime);
    }

    public Date getExecuteErrorLastTime() {
        if (this.executeErrorLastTime <= 0L) {
            return null;
        }
        return new Date(this.executeErrorLastTime);
    }

    public void setExecuteNanoSpanMaxOccurTime(long executeNanoSpanMaxOccurTime) {
        this.executeNanoSpanMaxOccurTime = executeNanoSpanMaxOccurTime;
    }

    public long getExecuteErrorCount() {
        return this.executeErrorCount;
    }

    public void setExecuteErrorCount(long executeErrorCount) {
        this.executeErrorCount = executeErrorCount;
    }

    public Throwable getExecuteErrorLast() {
        return this.executeErrorLast;
    }

    public void setExecuteErrorLast(Throwable executeErrorLast) {
        this.executeErrorLast = executeErrorLast;
    }

    public long getExecuteErrorLastTimeMillis() {
        return this.executeErrorLastTime;
    }

    public void setExecuteErrorLastTime(long executeErrorLastTime) {
        this.executeErrorLastTime = executeErrorLastTime;
    }

    public long getUpdateCount() {
        return this.updateCount;
    }

    public void setUpdateCount(long updateCount) {
        this.updateCount = updateCount;
    }

    public long getUpdateCountMax() {
        return this.updateCountMax;
    }

    public void setUpdateCountMax(long updateCountMax) {
        this.updateCountMax = updateCountMax;
    }

    public long getFetchRowCount() {
        return this.fetchRowCount;
    }

    public void setFetchRowCount(long fetchRowCount) {
        this.fetchRowCount = fetchRowCount;
    }

    public long getFetchRowCountMax() {
        return this.fetchRowCountMax;
    }

    public void setFetchRowCountMax(long fetchRowCountMax) {
        this.fetchRowCountMax = fetchRowCountMax;
    }

    public long getInTransactionCount() {
        return this.inTransactionCount;
    }

    public void setInTransactionCount(long inTransactionCount) {
        this.inTransactionCount = inTransactionCount;
    }

    public String getLastSlowParameters() {
        return this.lastSlowParameters;
    }

    public void setLastSlowParameters(String lastSlowParameters) {
        this.lastSlowParameters = lastSlowParameters;
    }

    public long getClobOpenCount() {
        return this.clobOpenCount;
    }

    public void setClobOpenCount(long clobOpenCount) {
        this.clobOpenCount = clobOpenCount;
    }

    public long getBlobOpenCount() {
        return this.blobOpenCount;
    }

    public void setBlobOpenCount(long blobOpenCount) {
        this.blobOpenCount = blobOpenCount;
    }

    public long getReadStringLength() {
        return this.readStringLength;
    }

    public void setReadStringLength(long readStringLength) {
        this.readStringLength = readStringLength;
    }

    public long getReadBytesLength() {
        return this.readBytesLength;
    }

    public void setReadBytesLength(long readBytesLength) {
        this.readBytesLength = readBytesLength;
    }

    public long getInputStreamOpenCount() {
        return this.inputStreamOpenCount;
    }

    public void setInputStreamOpenCount(long inputStreamOpenCount) {
        this.inputStreamOpenCount = inputStreamOpenCount;
    }

    public long getReaderOpenCount() {
        return this.readerOpenCount;
    }

    public void setReaderOpenCount(long readerOpenCount) {
        this.readerOpenCount = readerOpenCount;
    }

    public long[] getHistogramValues() {
        return new long[]{this.histogram_0_1, this.histogram_1_10, this.histogram_10_100, this.histogram_100_1000, this.histogram_1000_10000, this.histogram_10000_100000, this.histogram_100000_1000000, this.histogram_1000000_more};
    }

    public long[] getFetchRowCountHistogramValues() {
        return new long[]{this.fetchRowCount_0_1, this.fetchRowCount_1_10, this.fetchRowCount_10_100, this.fetchRowCount_100_1000, this.fetchRowCount_1000_10000, this.fetchRowCount_10000_more};
    }

    public long[] getUpdateCountHistogramValues() {
        return new long[]{this.updateCount_0_1, this.updateCount_1_10, this.updateCount_10_100, this.updateCount_100_1000, this.updateCount_1000_10000, this.updateCount_10000_more};
    }

    public long[] getExecuteAndResultHoldTimeHistogramValues() {
        return new long[]{this.executeAndResultHoldTime_0_1, this.executeAndResultHoldTime_1_10, this.executeAndResultHoldTime_10_100, this.executeAndResultHoldTime_100_1000, this.executeAndResultHoldTime_1000_10000, this.executeAndResultHoldTime_10000_100000, this.executeAndResultHoldTime_100000_1000000, this.executeAndResultHoldTime_1000000_more};
    }

    public long getResultSetHoldTimeMilis() {
        return this.getResultSetHoldTimeNano() / 1000000L;
    }

    public long getExecuteAndResultSetHoldTimeMilis() {
        return this.getExecuteAndResultSetHoldTimeNano() / 1000000L;
    }

    public Map<String, Object> getData() throws JMException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ID", this.id);
        map.put("DataSource", this.dataSource);
        map.put("SQL", this.sql);
        map.put("ExecuteCount", this.getExecuteCount());
        map.put("ErrorCount", this.getExecuteErrorCount());
        map.put("TotalTime", this.getExecuteMillisTotal());
        map.put("LastTime", this.getExecuteLastStartTime());
        map.put("MaxTimespan", this.getExecuteMillisMax());
        map.put("LastError", JMXUtils.getErrorCompositeData(this.getExecuteErrorLast()));
        map.put("EffectedRowCount", this.getUpdateCount());
        map.put("FetchRowCount", this.getFetchRowCount());
        map.put("MaxTimespanOccurTime", this.getExecuteNanoSpanMaxOccurTime());
        map.put("BatchSizeMax", Long.valueOf(this.getExecuteBatchSizeMax()));
        map.put("BatchSizeTotal", this.getExecuteBatchSizeTotal());
        map.put("ConcurrentMax", Long.valueOf(this.getConcurrentMax()));
        map.put("RunningCount", Long.valueOf(this.getRunningCount()));
        map.put("Name", this.getName());
        map.put("File", this.getFile());
        Throwable lastError = this.executeErrorLast;
        if (lastError != null) {
            map.put("LastErrorMessage", lastError.getMessage());
            map.put("LastErrorClass", lastError.getClass().getName());
            map.put("LastErrorStackTrace", IOUtils.getStackTrace(lastError));
            map.put("LastErrorTime", new Date(this.executeErrorLastTime));
        } else {
            map.put("LastErrorMessage", null);
            map.put("LastErrorClass", null);
            map.put("LastErrorStackTrace", null);
            map.put("LastErrorTime", null);
        }
        map.put("DbType", this.dbType);
        map.put("URL", null);
        map.put("InTransactionCount", this.getInTransactionCount());
        map.put("Histogram", this.getHistogramValues());
        map.put("LastSlowParameters", this.lastSlowParameters);
        map.put("ResultSetHoldTime", this.getResultSetHoldTimeMilis());
        map.put("ExecuteAndResultSetHoldTime", this.getExecuteAndResultSetHoldTimeMilis());
        map.put("FetchRowCountHistogram", this.getFetchRowCountHistogramValues());
        map.put("EffectedRowCountHistogram", this.getUpdateCountHistogramValues());
        map.put("ExecuteAndResultHoldTimeHistogram", this.getExecuteAndResultHoldTimeHistogramValues());
        map.put("EffectedRowCountMax", this.getUpdateCountMax());
        map.put("FetchRowCountMax", this.getFetchRowCountMax());
        map.put("ClobOpenCount", this.getClobOpenCount());
        map.put("BlobOpenCount", this.getBlobOpenCount());
        map.put("ReadStringLength", this.getReadStringLength());
        map.put("ReadBytesLength", this.getReadBytesLength());
        map.put("InputStreamOpenCount", this.getInputStreamOpenCount());
        map.put("ReaderOpenCount", this.getReaderOpenCount());
        return map;
    }
}

