/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.support.console;

import java.util.List;

public class TableFormatter {
    public static String format(List<String[]> rows) {
        String[] titlerow = rows.get(0);
        int[] maxLens = new int[titlerow.length];
        for (int i = 0; i < rows.size(); ++i) {
            String[] row = rows.get(i);
            for (int j = 0; j < row.length; ++j) {
                int len = TableFormatter.displayLen(row[j]);
                if (len <= maxLens[j]) continue;
                maxLens[j] = len;
            }
        }
        StringBuilder sb = new StringBuilder();
        sb.append(TableFormatter.makeSplitLine(maxLens));
        for (int i = 0; i < rows.size(); ++i) {
            String[] row = rows.get(i);
            sb.append("|");
            for (int j = 0; j < row.length; ++j) {
                sb.append(TableFormatter.padStr(row[j], maxLens[j]));
                sb.append(" |");
            }
            sb.append("\n");
            if (i != 0) continue;
            sb.append(TableFormatter.makeSplitLine(maxLens));
        }
        sb.append(TableFormatter.makeSplitLine(maxLens));
        return sb.toString();
    }

    public static String makeSplitLine(int[] maxLens) {
        StringBuilder sb = new StringBuilder("+");
        for (int len : maxLens) {
            for (int i = 0; i < len; ++i) {
                sb.append("-");
            }
            sb.append("-+");
        }
        sb.append("\n");
        return sb.toString();
    }

    public static int displayLen(String value) {
        return value.length();
    }

    public static String padStr(String old, int length) {
        if (old == null) {
            return "";
        }
        int vlen = TableFormatter.displayLen(old);
        if (vlen > length) {
            return old;
        }
        StringBuffer sb = new StringBuffer(old);
        for (int i = 0; i < length - vlen; ++i) {
            sb.append(" ");
        }
        return sb.toString();
    }
}

